/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.filter;

import cn.ibizlab.util.filter.ISearchContext;
import cn.ibizlab.util.filter.QueryFilter;
import cn.ibizlab.util.filter.SearchCondition;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.ObjectUtils;

public class SearchContextBase
implements ISearchContext {
    private static final Logger log = LoggerFactory.getLogger(SearchContextBase.class);
    @JsonProperty(value="customcond")
    @JSONField(name="customcond")
    public String customCond;
    @JsonProperty(value="customparams")
    @JSONField(name="customparams")
    public String customParams;
    @JsonProperty(value="searchconds")
    @JSONField(name="searchconds")
    public List<SearchCondition> searchConditions;
    @JsonProperty(value="query")
    @JSONField(name="query")
    public String query;
    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    public QueryFilter filter;
    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    public List dataQueryList;
    public int page = 0;
    public int size = 1000;
    public String sort;
    public long offset;
    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    public Sort pageSort;
    public String userTaskId;
    public String processDefinitionKey;
    @JsonProperty(value="srfwf")
    @JSONField(name="srfwf")
    public String srfWF;
    @JsonProperty(value="srfparentdename")
    @JSONField(name="srfparentdename")
    public String contextParentEntity;
    @JsonProperty(value="srfparentkey")
    @JSONField(name="srfparentkey")
    public Serializable contextParentKey;
    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    Map<String, Object> params = new HashMap<String, Object>();

    @Override
    @JsonIgnore
    @JSONField(serialize=false)
    public QueryFilter getFilter() {
        if (this.filter == null) {
            this.filter = QueryFilter.createQuery();
            if (!ObjectUtils.isEmpty(this.searchConditions)) {
                this.searchConditions.forEach(cond -> this.filter.and(cond.getFilter()));
            }
        }
        return this.filter;
    }

    public String getUserTaskId() {
        if (ObjectUtils.isEmpty((Object)this.userTaskId)) {
            Object taskId = this.params.get("usertaskid");
            return ObjectUtils.isEmpty((Object)taskId) ? null : String.valueOf(taskId);
        }
        return this.userTaskId;
    }

    public String getProcessDefinitionKey() {
        if (ObjectUtils.isEmpty((Object)this.processDefinitionKey)) {
            Object processKey = this.params.get("processdefinitionkey");
            return ObjectUtils.isEmpty((Object)processKey) ? null : String.valueOf(processKey);
        }
        return this.processDefinitionKey;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    public Pageable getPageable() {
        if (ObjectUtils.isEmpty((Object)this.pageSort)) {
            return PageRequest.of((int)this.page, (int)this.size);
        }
        return PageRequest.of((int)this.page, (int)this.size, (Sort)this.pageSort);
    }

    public void setSort(String strSort) {
        this.sort = strSort;
        if (!ObjectUtils.isEmpty((Object)strSort)) {
            String[] sortArr;
            for (String str : sortArr = strSort.split(";")) {
                String[] sort = str.split(",");
                String sortField = sort[0];
                String sortDirection = sort[1];
                if (sortDirection.equalsIgnoreCase("asc")) {
                    if (this.pageSort == null) {
                        this.pageSort = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{sortField});
                        continue;
                    }
                    this.pageSort = this.pageSort.and(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{sortField}));
                    continue;
                }
                if (!sortDirection.equalsIgnoreCase("desc")) continue;
                this.pageSort = this.pageSort == null ? Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{sortField}) : this.pageSort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{sortField}));
            }
        }
    }

    public void setContextParentKey(Serializable contextParentKey) {
        this.getDatacontext().put("srfparentkey", contextParentKey);
        this.contextParentKey = contextParentKey;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    public Map<String, Object> getDatacontext() {
        return this.params;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    public Map<String, Object> getWebcontext() {
        return this.params;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    public Map<String, Object> getSessioncontext() {
        return AuthenticationUser.getAuthenticationUser().getSessionParams();
    }

    @JsonAnyGetter
    @JSONField(name="_any", unwrapped=true, serialize=true, deserialize=false)
    public Map<String, Object> any() {
        return this.params;
    }

    @Override
    @JsonAnySetter
    @JSONField(name="_any", unwrapped=true, serialize=false, deserialize=true)
    public void set(String name, Object value) {
        this.params.put(name, value);
    }

    @Override
    public Object get(String field) {
        return this.params.get(field);
    }

    public String getCustomCond() {
        return this.customCond;
    }

    public String getCustomParams() {
        return this.customParams;
    }

    public List<SearchCondition> getSearchConditions() {
        return this.searchConditions;
    }

    public String getQuery() {
        return this.query;
    }

    public List getDataQueryList() {
        return this.dataQueryList;
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public String getSort() {
        return this.sort;
    }

    public long getOffset() {
        return this.offset;
    }

    public Sort getPageSort() {
        return this.pageSort;
    }

    public String getSrfWF() {
        return this.srfWF;
    }

    public String getContextParentEntity() {
        return this.contextParentEntity;
    }

    public Serializable getContextParentKey() {
        return this.contextParentKey;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    @JsonProperty(value="customcond")
    public void setCustomCond(String customCond) {
        this.customCond = customCond;
    }

    @JsonProperty(value="customparams")
    public void setCustomParams(String customParams) {
        this.customParams = customParams;
    }

    @JsonProperty(value="searchconds")
    public void setSearchConditions(List<SearchCondition> searchConditions) {
        this.searchConditions = searchConditions;
    }

    @JsonProperty(value="query")
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    @JsonIgnore
    public void setFilter(QueryFilter filter) {
        this.filter = filter;
    }

    @JsonIgnore
    public void setDataQueryList(List dataQueryList) {
        this.dataQueryList = dataQueryList;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    @JsonIgnore
    public void setPageSort(Sort pageSort) {
        this.pageSort = pageSort;
    }

    public void setUserTaskId(String userTaskId) {
        this.userTaskId = userTaskId;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @JsonProperty(value="srfwf")
    public void setSrfWF(String srfWF) {
        this.srfWF = srfWF;
    }

    @JsonProperty(value="srfparentdename")
    public void setContextParentEntity(String contextParentEntity) {
        this.contextParentEntity = contextParentEntity;
    }

    @JsonIgnore
    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchContextBase)) {
            return false;
        }
        SearchContextBase other = (SearchContextBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        String this$customCond = this.getCustomCond();
        String other$customCond = other.getCustomCond();
        if (this$customCond == null ? other$customCond != null : !this$customCond.equals(other$customCond)) {
            return false;
        }
        String this$customParams = this.getCustomParams();
        String other$customParams = other.getCustomParams();
        if (this$customParams == null ? other$customParams != null : !this$customParams.equals(other$customParams)) {
            return false;
        }
        List<SearchCondition> this$searchConditions = this.getSearchConditions();
        List<SearchCondition> other$searchConditions = other.getSearchConditions();
        if (this$searchConditions == null ? other$searchConditions != null : !((Object)this$searchConditions).equals(other$searchConditions)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        QueryFilter this$filter = this.getFilter();
        QueryFilter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        List this$dataQueryList = this.getDataQueryList();
        List other$dataQueryList = other.getDataQueryList();
        if (this$dataQueryList == null ? other$dataQueryList != null : !((Object)this$dataQueryList).equals(other$dataQueryList)) {
            return false;
        }
        String this$sort = this.getSort();
        String other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !this$sort.equals(other$sort)) {
            return false;
        }
        Sort this$pageSort = this.getPageSort();
        Sort other$pageSort = other.getPageSort();
        if (this$pageSort == null ? other$pageSort != null : !this$pageSort.equals(other$pageSort)) {
            return false;
        }
        String this$userTaskId = this.getUserTaskId();
        String other$userTaskId = other.getUserTaskId();
        if (this$userTaskId == null ? other$userTaskId != null : !this$userTaskId.equals(other$userTaskId)) {
            return false;
        }
        String this$processDefinitionKey = this.getProcessDefinitionKey();
        String other$processDefinitionKey = other.getProcessDefinitionKey();
        if (this$processDefinitionKey == null ? other$processDefinitionKey != null : !this$processDefinitionKey.equals(other$processDefinitionKey)) {
            return false;
        }
        String this$srfWF = this.getSrfWF();
        String other$srfWF = other.getSrfWF();
        if (this$srfWF == null ? other$srfWF != null : !this$srfWF.equals(other$srfWF)) {
            return false;
        }
        String this$contextParentEntity = this.getContextParentEntity();
        String other$contextParentEntity = other.getContextParentEntity();
        if (this$contextParentEntity == null ? other$contextParentEntity != null : !this$contextParentEntity.equals(other$contextParentEntity)) {
            return false;
        }
        Serializable this$contextParentKey = this.getContextParentKey();
        Serializable other$contextParentKey = other.getContextParentKey();
        if (this$contextParentKey == null ? other$contextParentKey != null : !this$contextParentKey.equals(other$contextParentKey)) {
            return false;
        }
        Map<String, Object> this$params = this.getParams();
        Map<String, Object> other$params = other.getParams();
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchContextBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getSize();
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        String $customCond = this.getCustomCond();
        result = result * 59 + ($customCond == null ? 43 : $customCond.hashCode());
        String $customParams = this.getCustomParams();
        result = result * 59 + ($customParams == null ? 43 : $customParams.hashCode());
        List<SearchCondition> $searchConditions = this.getSearchConditions();
        result = result * 59 + ($searchConditions == null ? 43 : ((Object)$searchConditions).hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        QueryFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        List $dataQueryList = this.getDataQueryList();
        result = result * 59 + ($dataQueryList == null ? 43 : ((Object)$dataQueryList).hashCode());
        String $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        Sort $pageSort = this.getPageSort();
        result = result * 59 + ($pageSort == null ? 43 : $pageSort.hashCode());
        String $userTaskId = this.getUserTaskId();
        result = result * 59 + ($userTaskId == null ? 43 : $userTaskId.hashCode());
        String $processDefinitionKey = this.getProcessDefinitionKey();
        result = result * 59 + ($processDefinitionKey == null ? 43 : $processDefinitionKey.hashCode());
        String $srfWF = this.getSrfWF();
        result = result * 59 + ($srfWF == null ? 43 : $srfWF.hashCode());
        String $contextParentEntity = this.getContextParentEntity();
        result = result * 59 + ($contextParentEntity == null ? 43 : $contextParentEntity.hashCode());
        Serializable $contextParentKey = this.getContextParentKey();
        result = result * 59 + ($contextParentKey == null ? 43 : $contextParentKey.hashCode());
        Map<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        return result;
    }

    public String toString() {
        return "SearchContextBase(customCond=" + this.getCustomCond() + ", customParams=" + this.getCustomParams() + ", searchConditions=" + this.getSearchConditions() + ", query=" + this.getQuery() + ", filter=" + this.getFilter() + ", dataQueryList=" + this.getDataQueryList() + ", page=" + this.getPage() + ", size=" + this.getSize() + ", sort=" + this.getSort() + ", offset=" + this.getOffset() + ", pageSort=" + this.getPageSort() + ", userTaskId=" + this.getUserTaskId() + ", processDefinitionKey=" + this.getProcessDefinitionKey() + ", srfWF=" + this.getSrfWF() + ", contextParentEntity=" + this.getContextParentEntity() + ", contextParentKey=" + this.getContextParentKey() + ", params=" + this.getParams() + ")";
    }
}

