/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.filter;

import cn.ibizlab.util.filter.QueryFilter;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.annotation.Transient;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchCondition {
    @JsonProperty(value="condtype")
    @JSONField(name="condtype")
    private String condType;
    @JsonProperty(value="name")
    @JSONField(name="name")
    private String name;
    @JsonProperty(value="fieldname")
    @JSONField(name="fieldname")
    private String fieldname;
    @JsonProperty(value="condop")
    @JSONField(name="condop")
    private String condOp;
    @JsonProperty(value="value")
    @JSONField(name="value")
    private Object value;
    @JsonProperty(value="parammode")
    @JSONField(name="parammode")
    private boolean paramMode;
    @JsonProperty(value="datatype")
    @JSONField(name="datatype")
    private int dataType;
    @JsonProperty(value="valuefunc")
    @JSONField(name="valuefunc")
    private String valueFunc;
    @JsonProperty(value="option")
    @JSONField(name="option")
    private String option;
    @JsonProperty(value="searchconds")
    @JSONField(name="searchconds")
    private List<SearchCondition> searchConds;
    @JsonProperty(value="notmode")
    @JSONField(name="notmode")
    private boolean notMode;
    @JsonProperty(value="cat")
    @JSONField(name="cat")
    private String cat;
    @JsonProperty(value="customcond")
    @JSONField(name="customcond")
    private String customCond;
    @JsonProperty(value="tag")
    @JSONField(name="tag")
    private String tag;
    @JsonProperty(value="predefinedcode")
    @JSONField(name="predefinedcode")
    private String predefinedCode;
    @JsonProperty(value="predefinedtype")
    @JSONField(name="predefinedtype")
    private String predefinedType;
    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    private QueryFilter filter;

    public synchronized SearchCondition addCondition(String field, String op, Object value) {
        if (this.searchConds == null) {
            this.searchConds = new ArrayList<SearchCondition>();
        }
        this.searchConds.add(new SearchCondition().setFieldname(field).setCondType("DEFIELD").setValue(value).setCondOp(op.toUpperCase()));
        return this;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    public QueryFilter getFilter() {
        if (this.filter == null) {
            this.filter = this.getCondition(this);
        }
        return this.filter;
    }

    protected QueryFilter getCondition(SearchCondition searchCondition) {
        QueryFilter cond = null;
        String condType = searchCondition.getCondType();
        if (StringUtils.hasLength((String)condType)) {
            switch (condType) {
                case "DEFIELD": {
                    cond = this.getFieldCondition(searchCondition);
                    break;
                }
                case "GROUP": {
                    cond = this.getGroupCondition(searchCondition);
                    break;
                }
                case "ITEMS": {
                    String fieldName = searchCondition.getFieldname();
                    List<SearchCondition> items = searchCondition.getSearchConds();
                    if (!StringUtils.hasLength((String)fieldName) || items.size() <= 0) break;
                    ArrayList<QueryFilter> condItems = new ArrayList<QueryFilter>();
                    for (SearchCondition item : items) {
                        QueryFilter condItem = this.getCondition(item);
                        if (condItem == null) continue;
                        condItems.add(condItem);
                    }
                    if (condItems.size() <= 0) break;
                    cond = QueryFilter.createQuery().and(condItems);
                }
            }
        }
        return cond;
    }

    protected QueryFilter getGroupCondition(SearchCondition group) {
        QueryFilter groupCond = QueryFilter.createQuery();
        List<SearchCondition> children = group.getSearchConds();
        if (children != null && children.size() > 0) {
            ArrayList<QueryFilter> condition = new ArrayList<QueryFilter>();
            for (SearchCondition child : children) {
                QueryFilter cond = this.getCondition(child);
                if (cond == null) continue;
                condition.add(cond);
            }
            if (condition.size() > 0) {
                switch (group.getCondOp()) {
                    case "AND": {
                        groupCond.and(condition);
                        break;
                    }
                    case "OR": {
                        groupCond.or(condition);
                    }
                }
            }
        }
        return groupCond;
    }

    protected QueryFilter getFieldCondition(SearchCondition field) {
        QueryFilter fieldCond = QueryFilter.createQuery();
        String column = field.getFieldname();
        Object val = field.getValue();
        switch (field.getCondOp()) {
            case "EQ": {
                fieldCond.eq(column, val);
                break;
            }
            case "NOTEQ": {
                fieldCond.ne(column, val);
                break;
            }
            case "GT": {
                fieldCond.gt(column, val);
                break;
            }
            case "GTANDEQ": {
                fieldCond.ge(column, val);
                break;
            }
            case "LT": {
                fieldCond.lt(column, val);
                break;
            }
            case "LTANDEQ": {
                fieldCond.le(column, val);
                break;
            }
            case "ISNULL": {
                fieldCond.isnull(column);
                break;
            }
            case "ISNOTNULL": {
                fieldCond.isnotnull(column);
                break;
            }
            case "LIKE": 
            case "USERLIKE": {
                fieldCond.like(column, (String)val);
                break;
            }
            case "IN": {
                fieldCond.in(column, val);
                break;
            }
            case "NOTIN": {
                fieldCond.notin(column, val);
                break;
            }
            case "LEFTLIKE": {
                fieldCond.startsWith(column, (String)val);
                break;
            }
            case "RIGHTLIKE": {
                fieldCond.endsWith(column, (String)val);
            }
        }
        return fieldCond;
    }

    public String getCondType() {
        return this.condType;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldname() {
        return this.fieldname;
    }

    public String getCondOp() {
        return this.condOp;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isParamMode() {
        return this.paramMode;
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getValueFunc() {
        return this.valueFunc;
    }

    public String getOption() {
        return this.option;
    }

    public List<SearchCondition> getSearchConds() {
        return this.searchConds;
    }

    public boolean isNotMode() {
        return this.notMode;
    }

    public String getCat() {
        return this.cat;
    }

    public String getCustomCond() {
        return this.customCond;
    }

    public String getTag() {
        return this.tag;
    }

    public String getPredefinedCode() {
        return this.predefinedCode;
    }

    public String getPredefinedType() {
        return this.predefinedType;
    }

    @JsonProperty(value="condtype")
    public SearchCondition setCondType(String condType) {
        this.condType = condType;
        return this;
    }

    @JsonProperty(value="name")
    public SearchCondition setName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="fieldname")
    public SearchCondition setFieldname(String fieldname) {
        this.fieldname = fieldname;
        return this;
    }

    @JsonProperty(value="condop")
    public SearchCondition setCondOp(String condOp) {
        this.condOp = condOp;
        return this;
    }

    @JsonProperty(value="value")
    public SearchCondition setValue(Object value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="parammode")
    public SearchCondition setParamMode(boolean paramMode) {
        this.paramMode = paramMode;
        return this;
    }

    @JsonProperty(value="datatype")
    public SearchCondition setDataType(int dataType) {
        this.dataType = dataType;
        return this;
    }

    @JsonProperty(value="valuefunc")
    public SearchCondition setValueFunc(String valueFunc) {
        this.valueFunc = valueFunc;
        return this;
    }

    @JsonProperty(value="option")
    public SearchCondition setOption(String option) {
        this.option = option;
        return this;
    }

    @JsonProperty(value="searchconds")
    public SearchCondition setSearchConds(List<SearchCondition> searchConds) {
        this.searchConds = searchConds;
        return this;
    }

    @JsonProperty(value="notmode")
    public SearchCondition setNotMode(boolean notMode) {
        this.notMode = notMode;
        return this;
    }

    @JsonProperty(value="cat")
    public SearchCondition setCat(String cat) {
        this.cat = cat;
        return this;
    }

    @JsonProperty(value="customcond")
    public SearchCondition setCustomCond(String customCond) {
        this.customCond = customCond;
        return this;
    }

    @JsonProperty(value="tag")
    public SearchCondition setTag(String tag) {
        this.tag = tag;
        return this;
    }

    @JsonProperty(value="predefinedcode")
    public SearchCondition setPredefinedCode(String predefinedCode) {
        this.predefinedCode = predefinedCode;
        return this;
    }

    @JsonProperty(value="predefinedtype")
    public SearchCondition setPredefinedType(String predefinedType) {
        this.predefinedType = predefinedType;
        return this;
    }

    @JsonIgnore
    public SearchCondition setFilter(QueryFilter filter) {
        this.filter = filter;
        return this;
    }
}

