/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.filter;

import cn.ibizlab.util.domain.IEntity;
import cn.ibizlab.util.filter.DbTypeContextHolder;
import cn.ibizlab.util.filter.ISearchContext;
import cn.ibizlab.util.filter.Page;
import cn.ibizlab.util.filter.QueryFilter;
import cn.ibizlab.util.filter.SearchContextBase;
import cn.ibizlab.util.helper.BeanCache;
import cn.ibizlab.util.helper.JacksonUtils;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.domain.Sort;
import org.springframework.util.ObjectUtils;

public class QueryWrapperContext<T extends IEntity>
extends SearchContextBase
implements ISearchContext {
    private static final Logger log = LoggerFactory.getLogger(QueryWrapperContext.class);
    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    private BeanCache.BeanSchema beanSchema;
    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    public QueryWrapper<T> selectCond;
    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    private Map<String, Object> context = this.getParams();

    @JsonIgnore
    @JSONField(serialize=false)
    public BeanCache.BeanSchema getBeanSchema() {
        if (this.beanSchema == null) {
            ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
            Class type = (Class)parameterizedType.getActualTypeArguments()[0];
            this.beanSchema = BeanCache.BeanSchema.from(type);
        }
        return this.beanSchema;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    public Page<T> getPages() {
        ArrayList orderfieldList = new ArrayList();
        int currentPage = this.getPageable().getPageNumber();
        int pageSize = this.getPageable().getPageSize();
        Page page = ObjectUtils.isEmpty((Object)currentPage) || ObjectUtils.isEmpty((Object)pageSize) ? new Page(1L, 32767L) : new Page(currentPage + 1, pageSize);
        page.offset(this.getOffset());
        Sort sort = this.getPageable().getSort();
        if (!ObjectUtils.isEmpty((Object)sort)) {
            sort.stream().forEach(sort_order -> {
                if (sort_order.getDirection() == Sort.Direction.ASC) {
                    orderfieldList.add(new OrderItem(this.getBeanSchema().translateFieldName(sort_order.getProperty()), true));
                } else if (sort_order.getDirection() == Sort.Direction.DESC) {
                    orderfieldList.add(new OrderItem(this.getBeanSchema().translateFieldName(sort_order.getProperty()), false));
                }
            });
        }
        if (orderfieldList.size() > 0) {
            page.setOrders(orderfieldList);
        }
        return page;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    public QueryWrapper<T> getSelectCond() {
        if (this.selectCond == null) {
            Consumer<QueryWrapper<T>> queryWrapper;
            Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            this.context = (Map)JacksonUtils.toObj((Object)this, LinkedHashMap.class);
            this.selectCond = new QueryWrapper();
            QueryFilter filter = this.getFilter();
            this.context.keySet().stream().filter(e -> e instanceof String && e.startsWith("n_")).findAny().ifPresent(e -> filter.parse(this.context));
            if (!ObjectUtils.isEmpty((Object)filter) && !ObjectUtils.isEmpty(queryWrapper = this.parseQueryFilter(filter))) {
                this.selectCond.and(queryWrapper);
            }
        }
        return this.selectCond;
    }

    @Override
    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    public Map<String, Object> getDatacontext() {
        return this.context;
    }

    @Override
    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    public Map<String, Object> getWebcontext() {
        return this.context;
    }

    private Consumer<QueryWrapper<T>> parseQueryFilter(QueryFilter queryFilter) {
        if (queryFilter.any().size() == 0 && queryFilter.get$or() == null && queryFilter.get$and() == null && ObjectUtils.isEmpty((Object)this.customCond)) {
            return null;
        }
        Consumer<QueryWrapper<T>> consumer = queryWrapper -> {
            Consumer<QueryWrapper<T>> fieldConsumer = this.parseFieldMap(queryFilter.any());
            Consumer<QueryWrapper<T>> orConsumer = this.parseOrQueryFilter(queryFilter.get$or());
            Consumer<QueryWrapper<T>> andConsumer = this.parseAndQueryFilter(queryFilter.get$and());
            if (!ObjectUtils.isEmpty(fieldConsumer)) {
                queryWrapper.and(fieldConsumer);
            }
            if (!ObjectUtils.isEmpty(orConsumer)) {
                queryWrapper.and(orConsumer);
            }
            if (!ObjectUtils.isEmpty(andConsumer)) {
                queryWrapper.and(andConsumer);
            }
            if (!ObjectUtils.isEmpty((Object)this.customCond)) {
                queryWrapper.and(query -> query.apply(this.customCond.toString(), new Object[0]));
            }
        };
        return consumer;
    }

    private Consumer<QueryWrapper<T>> parseOrQueryFilter(List<QueryFilter> queryFilters) {
        if (queryFilters == null || queryFilters.size() == 0) {
            return null;
        }
        Consumer<QueryWrapper<T>> consumer = queryWrapper -> {
            for (QueryFilter queryFilter : queryFilters) {
                Consumer<QueryWrapper<T>> tempQueryWrapper = this.parseQueryFilter(queryFilter);
                queryWrapper.or(tempQueryWrapper);
            }
        };
        return consumer;
    }

    private Consumer<QueryWrapper<T>> parseAndQueryFilter(List<QueryFilter> queryFilters) {
        if (queryFilters == null || queryFilters.size() == 0) {
            return null;
        }
        Consumer<QueryWrapper<T>> consumer = queryWrapper -> {
            for (QueryFilter queryFilter : queryFilters) {
                Consumer<QueryWrapper<T>> tempQueryWrapper = this.parseQueryFilter(queryFilter);
                queryWrapper.and(tempQueryWrapper);
            }
        };
        return consumer;
    }

    private Consumer<QueryWrapper<T>> parseFieldMap(Map<String, QueryFilter.SegmentCond> fieldMap) {
        if (fieldMap.size() == 0) {
            return null;
        }
        Consumer<QueryWrapper<T>> consumer = queryWrapper -> {
            for (Map.Entry field : fieldMap.entrySet()) {
                String fieldName = this.getBeanSchema().translateFieldName((String)field.getKey());
                BeanCache.FieldItem fieldItem = this.getBeanSchema().getField(fieldName);
                if (!ObjectUtils.isEmpty((Object)fieldItem.getFieldName())) {
                    fieldName = fieldItem.getFieldName();
                    if (DbTypeContextHolder.get().equals((Object)DbType.MYSQL) && !fieldName.startsWith("`")) {
                        fieldName = String.format("`%1$s`", fieldName);
                    }
                }
                QueryFilter.SegmentCond segmentCond = (QueryFilter.SegmentCond)field.getValue();
                Map<String, Object> segmentCondMap = segmentCond.any();
                for (Map.Entry<String, Object> fieldCond : segmentCondMap.entrySet()) {
                    Object value = fieldCond.getValue();
                    switch (fieldCond.getKey()) {
                        case "$eq": {
                            queryWrapper.eq((Object)fieldName, value);
                            break;
                        }
                        case "$ne": {
                            queryWrapper.ne((Object)fieldName, value);
                            break;
                        }
                        case "$gt": {
                            queryWrapper.gt((Object)fieldName, value);
                            break;
                        }
                        case "$gte": {
                            queryWrapper.ge((Object)fieldName, value);
                            break;
                        }
                        case "$lt": {
                            queryWrapper.lt((Object)fieldName, value);
                            break;
                        }
                        case "$lte": {
                            queryWrapper.le((Object)fieldName, value);
                            break;
                        }
                        case "$null": {
                            queryWrapper.isNull((Object)fieldName);
                            break;
                        }
                        case "$notNull": {
                            queryWrapper.isNotNull((Object)fieldName);
                            break;
                        }
                        case "$in": {
                            if (value instanceof Collection) {
                                queryWrapper.in((Object)fieldName, (Collection)value);
                                break;
                            }
                            queryWrapper.in((Object)fieldName, (Object[])value.toString().split(";|,|\uff1b|\uff0c"));
                            break;
                        }
                        case "$notIn": {
                            if (value instanceof Collection) {
                                queryWrapper.notIn((Object)fieldName, (Collection)value);
                                break;
                            }
                            queryWrapper.notIn((Object)fieldName, (Object[])value.toString().split(";|,|\uff1b|\uff0c"));
                            break;
                        }
                        case "$like": {
                            queryWrapper.like((Object)fieldName, value);
                            break;
                        }
                        case "$startsWith": {
                            queryWrapper.likeRight((Object)fieldName, value);
                            break;
                        }
                        case "$endsWith": {
                            queryWrapper.likeLeft((Object)fieldName, value);
                            break;
                        }
                        case "$exists": {
                            if (value == null) break;
                            queryWrapper.exists(value.toString(), new Object[0]);
                            break;
                        }
                        case "$notExists": {
                            if (value == null) break;
                            queryWrapper.notExists(value.toString(), new Object[0]);
                            break;
                        }
                        case "$custom": {
                            if (value == null) break;
                            queryWrapper.and(query -> query.apply(value.toString(), new Object[0]));
                        }
                    }
                }
            }
        };
        return consumer;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    @JsonIgnore
    public void setBeanSchema(BeanCache.BeanSchema beanSchema) {
        this.beanSchema = beanSchema;
    }

    @JsonIgnore
    public void setSelectCond(QueryWrapper<T> selectCond) {
        this.selectCond = selectCond;
    }

    @JsonIgnore
    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryWrapperContext)) {
            return false;
        }
        QueryWrapperContext other = (QueryWrapperContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BeanCache.BeanSchema this$beanSchema = this.getBeanSchema();
        BeanCache.BeanSchema other$beanSchema = other.getBeanSchema();
        if (this$beanSchema == null ? other$beanSchema != null : !this$beanSchema.equals(other$beanSchema)) {
            return false;
        }
        QueryWrapper<T> this$selectCond = this.getSelectCond();
        QueryWrapper<T> other$selectCond = other.getSelectCond();
        if (this$selectCond == null ? other$selectCond != null : !this$selectCond.equals(other$selectCond)) {
            return false;
        }
        Map<String, Object> this$context = this.getContext();
        Map<String, Object> other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QueryWrapperContext;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BeanCache.BeanSchema $beanSchema = this.getBeanSchema();
        result = result * 59 + ($beanSchema == null ? 43 : $beanSchema.hashCode());
        QueryWrapper<T> $selectCond = this.getSelectCond();
        result = result * 59 + ($selectCond == null ? 43 : $selectCond.hashCode());
        Map<String, Object> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "QueryWrapperContext(beanSchema=" + this.getBeanSchema() + ", selectCond=" + this.getSelectCond() + ", context=" + this.getContext() + ")";
    }
}

