/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.filter;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.annotation.Transient;
import org.springframework.util.ObjectUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class QueryFilter {
    @JsonIgnore
    @Transient
    private Map<String, SegmentCond> map;
    @JsonProperty(index=999)
    private List<QueryFilter> $or;
    @JsonProperty(index=999)
    private List<QueryFilter> $and;

    public static QueryFilter createQuery() {
        QueryFilter queryFilter = new QueryFilter();
        return queryFilter;
    }

    public QueryFilter eq(String column, Object value) {
        return this.op(column, SegmentCond.eq(value));
    }

    public QueryFilter ne(String column, Object value) {
        return this.op(column, SegmentCond.ne(value));
    }

    public QueryFilter gt(String column, Object value) {
        return this.op(column, SegmentCond.gt(value));
    }

    public QueryFilter ge(String column, Object value) {
        return this.op(column, SegmentCond.ge(value));
    }

    public QueryFilter lt(String column, Object value) {
        return this.op(column, SegmentCond.lt(value));
    }

    public QueryFilter le(String column, Object value) {
        return this.op(column, SegmentCond.le(value));
    }

    public QueryFilter isnull(String column) {
        return this.op(column, SegmentCond.isnull());
    }

    public QueryFilter isnotnull(String column) {
        return this.op(column, SegmentCond.isnotnull());
    }

    public QueryFilter in(String column, String value) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return this;
        }
        return this.in(column, Arrays.asList(value.split(";|,|\uff1b|\uff0c")));
    }

    public QueryFilter in(String column, Collection value) {
        return this.op(column, SegmentCond.in(value));
    }

    public QueryFilter in(String column, Object value) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return this;
        }
        if (value instanceof Collection) {
            return this.in(column, (Collection)value);
        }
        return this.in(column, (String)value);
    }

    public QueryFilter notin(String column, String value) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return this;
        }
        return this.notin(column, Arrays.asList(value.split(";|,|\uff1b|\uff0c")));
    }

    public QueryFilter notin(String column, Collection value) {
        return this.op(column, SegmentCond.notin(value));
    }

    public QueryFilter notin(String column, Object value) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return this;
        }
        if (value instanceof Collection) {
            return this.notin(column, (Collection)value);
        }
        return this.notin(column, (String)value);
    }

    public QueryFilter like(String column, String value) {
        return this.op(column, SegmentCond.like(value));
    }

    public QueryFilter startsWith(String column, String value) {
        return this.op(column, SegmentCond.startsWith(value));
    }

    public QueryFilter endsWith(String column, String value) {
        return this.op(column, SegmentCond.endsWith(value));
    }

    public QueryFilter between(String column, Object from, Object to) {
        return this.op(column, SegmentCond.between(from, to));
    }

    public QueryFilter exist(String column, String value) {
        return this.op(column, SegmentCond.exists(value));
    }

    public QueryFilter notExist(String column, String value) {
        return this.op(column, SegmentCond.notExists(value));
    }

    public QueryFilter custom(String value) {
        return this.op("custom", SegmentCond.custom(value));
    }

    private Map<String, SegmentCond> getMap() {
        if (this.map == null) {
            this.map = new LinkedHashMap<String, SegmentCond>();
        }
        return this.map;
    }

    @JsonAnyGetter
    public Map<String, SegmentCond> any() {
        return this.getMap();
    }

    @JsonAnySetter
    public void set(String column, SegmentCond value) {
        this.getMap().put(column, value);
    }

    public List<QueryFilter> get$or() {
        return this.$or;
    }

    public void set$or(List<QueryFilter> $or) {
        this.$or = $or;
    }

    public QueryFilter or(QueryFilter ... ors) {
        if (this.$or == null) {
            this.$or = new ArrayList<QueryFilter>();
        }
        Collections.addAll(this.$or, ors);
        return this;
    }

    public QueryFilter or(List<QueryFilter> ors) {
        if (this.$or == null) {
            this.$or = new ArrayList<QueryFilter>();
        }
        this.$or.addAll(ors);
        return this;
    }

    public List<QueryFilter> get$and() {
        return this.$and;
    }

    public void set$and(List<QueryFilter> $and) {
        this.$and = $and;
    }

    public QueryFilter and(QueryFilter ... ands) {
        if (this.$and == null) {
            this.$and = new ArrayList<QueryFilter>();
        }
        Collections.addAll(this.$and, ands);
        return this;
    }

    public QueryFilter and(List<QueryFilter> ands) {
        if (this.$and == null) {
            this.$and = new ArrayList<QueryFilter>();
        }
        this.$and.addAll(ands);
        return this;
    }

    public String toString() {
        return "QueryFilter{map=" + this.map + ", $or=" + this.$or + '}';
    }

    public QueryFilter parse(Map<String, Object> objs) {
        objs.entrySet().forEach(item -> {
            String input = (String)item.getKey();
            if (input.contains("_exists__") || input.contains("_notexists__")) {
                return;
            }
            if (!input.startsWith("n_")) {
                return;
            }
            int firstIndex = input.indexOf("_");
            int lastIndex = input.lastIndexOf("_");
            if (firstIndex != -1 && lastIndex != -1 && firstIndex != lastIndex) {
                String column = input.substring(firstIndex + 1, lastIndex);
                this.op(column, SegmentCond.op(input, item.getValue()));
            }
        });
        return this;
    }

    private QueryFilter op(String column, SegmentCond segmentCond) {
        if (this.getMap().containsKey(column)) {
            this.getMap().get(column).getMap().putAll(segmentCond.getMap());
        } else {
            this.getMap().put(column, segmentCond);
        }
        return this;
    }

    public static enum Segment {
        AND("$and", "and"),
        OR("$or", "or"),
        EQ("$eq", "eq"),
        NE("$ne", "noteq"),
        GT("$gt", "gt"),
        GE("$gte", "gtandeq"),
        LT("$lt", "lt"),
        LE("$lte", "ltandeq"),
        IS_NULL("$null", "isnull"),
        IS_NOT_NULL("$notNull", "isnotnull"),
        IN("$in", "in"),
        NOT_IN("$notIn", "notin"),
        LIKE("$like", "like"),
        LEFT_LIKE("$startsWith", "leftlike"),
        RIGHT_LIKE("$endsWith", "rightlike"),
        EXISTS("$exists", "exists"),
        NOT_EXISTS("$notExists", "notexists"),
        CUSTOM("$custom", "custom");

        private final String keyword;
        private final String aliasKeyword;

        private Segment(String keyword, String aliasKeyword) {
            this.keyword = keyword;
            this.aliasKeyword = aliasKeyword;
        }

        public static Segment from(String keyword) {
            return Arrays.stream(Segment.values()).filter(item -> item.keyword.equalsIgnoreCase(keyword) || keyword.toLowerCase().endsWith("_" + item.aliasKeyword.toLowerCase()) || item.aliasKeyword.equalsIgnoreCase(keyword)).findFirst().orElseGet(() -> EQ);
        }

        public String toString() {
            return this.keyword;
        }

        public boolean equals(String codeName) {
            return this.keyword.equalsIgnoreCase(codeName) || this.aliasKeyword.endsWith("_" + this.keyword.toLowerCase());
        }
    }

    public static class SegmentCond {
        @JsonIgnore
        @Transient
        private Map<String, Object> map;

        public String toString() {
            return "SegmentCond{map=" + this.map + '}';
        }

        private Map<String, Object> getMap() {
            if (this.map == null) {
                this.map = new LinkedHashMap<String, Object>();
            }
            return this.map;
        }

        @JsonAnyGetter
        public Map<String, Object> any() {
            return this.getMap();
        }

        @JsonAnySetter
        public void set(String column, Object value) {
            this.getMap().put(column, value);
        }

        public static SegmentCond eq(Object value) {
            return SegmentCond.op(Segment.EQ, value);
        }

        public static SegmentCond ne(Object value) {
            return SegmentCond.op(Segment.NE, value);
        }

        public static SegmentCond gt(Object value) {
            return SegmentCond.op(Segment.GT, value);
        }

        public static SegmentCond ge(Object value) {
            return SegmentCond.op(Segment.GE, value);
        }

        public static SegmentCond lt(Object value) {
            return SegmentCond.op(Segment.LT, value);
        }

        public static SegmentCond le(Object value) {
            return SegmentCond.op(Segment.LE, value);
        }

        public static SegmentCond isnull() {
            return SegmentCond.op(Segment.IS_NULL, (Object)true);
        }

        public static SegmentCond isnotnull() {
            return SegmentCond.op(Segment.IS_NOT_NULL, (Object)true);
        }

        public static SegmentCond in(Collection value) {
            return SegmentCond.op(Segment.IN, (Object)value);
        }

        public static SegmentCond notin(Collection value) {
            return SegmentCond.op(Segment.NOT_IN, (Object)value);
        }

        public static SegmentCond like(String value) {
            return SegmentCond.op(Segment.LIKE, (Object)value);
        }

        public static SegmentCond startsWith(String value) {
            return SegmentCond.op(Segment.LEFT_LIKE, (Object)value);
        }

        public static SegmentCond endsWith(String value) {
            return SegmentCond.op(Segment.RIGHT_LIKE, (Object)value);
        }

        public static SegmentCond exists(String value) {
            return SegmentCond.op(Segment.EXISTS, (Object)value);
        }

        public static SegmentCond notExists(String value) {
            return SegmentCond.op(Segment.NOT_EXISTS, (Object)value);
        }

        public static SegmentCond custom(String value) {
            return SegmentCond.op(Segment.CUSTOM, (Object)value);
        }

        public static SegmentCond between(Object from, Object to) {
            SegmentCond.op(Segment.GE, from);
            return SegmentCond.op(Segment.LT, to);
        }

        public static SegmentCond op(String segment, Object value) {
            return SegmentCond.op(Segment.from(segment), value);
        }

        public static SegmentCond op(Segment segment, Object value) {
            SegmentCond segmentCond = new SegmentCond();
            segmentCond.getMap().put(segment.keyword, value);
            return segmentCond;
        }
    }
}

