/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.filter;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class DbTypeContextHolder {
    private static final String MASTER_DS_NAME = "master";
    private static final Map<String, DbType> JDBC_DB_TYPE_CACHE = new ConcurrentHashMap<String, DbType>();
    private static DbTypeContext context = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbType getDbType(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DbType dbType = JdbcUtils.getDbType((String)connection.getMetaData().getURL());
            return dbType;
        }
        catch (SQLException e) {
            DbType dbType = DbType.H2;
            return dbType;
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public static synchronized DbTypeContext getContext() {
        if (context == null) {
            context = new DbTypeContext(){

                @Override
                public DbType get() {
                    return this.peek(DbTypeContextHolder.MASTER_DS_NAME);
                }
            };
        }
        return context;
    }

    public static void register(DataSource dataSource) {
        DbTypeContextHolder.getContext().init(dataSource);
    }

    public static void register(DbTypeContext dbTypeContext) {
        context = dbTypeContext;
    }

    public static void register(DbTypeContext dbTypeContext, DataSource dataSource) {
        context = dbTypeContext;
        context.init(dataSource);
    }

    public static DbType get() {
        return DbTypeContextHolder.getContext().get();
    }

    void push(String dsName, DbType dbType) {
        DbTypeContextHolder.getContext().push(dsName, dbType);
    }

    void push(String dsName, String dbType) {
        DbTypeContextHolder.getContext().push(dsName, dbType);
    }

    public static interface DbTypeContext {
        public DbType get();

        default public void init(DataSource dataSource) {
            this.push(DbTypeContextHolder.getDbType(dataSource));
        }

        default public void push(String dbType) {
            this.push(DbType.getDbType((String)dbType));
        }

        default public void push(DbType dbType) {
            this.push(DbTypeContextHolder.MASTER_DS_NAME, dbType);
        }

        default public void push(String dsName, String dbType) {
            this.push(dsName, DbType.getDbType((String)dbType));
        }

        default public void push(String dsName, DbType dbType) {
            JDBC_DB_TYPE_CACHE.put(dsName, dbType);
        }

        default public DbType peek(String dsName) {
            if (dsName == null) {
                dsName = DbTypeContextHolder.MASTER_DS_NAME;
            }
            return JDBC_DB_TYPE_CACHE.getOrDefault(dsName, DbType.H2);
        }
    }
}

