/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.db.dialect;

import cn.ibizlab.util.security.SpringContextHolder;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectModel;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import com.baomidou.mybatisplus.extension.service.IService;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.util.TablesNamesFinder;

public class MySqlDialect
implements IDialect {
    private final Class<?>[] ignoreType = new Class[]{Short.class, Integer.class, Long.class, Double.class, Float.class, BigDecimal.class, BigInteger.class, java.util.Date.class, Date.class, Timestamp.class};

    public DialectModel buildPaginationSql(String originalSql, long offset, long limit) {
        originalSql = this.processOrder(originalSql);
        StringBuilder sql = new StringBuilder(originalSql).append(" LIMIT ").append("?");
        if (offset != 0L) {
            sql.append(",").append("?");
            return new DialectModel(sql.toString(), offset, limit).setConsumerChain();
        }
        return new DialectModel(sql.toString(), limit).setConsumer(true);
    }

    private String processOrder(String originalSql) {
        try {
            PlainSelect plainSelect;
            Select select;
            SelectBody selectBody;
            TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
            Statement statement = CCJSqlParserUtil.parse((String)originalSql);
            Class cls = null;
            String table = null;
            List tables = tablesNamesFinder.getTableList(statement);
            if (tables != null && tables.size() > 0) {
                table = ((String)tables.get(0)).replace("`", "");
            }
            Map mapperMap = SpringContextHolder.getApplicationContext().getBeansOfType(IService.class);
            for (IService baseMapper : mapperMap.values()) {
                Class domainClass = baseMapper.getEntityClass();
                TableName tableName = domainClass.getAnnotation(TableName.class);
                if (tableName == null || tableName.value() == null || !tableName.value().equals(table)) continue;
                cls = domainClass;
                break;
            }
            if (statement instanceof Select && (selectBody = (select = (Select)statement).getSelectBody()) instanceof PlainSelect && (plainSelect = (PlainSelect)selectBody).getOrderByElements() != null) {
                for (OrderByElement orderByElement : plainSelect.getOrderByElements()) {
                    Boolean ignoreOrder = false;
                    if (cls != null) {
                        for (Field field : cls.getDeclaredFields()) {
                            TableField tableField;
                            TableId tableId = field.getAnnotation(TableId.class);
                            if (tableId != null && tableId.value().equalsIgnoreCase(String.valueOf(orderByElement.getExpression()).replace("`", "")) && Arrays.asList(this.ignoreType).contains(field.getGenericType())) {
                                ignoreOrder = true;
                            }
                            if ((tableField = field.getAnnotation(TableField.class)) == null || !tableField.value().equalsIgnoreCase(String.valueOf(orderByElement.getExpression()).replace("`", "")) || !Arrays.asList(this.ignoreType).contains(field.getGenericType())) continue;
                            ignoreOrder = true;
                        }
                    }
                    if (ignoreOrder.booleanValue()) continue;
                    String str = String.format("convert(%s using gbk)", orderByElement.getExpression());
                    orderByElement.setExpression((Expression)new Column(str));
                }
                return statement.toString();
            }
            return originalSql;
        }
        catch (JSQLParserException e) {
            return originalSql;
        }
    }
}

