/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.command;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;

@JsonIgnoreProperties(value={"handler"}, ignoreUnknown=true)
public class ExecutionResult<T> {
    private int status = 200;
    private String message;
    private T body;
    private String code;
    private List list;

    public static <T> ExecutionResult<T> ok(T body) {
        ExecutionResult<T> result = new ExecutionResult<T>();
        result.status = 200;
        result.body = body;
        return result;
    }

    public static <T> ExecutionResult<T> error(String message, String ... args) {
        return ExecutionResult.error(500, message, args);
    }

    public static <T> ExecutionResult<T> error(int status, String message, String ... args) {
        ExecutionResult<T> result = new ExecutionResult<T>();
        result.status = status;
        result.message = String.format(message, args);
        return result;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    public boolean isSuccess() {
        return this.status == 200 && ObjectUtils.isEmpty((Object)this.code) || "200".equals(this.code);
    }

    @JsonIgnore
    @JSONField(serialize=false)
    public boolean isError() {
        return !this.isSuccess();
    }

    public List getList() {
        if (this.body != null) {
            if (this.body instanceof Page) {
                return ((Page)this.body).getContent();
            }
            if (this.body instanceof List) {
                return (List)this.body;
            }
            if (this.list != null) {
                return this.list;
            }
        }
        return new ArrayList();
    }

    public int getStatus() {
        return this.status;
    }

    public ExecutionResult<T> setStatus(int status) {
        this.status = status;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public ExecutionResult<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public T getBody() {
        return this.body;
    }

    public ExecutionResult<T> setBody(T body) {
        this.body = body;
        return this;
    }

    public String getCode() {
        return this.code;
    }
}

