/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.command;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;

@JsonIgnoreProperties(value={"handler"})
public class ExecutionCommandContext<T> {
    private String entity;
    private String action;
    private LinkedHashMap<String, Object> options = new LinkedHashMap();
    private LinkedHashMap<String, Object> args = new LinkedHashMap();

    public ExecutionCommandContext<T> option(String key, Object arg) {
        this.options.put(key, arg);
        return this;
    }

    public ExecutionCommandContext<T> arg(Object arg) {
        String argName = "p" + this.args.size();
        return this.arg(argName, arg);
    }

    public ExecutionCommandContext<T> arg(String key, Object arg) {
        this.args.put(key, arg);
        return this;
    }

    public Object getArg(int index) {
        return Iterables.get(this.args.values(), (int)index);
    }

    public Object getArg(String key) {
        return this.args.get(key);
    }

    public Object getOption(String key) {
        return this.options.get(key);
    }

    public String getEntity() {
        return this.entity;
    }

    public String getAction() {
        return this.action;
    }

    public LinkedHashMap<String, Object> getOptions() {
        return this.options;
    }

    public LinkedHashMap<String, Object> getArgs() {
        return this.args;
    }

    public ExecutionCommandContext<T> setEntity(String entity) {
        this.entity = entity;
        return this;
    }

    public ExecutionCommandContext<T> setAction(String action) {
        this.action = action;
        return this;
    }

    public ExecutionCommandContext<T> setOptions(LinkedHashMap<String, Object> options) {
        this.options = options;
        return this;
    }

    public ExecutionCommandContext<T> setArgs(LinkedHashMap<String, Object> args) {
        this.args = args;
        return this;
    }
}

