/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.command;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.TypeUtil;
import cn.ibizlab.util.command.ExecutionCommandContext;
import cn.ibizlab.util.command.ExecutionResult;
import cn.ibizlab.util.domain.IEntity;
import cn.ibizlab.util.helper.BeanCache;
import cn.ibizlab.util.helper.JacksonUtils;
import cn.ibizlab.util.helper.StringAdvUtils;
import cn.ibizlab.util.security.SpringContextHolder;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class ExecutionCmd {
    private static final Logger log = LoggerFactory.getLogger(ExecutionCmd.class);

    private ExecutionCmd() {
        throw new IllegalStateException("Utility class");
    }

    public static <R> ExecutionResult<R> execute(ExecutionCommandContext commandContext) {
        if (ObjectUtils.isEmpty((Object)commandContext.getEntity()) || ObjectUtils.isEmpty((Object)commandContext.getAction())) {
            return ExecutionResult.error(400, "\u7f3a\u5931\u5b9e\u4f53\u548c\u884c\u4e3a\u53c2\u6570", new String[0]);
        }
        Object target = SpringContextHolder.getBean((String)(StringAdvUtils.pascalcase((String)commandContext.getEntity()) + "Service"));
        if (target == null) {
            return ExecutionResult.error(400, "\u672a\u627e\u5230\u63a5\u53e3%1$sService", commandContext.getEntity());
        }
        try {
            if (commandContext.getOption("id") != null && commandContext.getArgs() != null) {
                BeanCache.FieldItem keyField = BeanCache.get(TypeUtil.getReturnClass((Method)ReflectUtil.getMethod(target.getClass(), (String)"getEntity", (Class[])new Class[0]))).getKeyField();
                commandContext.getArgs().values().forEach(arg -> {
                    if (arg instanceof Map) {
                        ((Map)arg).put(keyField.getCodeName().toLowerCase(), TypeUtils.cast((Object)commandContext.getOption("id"), keyField.getField().getType(), null));
                    }
                });
            }
            String methodName = null;
            methodName = commandContext.getAction().startsWith("fetch") || commandContext.getOption("fetch") != null ? commandContext.getAction().replace("fetch", "search") : StringAdvUtils.camelcase((String)commandContext.getAction());
            ArrayList clsTypes = new ArrayList();
            commandContext.getArgs().values().forEach(arg -> {
                if (arg != null) {
                    clsTypes.add(arg.getClass());
                } else {
                    clsTypes.add(Object.class);
                }
            });
            Object method = null;
            Class[] classTypes = clsTypes.toArray(new Class[clsTypes.size()]);
            boolean isDEAction = !ObjectUtils.isEmpty(commandContext.getArgs().values().stream().filter(item -> item instanceof IEntity).collect(Collectors.toList()));
            Object[] methods = ReflectUtil.getMethods(target.getClass());
            if (!ObjectUtils.isEmpty((Object[])methods)) {
                ArrayList<Method> matchMethods = new ArrayList<Method>();
                for (Object m : methods) {
                    if (!methodName.equals(((Method)m).getName()) || !ClassUtil.isAllAssignableFrom((Class[])((Method)m).getParameterTypes(), (Class[])classTypes) && (!isDEAction || !ClassUtil.isAllAssignableFrom((Class[])classTypes, (Class[])((Method)m).getParameterTypes())) || method != null && !((Method)method).getReturnType().isAssignableFrom(((Method)method).getReturnType())) continue;
                    method = m;
                    matchMethods.add((Method)m);
                }
                if (!ObjectUtils.isEmpty(matchMethods)) {
                    Object object = method = matchMethods.size() > 1 && isDEAction ? ExecutionCmd.getMethod(matchMethods) : (Method)matchMethods.get(0);
                }
                if (method == null) {
                    for (Object m : methods) {
                        if (!methodName.equalsIgnoreCase(((Method)m).getName()) || TypeUtil.getParamClasses((Method)m).length != commandContext.getArgs().size()) continue;
                        method = m;
                    }
                }
            }
            if (method == null) {
                return ExecutionResult.error(400, "\u672a\u627e\u5230\u63a5\u53e3%1$sService\u7684%2$s\u65b9\u6cd5", commandContext.getEntity(), commandContext.getAction());
            }
            ArrayList<Object> args = new ArrayList<Object>();
            Class[] types = TypeUtil.getParamClasses(method);
            if (types.length != commandContext.getArgs().size()) {
                return ExecutionResult.error(400, "\u672a\u627e\u5230\u63a5\u53e3%1$sService\u7684%2$s\u65b9\u6cd5\uff0c\u53c2\u6570\u4e2a\u6570\u4e0d\u5bf9", commandContext.getEntity(), commandContext.getAction());
            }
            if (types != null) {
                for (int i = 0; i < types.length; ++i) {
                    Class cls = types[i];
                    Object obj = commandContext.getArg(i);
                    if (obj != null && !obj.getClass().isAssignableFrom(cls)) {
                        if (cls.isArray()) {
                            args.add(JacksonUtils.toArray((String)JacksonUtils.toJson((Object)obj), (Class)TypeUtil.getClass((Type)TypeUtil.getParamTypes((Method)method)[i])));
                            continue;
                        }
                        args.add(JacksonUtils.toObj((String)JacksonUtils.toJson((Object)obj), (Class)cls));
                        continue;
                    }
                    if (obj != null && obj instanceof IEntity && obj.getClass().isAssignableFrom(cls)) {
                        args.add(JacksonUtils.toObj((String)JacksonUtils.toJson((Object)obj), (Class)cls));
                        continue;
                    }
                    args.add(obj);
                }
            }
            Object ret = ReflectUtil.invoke((Object)target, method, (Object[])args.toArray());
            return ExecutionResult.ok(ret);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528{}.{}\u5931\u8d25\uff0c{}\uff0c{}", new Object[]{commandContext.getEntity(), commandContext.getAction(), JacksonUtils.toJson((Object)commandContext), ex});
            return ExecutionResult.error("\u8c03\u7528%1$s.%2$s\u5931\u8d25\uff0c%3$s", commandContext.getEntity(), commandContext.getAction(), ex.getMessage());
        }
    }

    private static Method getMethod(List<Method> matchMethods) {
        ArrayList<Class<IEntity>> clsTypes = new ArrayList<Class<IEntity>>();
        clsTypes.add(IEntity.class);
        Class[] classTypes = clsTypes.toArray(new Class[clsTypes.size()]);
        List methods = matchMethods.stream().filter(item -> ClassUtil.isAllAssignableFrom((Class[])classTypes, (Class[])item.getParameterTypes())).collect(Collectors.toList());
        Method method = !ObjectUtils.isEmpty(methods) ? (Method)methods.get(0) : matchMethods.get(0);
        return method;
    }
}

