/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.aspect;

import cn.ibizlab.util.annotation.RepeatRequest;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.errors.InternalServerErrorException;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
@Order(value=10)
@ConditionalOnExpression(value="'${ibiz.repeatRequestCheck:true}'.equals('true')")
public class RepeatRequestAspect {
    private static final Logger log = LoggerFactory.getLogger(RepeatRequestAspect.class);
    @Autowired
    RedisTemplate redisTemplate;
    private static final String REQUEST_SUFFIX = "ibzweb_repeatRequest";
    private static final String PROCESSING = "processing";
    private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final ExpressionParser parser = new SpelExpressionParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(cn.ibizlab.util.annotation.RepeatRequest)")
    public Object check(ProceedingJoinPoint point) throws Throwable {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        if (servletRequestAttributes != null) {
            HttpServletRequest request = servletRequestAttributes.getRequest();
            Object[] args = point.getArgs();
            if (!ObjectUtils.isEmpty((Object[])args) && args[0] instanceof EntityBase) {
                Object result;
                EntityBase entity = (EntityBase)args[0];
                Method method = ((MethodSignature)point.getSignature()).getMethod();
                RepeatRequest repeatRequest = method.getAnnotation(RepeatRequest.class);
                Object entityKey = this.getEntityKey(repeatRequest.key(), method, args);
                String cacheKey = String.format("%1$s:%2$s:%3$s:%4$s", REQUEST_SUFFIX, request.getRequestURI(), entityKey, DigestUtils.md5DigestAsHex((byte[])JSON.toJSONBytes((Object)entity)));
                if (!this.redisTemplate.opsForValue().setIfAbsent((Object)cacheKey, (Object)PROCESSING, (long)repeatRequest.timeout(), TimeUnit.MILLISECONDS).booleanValue()) {
                    throw new InternalServerErrorException(repeatRequest.message());
                }
                try {
                    result = point.proceed();
                }
                finally {
                    this.redisTemplate.opsForValue().getOperations().delete((Object)cacheKey);
                }
                return result;
            }
        }
        return point.proceed();
    }

    protected Object getEntityKey(String expression, Method method, Object[] args) {
        Object id = null;
        try {
            if (!ObjectUtils.isEmpty((Object)expression)) {
                Expression oldExp = this.parser.parseExpression(expression);
                MethodBasedEvaluationContext context = new MethodBasedEvaluationContext((Object)TypedValue.NULL, method, args, parameterNameDiscoverer);
                id = oldExp.getValue((EvaluationContext)context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }
}

