package cn.ibizlab.util.tenant;

import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
@ConfigurationProperties(prefix = "ibiz.tenant")
public class TenantProperties {

    /**
     * 租户列
     */
    private String tenantIdColumn = "dc";

    /**
     * 忽略租户检查的表
     */
    private List<String> ignoreTables = new ArrayList<>();
    /**
     * feign请求头租户参数名
     */
    private String tenantHeader = "srftenantid";
    /**
     * feign请求头的租户
     */
    private String tenantId = "000000";
}
