package cn.ibizlab.util.filter;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.annotation.Transient;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Data
public class FilterBase implements ISearchContext {


    /**
     * 自定义查询条件
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    public String customCond;

    /**
     * 组合条件
     */
    @JsonProperty("searchconds")
    @JSONField(name = "searchconds")
    public List<SearchCondition> searchConditions;

    /**
     * 快速搜索
     */
    @JsonProperty("query")
    @JSONField(name = "query")
    public String query;
    /**
     * 条件表达式
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    public QueryFilter filter ;
    /**
     * 数据查询
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    public List dataQueryList;
    /**
     * 当前页数
     */
    public int page = 0;
    /**
     * 每页显示条数
     */
    public int size = 1000;
    /**
     * 排序
     */
    public String sort;
    /**
     * 偏移
     */
    public long offset;

    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    public String getUserTaskId() {
        return (String)params.get("usertaskid");
    }

    public void setUserTaskId(String userTaskId) {
        this.set("usertaskid", userTaskId);
    }

    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    public String getProcessDefinitionKey() {
        return (String)get("processdefinitionkey");
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.set("processdefinitionkey", processDefinitionKey);
    }

    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    public String getSrfWF() {
        return (String)get("srfwf");
    }

    public void setSrfWF(String srfWF) {
        this.set("srfwf", srfWF);
    }

    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    public String getContextParentEntity() {
        return (String)get("srfparentdename");
    }

    public void setContextParentEntity(String contextParentEntity) {
        this.set("srfparentdename", contextParentEntity);
    }

    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    public Serializable getContextParentKey() {
        return (Serializable)get("srfparentkey");
    }

    public void setContextParentKey(Serializable contextParentKey) {
        params.put("srfparentkey",contextParentKey);
    }

    /**
     * 上下文参数
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    Map<String, Object> params = new HashMap<String, Object>();

    @JsonAnyGetter
    @JSONField(name = "_any", unwrapped = true, serialize = true, deserialize = false)
    public Map<String, Object> any() {
        return params;
    }

    @JsonAnySetter
    @JSONField(name = "_any", unwrapped = true, serialize = false, deserialize = true)
    public void set(String name, Object value) {
        params.put(name, value);
    }

    public Object get(String field) {
        return params.get(field);
    }

}
