package cn.ibizlab.util.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class ImportResult {

    private Integer total = 0;

    private Integer success = 0;

    @JSONField(name = "errorinfo")
    @JsonProperty("errorinfo")
    private List<Item> errorInfo;

    public ImportResult addItem(Integer row, String name, String info) {
        if (errorInfo == null)
            errorInfo = new ArrayList<>();
        errorInfo.add(new Item().setRow(row).setName(name).setInfo(info));
        return this;
    }

    @Getter
    @Setter
    @NoArgsConstructor
    @AllArgsConstructor
    @Accessors(chain = true)
    public class Item {

        private Integer row;

        private String name;

        private String info;

    }
}
