package cn.ibizlab.util.domain;

import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.springframework.data.annotation.Transient;

import java.util.HashMap;
import java.util.Map;

@Data
public class Context {
    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    Map<String, Object> params = new HashMap<String, Object>();

    /**
     * 获取数据上下文
     *
     * @return
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    public Map<String, Object> getDatacontext() {
        return params;
    }

    /**
     * 获取网页请求上下文
     *
     * @return
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    public Map<String, Object> getWebcontext() {
        return params;
    }

    /**
     * 获取用户上下文
     *
     * @return
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    public Map<String, Object> getSessioncontext() {
        return AuthenticationUser.getAuthenticationUser().getSessionParams();
    }

    @JsonAnyGetter
    @JSONField(name = "_any", unwrapped = true, serialize = true, deserialize = false)
    public Map<String, Object> any() {
        return params;
    }

    @JsonAnySetter
    @JSONField(name = "_any", unwrapped = true, serialize = false, deserialize = true)
    public void set(String name, Object value) {
        params.put(name, value);
    }

    public Object get(String field) {
        return params.get(field);
    }

}
