package cn.ibizlab.util.command;

import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/")
public class ExecutionRpc {

    @PostMapping({"execute","callback"})
    public ResponseEntity<ExecutionResult> execute(@RequestBody ExecutionCommandContext body) {
        return ResponseEntity.status(HttpStatus.OK).body(ExecutionCmd.execute(body));
    }

}
