package cn.ibizlab.util.domain;

import cn.ibizlab.util.helper.ResponseWrapperSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(value = "handler")
@JsonSerialize(using = ResponseWrapperSerializer.class)
public class ResponseWrapper<T> {

  @JsonIgnore
  @JSONField(serialize = false)
  private List<T> list;

  @JsonIgnore
  @JSONField(serialize = false)
  private T dto;

  @JsonIgnore
  @JSONField(serialize = false)
  private boolean array =false;

  public ResponseWrapper<T> setList(List<T> list) {
    this.array = true;
    if (list!=null && list.size()==1)
      this.dto = list.get(0);
    this.list = list;
    return this;
  }

  public ResponseWrapper<T> setDto(T dto) {
    this.array = false;
    this.list = Arrays.asList(dto);
    this.dto = dto;
    return this;
  }

  @JsonIgnore
  @JSONField(serialize = false)
  public T get() {
    if(this.array && !ObjectUtils.isEmpty(this.list))
      return list.get(0);
    return this.dto;
  }

  public ResponseWrapper<T> set(Object content) {
    if(content.getClass().isArray())
      return setList((List<T>) content);
    else
      return setDto((T) content);
  }

  public ResponseWrapper<T> add(T content) {
    if(this.list == null)
      this.list = new ArrayList<>();
    this.array = true;
    this.list.add(content);
    return this;
  }

}