package cn.ibizlab.util.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.data.annotation.Transient;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public interface IEntity {

    Object get(String field);

    default <V> V getOrDefault(String field,V defaultValue) {
        V v;
        return ((v = (V)get(field)) != null)
                ? v
                : defaultValue;
    }

    void set(String field, Object value);

    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    default Set<String> getFocusNull() {
        return new HashSet<>();
    }

    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    default Map<String, Object> getExtensionparams() {
        return new HashMap<>();
    }

    default void reset(String field) {}

    default boolean isFocusNull(String field){
        return false;
    }



}
