package cn.ibizlab.util.domain;

import cn.ibizlab.util.helper.BeanCache;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.util.ObjectUtils;

public class EntityMP extends EntityBase {

    public <T> UpdateWrapper<T> getUpdateWrapper(boolean clean) {
        UpdateWrapper<T> wrapper=new UpdateWrapper<T>();
        for(String nullField:getFocusNull()) {
            String columnName=BeanCache.getFieldColumnName(this.getClass(),nullField);
            if(!ObjectUtils.isEmpty(columnName))
                wrapper.set(columnName,null);
        }
        if(clean) {
            getFocusNull().clear();
        }
        return  wrapper;
    }

    @Override
    public void reset(String field){
        if(!ObjectUtils.isEmpty(field)){
            String resetField=field.toLowerCase();
            this.set(resetField,null);
            getFocusNull().remove(resetField);
        }
    }
}

