package cn.ibizlab.util.command;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Iterables;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.LinkedHashMap;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(value = "handler")
public class ExecutionCommandContext<T> {

    private String entity;

    private String action;

    private LinkedHashMap<String,Object> options = new LinkedHashMap<>();
    private LinkedHashMap<String,Object> args = new LinkedHashMap<>();

    public ExecutionCommandContext<T> option(String key,Object arg) {
        options.put(key,arg);
        return this;
    }

    public ExecutionCommandContext<T> arg(Object arg) {
        String argName = "p"+args.size();
        return this.arg(argName,arg);
    }

    public ExecutionCommandContext<T> arg(String key,Object arg) {
        args.put(key,arg);
        return this;
    }

    public Object getArg(int index) {
        return Iterables.get(args.values(),index);
    }


    public Object getArg(String key) {
        return args.get(key);
    }

    public Object getOption(String key) {
        return options.get(key);
    }


}
