package cn.ibizlab.util.annotation;

import java.lang.annotation.*;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
@Inherited
@Documented
public @interface RepeatRequest {
    /**
     * 重复请求超时时长，超时后自动将请求从移除中队列中移除
     * @return
     */
    int timeout() default 0;

    /**
     * 重复请求提示信息
     * @return
     */
    String message() default "Repeat Request!";

    /**
     * 数据键值spel
     * @return
     */
    String key() default "";
}