/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.service;

import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.domain.IBZDataAudit;
import cn.ibizlab.util.helper.BeanCache;
import cn.ibizlab.util.mapper.IBZDataAuditMapper;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.service.IBZDataAuditService;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SimpleAuditService
extends ServiceImpl<IBZDataAuditMapper, IBZDataAudit>
implements IBZDataAuditService {
    private static final Logger log = LoggerFactory.getLogger(SimpleAuditService.class);
    private static List<IBZDataAudit> cacheMap = Collections.synchronizedList(new ArrayList());

    @Scheduled(fixedRate=10000L)
    public void saveAudit() {
        if (cacheMap.size() > 0) {
            log.info(String.format("\u6b63\u5728\u4fdd\u5b58\u5ba1\u8ba1\u6570\u636e\uff0c\u5f53\u524d\u5ba1\u8ba1\u96c6\u5408\u6570\u91cf\u4e3a[%s]", cacheMap.size()));
            ArrayList<IBZDataAudit> temp = new ArrayList<IBZDataAudit>();
            if (cacheMap.size() < 500) {
                temp.addAll(cacheMap);
            } else {
                temp.addAll(cacheMap.subList(0, 500));
            }
            temp.forEach(item -> log.trace("Audit:{}-{}-{}", new Object[]{item.getDataAuditName(), item.getAuditObjectData(), JSON.toJSONString((Object)item)}));
            this.saveBatch(temp);
            cacheMap.removeAll(temp);
            log.info(String.format("\u4fdd\u5b58\u5b8c\u6210\uff0c\u5f53\u524d\u5ba1\u8ba1\u96c6\u5408\u6570\u91cf\u4e3a[%s]", cacheMap.size()));
        }
    }

    @Override
    public void createAudit(HttpServletRequest request, EntityBase entity, Object idValue) {
        if (ObjectUtils.isEmpty((Object)idValue)) {
            idValue = entity.get(BeanCache.getKeyField(entity.getClass()));
        }
        IBZDataAudit dataAudit = new IBZDataAudit();
        dataAudit.setOpPersonId(AuthenticationUser.getAuthenticationUser().getUserid());
        dataAudit.setOpPersonName(String.format("%s[%s]", AuthenticationUser.getAuthenticationUser().getPersonName(), AuthenticationUser.getAuthenticationUser().getOrgName()));
        dataAudit.setAuditType("CREATE");
        dataAudit.setAuditObject(BeanCache.get(entity.getClass()).getCodeName());
        dataAudit.setDataAuditName(BeanCache.get(entity.getClass()).getLogicName() + "[\u65b0\u5efa]");
        dataAudit.setAuditObjectData(idValue);
        dataAudit.setOpTime(new Timestamp(System.currentTimeMillis()));
        if (request != null) {
            dataAudit.setIpAddress(this.getIpAddress(request, AuthenticationUser.getAuthenticationUser()));
        }
        dataAudit.setAuditInfo(this.getAuditInfo(entity));
        dataAudit.setIsDataChanged(1);
        cacheMap.add(dataAudit);
    }

    @Override
    public void updateAudit(HttpServletRequest request, EntityBase beforeEntity, EntityBase afterEntity, Object idValue) {
        if (ObjectUtils.isEmpty((Object)idValue)) {
            idValue = beforeEntity.get(BeanCache.getKeyField(beforeEntity.getClass()));
        }
        List auditInfo = this.getUpdateAuditInfo(beforeEntity, afterEntity);
        int isDataChanged = 1;
        if (ObjectUtils.isEmpty((Object)auditInfo)) {
            isDataChanged = 0;
        }
        IBZDataAudit dataAudit = new IBZDataAudit();
        dataAudit.setOpPersonId(AuthenticationUser.getAuthenticationUser().getUserid());
        dataAudit.setOpPersonName(String.format("%s[%s]", AuthenticationUser.getAuthenticationUser().getPersonName(), AuthenticationUser.getAuthenticationUser().getOrgName()));
        dataAudit.setAuditType("UPDATE");
        dataAudit.setAuditObject(BeanCache.get(beforeEntity.getClass()).getCodeName());
        dataAudit.setDataAuditName(BeanCache.get(beforeEntity.getClass()).getLogicName() + "[\u66f4\u65b0]");
        dataAudit.setAuditObjectData(idValue);
        dataAudit.setOpTime(new Timestamp(System.currentTimeMillis()));
        if (request != null) {
            dataAudit.setIpAddress(this.getIpAddress(request, AuthenticationUser.getAuthenticationUser()));
        }
        dataAudit.setAuditInfo(auditInfo);
        dataAudit.setIsDataChanged(isDataChanged);
        cacheMap.add(dataAudit);
    }

    @Override
    public void removeAudit(HttpServletRequest request, EntityBase entity, Object idValue) {
        if (ObjectUtils.isEmpty((Object)idValue)) {
            idValue = entity.get(BeanCache.getKeyField(entity.getClass()));
        }
        IBZDataAudit dataAudit = new IBZDataAudit();
        dataAudit.setOpPersonId(AuthenticationUser.getAuthenticationUser().getUserid());
        dataAudit.setOpPersonName(String.format("%s[%s]", AuthenticationUser.getAuthenticationUser().getPersonName(), AuthenticationUser.getAuthenticationUser().getOrgName()));
        dataAudit.setAuditType("REMOVE");
        dataAudit.setAuditObject(BeanCache.get(entity.getClass()).getCodeName());
        dataAudit.setDataAuditName(BeanCache.get(entity.getClass()).getLogicName() + "[\u5220\u9664]");
        dataAudit.setAuditObjectData(idValue);
        dataAudit.setOpTime(new Timestamp(System.currentTimeMillis()));
        if (request != null) {
            dataAudit.setIpAddress(this.getIpAddress(request, AuthenticationUser.getAuthenticationUser()));
        }
        dataAudit.setIsDataChanged(1);
        cacheMap.add(dataAudit);
    }
}

