/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.service;

import cn.ibizlab.util.domain.IBZUSER;
import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.mapper.IBZUSERMapper;
import cn.ibizlab.util.security.AuthTokenUtil;
import cn.ibizlab.util.security.AuthenticationInfo;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.security.AuthenticationUserImpl;
import cn.ibizlab.util.service.IBZUSERService;
import cn.ibizlab.util.service.UserServiceAdapter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

@Service(value="IBZUSERService")
@ConditionalOnExpression(value="(!${ibiz.enablePermissionValid:false})&&'${ibiz.auth.service:IBZUAAUserService}'.equals('IBZUSERService')")
public class IBZUSERServiceImpl
extends ServiceImpl<IBZUSERMapper, IBZUSER>
implements IBZUSERService,
UserServiceAdapter {
    @Value(value="${ibiz.auth.pwencrymode:0}")
    private int pwencrymode;
    @Autowired
    private AuthTokenUtil jwtTokenUtil;

    public AuthenticationUser loadUserByUsername(String username) {
        IBZUSER user;
        if (!StringUtils.hasLength((String)username)) {
            throw new UsernameNotFoundException("\u7528\u6237\u540d\u4e3a\u7a7a");
        }
        QueryWrapper conds = new QueryWrapper();
        String[] data = username.split("[|]");
        String loginname = "";
        String domains = "";
        if (data.length > 0) {
            loginname = data[0].trim();
        }
        if (data.length > 1) {
            domains = data[1].trim();
        }
        if (StringUtils.hasLength((String)loginname)) {
            conds.eq((Object)"loginname", (Object)loginname);
        }
        if (StringUtils.hasLength((String)domains)) {
            conds.eq((Object)"domains", (Object)domains);
        }
        if ((user = (IBZUSER)this.getOne((Wrapper)conds)) == null) {
            throw new BadRequestAlertException("\u767b\u5f55\u5931\u8d25", "IBZUSER", username);
        }
        user.setUsername(username);
        return this.createUserDetails(user);
    }

    public AuthenticationInfo loadUserByLogin(String username, String password) {
        AuthenticationUser authuserdetail = this.loadUserByUsername(username);
        if (this.pwencrymode == 1) {
            password = DigestUtils.md5DigestAsHex((byte[])password.getBytes());
        } else if (this.pwencrymode == 2) {
            password = DigestUtils.md5DigestAsHex((byte[])String.format("%1$s||%2$s", username, password).getBytes());
        }
        if (!authuserdetail.getPassword().equals(password)) {
            throw new BadRequestAlertException("\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef", "IBZUSER", username);
        }
        String token = this.jwtTokenUtil.generateToken((UserDetails)authuserdetail);
        return new AuthenticationInfo(token, authuserdetail);
    }

    public AuthenticationUser createUserDetails(IBZUSER user) {
        AuthenticationUserImpl userdatail = new AuthenticationUserImpl();
        CachedBeanCopier.copy(user, userdatail);
        userdatail.setSuperUser(user.getSuperuser());
        if (userdatail.isSuperUser()) {
            userdatail.setAuthorities((Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USERS", "ROLE_SUPERADMIN"}));
        } else {
            userdatail.setAuthorities((Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USERS"}));
        }
        return userdatail;
    }
}

