/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.service;

import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.domain.IBZDataAuditItem;
import cn.ibizlab.util.helper.BeanCache;
import cn.ibizlab.util.security.AuthenticationUser;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.ObjectUtils;

public interface IBZDataAuditService {
    @Async(value="asyncExecutor")
    public void createAudit(HttpServletRequest var1, EntityBase var2, Object var3);

    @Async(value="asyncExecutor")
    public void updateAudit(HttpServletRequest var1, EntityBase var2, EntityBase var3, Object var4);

    @Async(value="asyncExecutor")
    public void removeAudit(HttpServletRequest var1, EntityBase var2, Object var3);

    default public List<IBZDataAuditItem> getAuditInfo(EntityBase entity) {
        ArrayList<IBZDataAuditItem> auditFieldArray = new ArrayList<IBZDataAuditItem>();
        BeanCache.get(entity.getClass()).getAudits().forEach(item -> {
            String fieldName = item.getCodeName();
            DEField deField = item.getDeField();
            Object value = this.dataTransfer(entity.get(fieldName), item.getFormat());
            if (!ObjectUtils.isEmpty((Object)value)) {
                IBZDataAuditItem auditFieldObj = new IBZDataAuditItem();
                auditFieldObj.setId(item.getJsonName());
                auditFieldObj.setLabel(item.getLogicName());
                auditFieldObj.setValue(value);
                if (!ObjectUtils.isEmpty((Object)deField) && !ObjectUtils.isEmpty((Object)deField.dict())) {
                    auditFieldObj.setDict(deField.dict());
                }
                auditFieldArray.add(auditFieldObj);
            }
        });
        if (auditFieldArray.size() > 0) {
            return auditFieldArray;
        }
        return null;
    }

    default public List<IBZDataAuditItem> getUpdateAuditInfo(EntityBase oldData, EntityBase newData) {
        ArrayList<IBZDataAuditItem> auditFieldArray = new ArrayList<IBZDataAuditItem>();
        BeanCache.get(oldData.getClass()).getAudits().forEach(item -> {
            Object newValue;
            String fieldName = item.getCodeName();
            DEField deField = item.getDeField();
            Object oldValue = oldData.get(fieldName);
            if (!this.compare(oldValue, newValue = newData.get(fieldName))) {
                IBZDataAuditItem auditFieldObj = new IBZDataAuditItem();
                auditFieldObj.setId(item.getJsonName());
                auditFieldObj.setLabel(item.getLogicName());
                auditFieldObj.setValue(this.dataTransfer(newValue, deField.format()));
                auditFieldObj.setBefore(this.dataTransfer(oldValue, deField.format()));
                if (!ObjectUtils.isEmpty((Object)deField) && !ObjectUtils.isEmpty((Object)deField.dict())) {
                    auditFieldObj.setDict(deField.dict());
                }
                auditFieldArray.add(auditFieldObj);
            }
        });
        if (auditFieldArray.size() > 0) {
            return auditFieldArray;
        }
        return null;
    }

    default public Object dataTransfer(Object value, String strFormat) {
        if (value == null) {
            return "";
        }
        Object transResult = value;
        if (!ObjectUtils.isEmpty((Object)strFormat) && value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            SimpleDateFormat format = new SimpleDateFormat(strFormat);
            transResult = format.format(timestamp);
        }
        return transResult;
    }

    default public boolean compare(Object sourceObj, Object targetObj) {
        if (sourceObj == null && targetObj == null) {
            return true;
        }
        if (sourceObj == null && targetObj != null) {
            return false;
        }
        return sourceObj.equals(targetObj);
    }

    default public String getIpAddress(HttpServletRequest request, AuthenticationUser authenticationUser) {
        if (authenticationUser != null && !ObjectUtils.isEmpty((Object)authenticationUser.getAddress())) {
            return authenticationUser.getAddress();
        }
        if (request == null) {
            return "";
        }
        String Xip = request.getHeader("X-Real-IP");
        String XFor = request.getHeader("X-Forwarded-For");
        if (!ObjectUtils.isEmpty((Object)XFor) && !"unKnown".equalsIgnoreCase(XFor)) {
            int index = XFor.indexOf(",");
            if (index != -1) {
                return XFor.substring(0, index);
            }
            return XFor;
        }
        XFor = Xip;
        if (!ObjectUtils.isEmpty((Object)XFor) && !"unKnown".equalsIgnoreCase(XFor)) {
            return XFor;
        }
        if (ObjectUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("Proxy-Client-IP");
        }
        if (ObjectUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ObjectUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ObjectUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ObjectUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getRemoteAddr();
        }
        return XFor;
    }
}

