/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.service;

import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.domain.IBZConfig;
import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.helper.BeanCache;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.mapper.IBZConfigMapper;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class IBZConfigService
extends ServiceImpl<IBZConfigMapper, IBZConfig>
implements IService<IBZConfig> {
    private static final Logger log = LoggerFactory.getLogger(IBZConfigService.class);
    @Value(value="${ibiz.systemid:ibznotify}")
    private String systemId;
    @Value(value="${ibiz.admin.userid:0100}")
    private String adminuserid;

    @PostConstruct
    public void init() {
        Reflections reflections = new Reflections(new Object[0]);
        Set subClazzs = reflections.getSubTypesOf(EntityBase.class);
        subClazzs.forEach(entity -> BeanCache.register(entity));
    }

    @Cacheable(value={"ibzrt_configs"}, key="'cfgid:'+#p0+'||'+#p1+'||'+#p2")
    public JSONObject getConfig(String cfgType, String targetType, String userId) {
        if (ObjectUtils.isEmpty((Object)userId) || ObjectUtils.isEmpty((Object)cfgType) || ObjectUtils.isEmpty((Object)targetType)) {
            throw new BadRequestAlertException("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u7f3a\u5931", "IBZConfig", cfgType);
        }
        IBZConfig builder = new IBZConfig();
        builder.setSystemId(this.systemId);
        builder.setCfgType(cfgType);
        builder.setTargetType(targetType);
        builder.setUserId(userId);
        IBZConfig config = (IBZConfig)this.getOne((Wrapper)Wrappers.query((Object)builder), false);
        if (config == null) {
            builder.setUserId(this.adminuserid);
            config = (IBZConfig)this.getOne((Wrapper)Wrappers.query((Object)builder), false);
            if (config == null) {
                return new JSONObject();
            }
        }
        return JSON.parseObject((String)config.getCfg());
    }

    @CacheEvict(value={"ibzrt_configs"}, key="'cfgid:'+#p0+'||'+#p1+'||'+#p2")
    public boolean saveConfig(String cfgType, String targetType, String userId, JSONObject config) {
        if (ObjectUtils.isEmpty((Object)userId) || ObjectUtils.isEmpty((Object)cfgType) || ObjectUtils.isEmpty((Object)targetType)) {
            throw new BadRequestAlertException("\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u7f3a\u5931", "IBZConfig", cfgType);
        }
        String cfg = "{}";
        if (config != null) {
            cfg = JSONObject.toJSONString((Object)config);
        }
        IBZConfig builder = new IBZConfig();
        builder.setSystemId(this.systemId);
        builder.setCfgType(cfgType);
        builder.setTargetType(targetType);
        builder.setUserId(userId);
        builder.setCfg(cfg);
        builder.setUpdateDate(DataObject.getNow());
        builder.getCfgId();
        return this.saveOrUpdate(builder);
    }

    @CacheEvict(value={"ibzrt_configs"}, key="'cfgid:'+#p0+'||'+#p1+'||'+#p2")
    public void resetConfig(String cfgType, String targetType, String userId) {
        if (ObjectUtils.isEmpty((Object)userId) || ObjectUtils.isEmpty((Object)cfgType) || ObjectUtils.isEmpty((Object)targetType)) {
            throw new BadRequestAlertException("\u91cd\u7f6e\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u7f3a\u5931", "IBZConfig", cfgType);
        }
        IBZConfig builder = new IBZConfig();
        builder.setSystemId(this.systemId);
        builder.setCfgType(cfgType);
        builder.setTargetType(targetType);
        builder.setUserId(userId);
        this.remove((Wrapper)Wrappers.query((Object)builder));
    }

    @Cacheable(value={"ibzrt_shareconfigs"}, key="'cfgid:'+#p0")
    public JSONObject saveShareConfig(String id, String cfgType, String targetType, String userId) {
        return this.getConfig(cfgType, targetType, this.adminuserid);
    }

    @Cacheable(value={"ibzrt_shareconfigs"}, key="'cfgid:'+#p0")
    public JSONObject getShareConfig(String id) {
        return null;
    }
}

