/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.service;

import cn.ibizlab.util.client.IBZUAAFeignClient;
import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.errors.UnauthorizedException;
import cn.ibizlab.util.helper.BeanCache;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.security.AuthenticationUserImpl;
import cn.ibizlab.util.security.UAACustomAuthority;
import cn.ibizlab.util.security.UAADEAuthority;
import cn.ibizlab.util.security.UAAGrantedAuthority;
import cn.ibizlab.util.service.IBZUAAUserService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="CloudUserService")
@ConditionalOnExpression(value="'${ibiz.auth.service:IBZUAAUserService}'.equals('CloudUserService')")
public class CloudUserService
extends IBZUAAUserService {
    private static final Logger log = LoggerFactory.getLogger(CloudUserService.class);
    @Autowired
    @Lazy
    private RedisTemplate redisTemplate;
    @Value(value="${ibiz.jwt.header:Authorization}")
    private String tokenHeader;
    private ObjectMapper objectMapper = new ObjectMapper();
    private TypeReference<Collection<UAAGrantedAuthority>> UAAGrantedAuthorityListType = new TypeReference<Collection<UAAGrantedAuthority>>(){};
    @Autowired
    private IBZUAAFeignClient uaaFeignClient;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AuthenticationUser loadUserByUsername(String username) {
        Object obj = this.redisTemplate.opsForValue().get((Object)("ibiz-cloud-uaa-user-" + username));
        if (obj == null) {
            throw new BadRequestAlertException("\u767b\u5f55\u5931\u8d25", "CloudUser", username);
        }
        try {
            HttpServletRequest request;
            String requestHeader;
            AuthenticationUser dcEmployee = (AuthenticationUser)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes(obj), AuthenticationUserImpl.class);
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (requestAttributes == null || (requestHeader = (request = requestAttributes.getRequest()).getHeader(this.tokenHeader)) == null || !requestHeader.startsWith("Bearer ")) return dcEmployee;
            String authToken = requestHeader.substring(7);
            String srforgid = request.getHeader("srforgid");
            String srfsystemid = request.getHeader("srfsystemid");
            String srfdcsystemid = request.getHeader("srfdcsystemid");
            String srfuserid = request.getHeader("srfuserid");
            String srfdcid = request.getHeader("srfdcid");
            if ("undefined".equals(srfsystemid)) {
                srfsystemid = null;
            }
            if ("undefined".equals(srforgid)) {
                srforgid = null;
            }
            Collection authorities = null;
            if (StringUtils.hasLength((String)srfsystemid) && StringUtils.hasLength((String)srfdcid) && StringUtils.hasLength((String)srfdcsystemid) && StringUtils.hasLength((String)srfuserid)) {
                if (dcEmployee.isApiUser() || dcEmployee.isSuperUser()) {
                    String srfusername = request.getHeader("srfusername");
                    dcEmployee.set("srfdcid", (Object)srfdcid);
                    dcEmployee.setUserid(srfuserid);
                    dcEmployee.set("dcsystemid", (Object)srfdcsystemid);
                    if (StringUtils.hasLength((String)srfusername)) {
                        try {
                            dcEmployee.setPersonName(URLDecoder.decode(srfusername, "UTF-8"));
                        }
                        catch (Exception ex) {
                            log.error(ex.getMessage());
                            dcEmployee.setPersonName(srfusername);
                        }
                    }
                    dcEmployee.setOrgId(srforgid);
                    String strValue = request.getHeader("srforgcode");
                    if (StringUtils.hasLength((String)strValue)) {
                        dcEmployee.setOrgCode(strValue);
                    }
                    if (StringUtils.hasLength((String)(strValue = request.getHeader("srfdeptid")))) {
                        dcEmployee.setMainDeptId(strValue);
                    }
                    if (StringUtils.hasLength((String)(strValue = request.getHeader("srfdeptcode")))) {
                        dcEmployee.setMainDeptCode(strValue);
                    }
                    if (StringUtils.hasLength((String)(strValue = request.getHeader("srfporgids")))) {
                        dcEmployee.getSessionParams().put("srfporg", strValue);
                    }
                    if (StringUtils.hasLength((String)(strValue = request.getHeader("srfsorgids")))) {
                        dcEmployee.getSessionParams().put("srfsorg", strValue);
                    }
                    if (StringUtils.hasLength((String)(strValue = request.getHeader("srfpdeptids")))) {
                        dcEmployee.getSessionParams().put("srfpdept", strValue);
                    }
                    if (!StringUtils.hasLength((String)(strValue = request.getHeader("srfsdeptids")))) return dcEmployee;
                    dcEmployee.getSessionParams().put("srfsdept", strValue);
                    return dcEmployee;
                }
                log.error(String.format("\u7528\u6237[%1$s][%2$s]\u4f7f\u7528API\u6a21\u5f0f\u8bbf\u95ee\u7cfb\u7edf", dcEmployee.getUserid(), dcEmployee.getUsername()));
                throw new UnauthorizedException(String.format("\u7528\u6237[%1$s][%2$s]\u4f7f\u7528API\u6a21\u5f0f\u8bbf\u95ee\u7cfb\u7edf", dcEmployee.getUserid(), dcEmployee.getUsername()));
            }
            if (!StringUtils.hasLength((String)srfsystemid) || !StringUtils.hasLength((String)srforgid)) return dcEmployee;
            this.uaaFeignClient.getAppData();
            AuthenticationUser employee = this.getEmployee(srfsystemid, srforgid, dcEmployee.getUsername(), authToken);
            if (employee != null) {
                if (dcEmployee.isSuperUser()) {
                    employee.setSuperUser(Integer.valueOf(1));
                }
                dcEmployee = employee;
            }
            String strDCSystemId = null;
            if (dcEmployee != null && dcEmployee.get("dcsystemid") != null) {
                strDCSystemId = dcEmployee.get("dcsystemid").toString();
            }
            if (!StringUtils.hasLength(strDCSystemId) || ObjectUtils.isEmpty((Object)(authorities = this.getGrantedAuthorities(strDCSystemId, dcEmployee.getUsername(), authToken)))) return dcEmployee;
            if (dcEmployee.isSuperUser()) {
                authorities.add("ROLE_SUPERADMIN");
            }
            HashMap<String, Collection> permission = new HashMap<String, Collection>();
            permission.put("authorities", authorities);
            dcEmployee.setPermissionList(permission);
            return dcEmployee;
        }
        catch (IOException e) {
            throw new BadRequestAlertException("\u767b\u5f55\u5931\u8d25", "CloudUser", username);
        }
    }

    protected Collection getGrantedAuthorities(String strDCSystemId, String strUAAUserName, String strToken) {
        String strCacheCat = String.format("ibiz-cloud-uaa-cat-%1$s--%2$s", strUAAUserName, DigestUtils.md5DigestAsHex((byte[])strToken.getBytes(StandardCharsets.UTF_8)));
        String strCacheTag = String.format("authorities-%1$s", strDCSystemId);
        Object obj = this.redisTemplate.opsForHash().get((Object)strCacheCat, (Object)strCacheTag);
        if (!ObjectUtils.isEmpty((Object)obj)) {
            try {
                LinkedHashMap rt = new LinkedHashMap();
                Collection tmp = (Collection)this.objectMapper.readValue(this.objectMapper.writeValueAsString(obj), this.UAAGrantedAuthorityListType);
                if (!ObjectUtils.isEmpty((Object)tmp)) {
                    tmp.forEach(item -> {
                        if (item instanceof UAADEAuthority) {
                            UAADEAuthority deAuth = (UAADEAuthority)item;
                            deAuth.setEntityCode(BeanCache.get(deAuth.getEntity()).getCodeName());
                            if (ObjectUtils.isEmpty((Object)deAuth.getEntityCode())) {
                                return;
                            }
                            deAuth.getAuthorities().forEach(auth -> {
                                if (auth.endsWith("-custom")) {
                                    UAACustomAuthority customAuthority = new UAACustomAuthority();
                                    customAuthority.setSystemid(deAuth.getSystemid());
                                    customAuthority.setEntity(deAuth.getEntity());
                                    customAuthority.setEntityCode(deAuth.getEntityCode());
                                    customAuthority.setBscope(deAuth.getBscope());
                                    customAuthority.setAuthority(DigestUtils.md5DigestAsHex((byte[])(auth + deAuth.getBscope()).getBytes()));
                                    rt.put(customAuthority.getAuthority(), customAuthority);
                                } else {
                                    rt.put(auth, auth);
                                }
                            });
                        } else {
                            rt.put(item.getAuthority(), item.getAuthority());
                        }
                    });
                    return rt.values().stream().collect(Collectors.toList());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected AuthenticationUser getEmployee(String strSystemId, String strOrgId, String strUAAUserName, String strToken) {
        String strCacheCat = String.format("ibiz-cloud-uaa-cat-%1$s--%2$s", strUAAUserName, DigestUtils.md5DigestAsHex((byte[])strToken.getBytes(StandardCharsets.UTF_8)));
        String strCacheTag = String.format("sysemp-%1$s--%2$s", strSystemId, strOrgId);
        Object obj = this.redisTemplate.opsForHash().get((Object)strCacheCat, (Object)strCacheTag);
        if (!ObjectUtils.isEmpty((Object)obj)) {
            try {
                return (AuthenticationUser)this.objectMapper.readValue(this.objectMapper.writeValueAsString(obj), AuthenticationUser.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Map getAppData(String systemId, boolean isEnablePermissionValid) {
        Map appData = this.uaaFeignClient.getAppData();
        return ObjectUtils.isEmpty((Object)appData) ? super.getAppData(systemId, isEnablePermissionValid) : appData;
    }
}

