/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.rest;

import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.service.IBZConfigService;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={""})
public class ConfigController {
    @Autowired
    private IBZConfigService ibzConfigService;

    @RequestMapping(method={RequestMethod.PUT}, value={"/configs/{configType}/{targetType}"})
    public ResponseEntity<Boolean> saveConfig(@PathVariable(value="configType") String configType, @PathVariable(value="targetType") String targetType, @RequestBody JSONObject config) {
        String userId = AuthenticationUser.getAuthenticationUser().getUserid();
        if (ObjectUtils.isEmpty((Object)userId)) {
            throw new BadRequestAlertException("\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u7f3a\u5931", "IBZConfig", configType);
        }
        return ResponseEntity.ok((Object)this.ibzConfigService.saveConfig(configType, targetType, userId, config));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/configs/{configType}/{targetType}"})
    public ResponseEntity<JSONObject> getConfig(@PathVariable(value="configType") String configType, @PathVariable(value="targetType") String targetType) {
        String userId = AuthenticationUser.getAuthenticationUser().getUserid();
        if (ObjectUtils.isEmpty((Object)userId)) {
            throw new BadRequestAlertException("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u7f3a\u5931", "IBZConfig", configType);
        }
        return ResponseEntity.ok((Object)this.ibzConfigService.getConfig(configType, targetType, userId));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/configs/share/{id}"})
    public ResponseEntity<JSONObject> getShareConfig(@PathVariable(value="id") String id) {
        JSONObject jo = this.ibzConfigService.getShareConfig(id);
        if (jo == null) {
            throw new BadRequestAlertException("\u65e0\u6548\u7684\u5171\u4eab\u914d\u7f6e\u6570\u636e", "IBZConfig", id);
        }
        return ResponseEntity.ok((Object)jo);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/configs/share/{configType}/{targetType}"})
    public ResponseEntity<String> shareConfig(@PathVariable(value="configType") String configType, @PathVariable(value="targetType") String targetType) {
        String userId = AuthenticationUser.getAuthenticationUser().getUserid();
        if (ObjectUtils.isEmpty((Object)userId)) {
            throw new BadRequestAlertException("\u5206\u4eab\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u7f3a\u5931", "IBZConfig", configType);
        }
        String id = IdWorker.get32UUID();
        this.ibzConfigService.saveShareConfig(id, configType, targetType, userId);
        return ResponseEntity.ok((Object)id);
    }

    protected void fillAppData(JSONObject appData) {
    }
}

