/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.repository;

import cn.ibizlab.util.domain.EntityMongo;
import cn.ibizlab.util.filter.MongoQueryContext;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.repository.IBZMongoRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.support.PageableExecutionUtils;

public class IBZMongoSimpleRepository<T extends EntityMongo, ID>
implements IBZMongoRepository<T, ID> {
    private final MongoOperations mongoOperations;
    private final MongoEntityInformation<T, ID> entityInformation;

    public IBZMongoSimpleRepository(MongoEntityInformation<T, ID> metadata, MongoOperations mongoOperations) {
        this.entityInformation = metadata;
        this.mongoOperations = mongoOperations;
    }

    public <S extends T> S save(S entity) {
        Optional<T> op;
        Object id = this.entityInformation.getId(entity);
        if (id != null && (op = this.findById(id)).isPresent()) {
            EntityMongo t = (EntityMongo)op.get();
            CachedBeanCopier.copyWithFocusNull(entity, t);
            entity = t;
        }
        return entity;
    }

    @Override
    public <S extends T> Page<T> query(MongoQueryContext mongoQueryContext) {
        Query query = mongoQueryContext.getSearchCond();
        query.with(mongoQueryContext.getPageable());
        if (mongoQueryContext.getPageSort() != null) {
            query.with(mongoQueryContext.getPageSort());
        }
        List list = this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
        return PageableExecutionUtils.getPage((List)list, (Pageable)mongoQueryContext.getPageable(), () -> this.mongoOperations.count(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }

    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        return null;
    }

    public Optional<T> findById(ID id) {
        return Optional.empty();
    }

    public boolean existsById(ID id) {
        return false;
    }

    public List<T> findAll() {
        return null;
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        return null;
    }

    public long count() {
        return 0L;
    }

    public void deleteById(ID id) {
    }

    public void delete(T entity) {
    }

    public void deleteAll(Iterable<? extends T> entities) {
    }

    public void deleteAll() {
    }

    public List<T> findAll(Sort sort) {
        return null;
    }

    public Page<T> findAll(Pageable pageable) {
        return null;
    }

    public <S extends T> S insert(S entity) {
        return null;
    }

    public <S extends T> List<S> insert(Iterable<S> entities) {
        return null;
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        return Optional.empty();
    }

    public <S extends T> List<S> findAll(Example<S> example) {
        return null;
    }

    public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
        return null;
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        return null;
    }

    public <S extends T> long count(Example<S> example) {
        return 0L;
    }

    public <S extends T> boolean exists(Example<S> example) {
        return false;
    }
}

