/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.helper;

import cn.ibizlab.util.domain.EntityBase;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;

public class CachedBeanCopier {
    public static void copy(Object srcObj, Object destObj) {
        CachedBeanCopier.copy(srcObj, destObj, false);
    }

    public static void copy(Object srcObj, Object destObj, boolean useConverter) {
        if (srcObj == null || destObj == null) {
            return;
        }
        BeanUtils.copyProperties((Object)srcObj, (Object)destObj);
    }

    public static void copyWithFocusNull(EntityBase source, EntityBase target) {
        PropertyDescriptor[] targetPds;
        if (source == null || target == null) {
            return;
        }
        Class<?> actualEditable = target.getClass();
        Class<?> sourceClass = source.getClass();
        for (PropertyDescriptor targetPd : targetPds = BeanUtils.getPropertyDescriptors(actualEditable)) {
            PropertyDescriptor sourcePd;
            if (targetPd.getWriteMethod() == null || (sourcePd = BeanUtils.getPropertyDescriptor(sourceClass, (String)targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            try {
                Object value;
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((value = readMethod.invoke((Object)source, new Object[0])) == null) {
                    if (!source.getFocusNull().contains(sourcePd.getName().toLowerCase())) continue;
                    CachedBeanCopier.setValue(target, targetPd, value);
                    continue;
                }
                CachedBeanCopier.setValue(target, targetPd, value);
            }
            catch (Exception ex) {
                throw new FatalBeanException("Could not copy properties from source to target", (Throwable)ex);
            }
        }
    }

    private static void setValue(Object target, PropertyDescriptor targetPd, Object value) throws IllegalAccessException, InvocationTargetException {
        Method writeMethod = targetPd.getWriteMethod();
        if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
            writeMethod.setAccessible(true);
        }
        writeMethod.invoke(target, value);
    }
}

