/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.filter;

import cn.ibizlab.util.filter.ISearchContext;
import cn.ibizlab.util.filter.QueryFilter;
import cn.ibizlab.util.security.AuthenticationUser;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.ObjectUtils;

public class SearchContextBase
implements ISearchContext {
    private static final Logger log = LoggerFactory.getLogger(SearchContextBase.class);
    @JsonProperty(value="customcond")
    public String customCond;
    @JsonProperty(value="customparams")
    public String customParams;
    @JsonProperty(value="query")
    public String query;
    @JsonProperty(value="filter")
    public QueryFilter filter;
    public List dataQueryList;
    public int page = 0;
    public int size = 20;
    public String sort;
    @JsonIgnore
    public Sort pageSort;
    public String userTaskId;
    public String processDefinitionKey;
    @JsonProperty(value="srfwf")
    public String srfWF;
    Map<String, Object> params = new HashMap<String, Object>();

    public String getUserTaskId() {
        if (ObjectUtils.isEmpty((Object)this.userTaskId)) {
            Object taskId = this.params.get("usertaskid");
            return ObjectUtils.isEmpty((Object)taskId) ? null : String.valueOf(taskId);
        }
        return this.userTaskId;
    }

    public String getProcessDefinitionKey() {
        if (ObjectUtils.isEmpty((Object)this.processDefinitionKey)) {
            Object processKey = this.params.get("processdefinitionkey");
            return ObjectUtils.isEmpty((Object)processKey) ? null : String.valueOf(processKey);
        }
        return this.processDefinitionKey;
    }

    public Pageable getPageable() {
        if (ObjectUtils.isEmpty((Object)this.pageSort)) {
            return PageRequest.of((int)this.page, (int)this.size);
        }
        return PageRequest.of((int)this.page, (int)this.size, (Sort)this.pageSort);
    }

    public void setSort(String strSort) {
        this.sort = strSort;
        if (!ObjectUtils.isEmpty((Object)strSort)) {
            String[] sortArr = strSort.split(",");
            String sortField = sortArr[0];
            String sortDirection = sortArr[1];
            if (sortDirection.equalsIgnoreCase("asc")) {
                this.pageSort = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{sortField});
            } else if (sortDirection.equalsIgnoreCase("desc")) {
                this.pageSort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{sortField});
            }
        }
    }

    public Map<String, Object> getDatacontext() {
        return this.params;
    }

    public Map<String, Object> getWebcontext() {
        return this.params;
    }

    @JsonIgnore
    public Map<String, Object> getSessioncontext() {
        return AuthenticationUser.getAuthenticationUser().getSessionParams();
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.params;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.params.put(name, value);
    }

    public String getCustomCond() {
        return this.customCond;
    }

    public String getCustomParams() {
        return this.customParams;
    }

    public String getQuery() {
        return this.query;
    }

    public QueryFilter getFilter() {
        return this.filter;
    }

    public List getDataQueryList() {
        return this.dataQueryList;
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public String getSort() {
        return this.sort;
    }

    public Sort getPageSort() {
        return this.pageSort;
    }

    public String getSrfWF() {
        return this.srfWF;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    @JsonProperty(value="customcond")
    public void setCustomCond(String customCond) {
        this.customCond = customCond;
    }

    @JsonProperty(value="customparams")
    public void setCustomParams(String customParams) {
        this.customParams = customParams;
    }

    @JsonProperty(value="query")
    public void setQuery(String query) {
        this.query = query;
    }

    @JsonProperty(value="filter")
    public void setFilter(QueryFilter filter) {
        this.filter = filter;
    }

    public void setDataQueryList(List dataQueryList) {
        this.dataQueryList = dataQueryList;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @JsonIgnore
    public void setPageSort(Sort pageSort) {
        this.pageSort = pageSort;
    }

    public void setUserTaskId(String userTaskId) {
        this.userTaskId = userTaskId;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @JsonProperty(value="srfwf")
    public void setSrfWF(String srfWF) {
        this.srfWF = srfWF;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchContextBase)) {
            return false;
        }
        SearchContextBase other = (SearchContextBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$customCond = this.getCustomCond();
        String other$customCond = other.getCustomCond();
        if (this$customCond == null ? other$customCond != null : !this$customCond.equals(other$customCond)) {
            return false;
        }
        String this$customParams = this.getCustomParams();
        String other$customParams = other.getCustomParams();
        if (this$customParams == null ? other$customParams != null : !this$customParams.equals(other$customParams)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        QueryFilter this$filter = this.getFilter();
        QueryFilter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        List this$dataQueryList = this.getDataQueryList();
        List other$dataQueryList = other.getDataQueryList();
        if (this$dataQueryList == null ? other$dataQueryList != null : !((Object)this$dataQueryList).equals(other$dataQueryList)) {
            return false;
        }
        String this$sort = this.getSort();
        String other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !this$sort.equals(other$sort)) {
            return false;
        }
        Sort this$pageSort = this.getPageSort();
        Sort other$pageSort = other.getPageSort();
        if (this$pageSort == null ? other$pageSort != null : !this$pageSort.equals(other$pageSort)) {
            return false;
        }
        String this$userTaskId = this.getUserTaskId();
        String other$userTaskId = other.getUserTaskId();
        if (this$userTaskId == null ? other$userTaskId != null : !this$userTaskId.equals(other$userTaskId)) {
            return false;
        }
        String this$processDefinitionKey = this.getProcessDefinitionKey();
        String other$processDefinitionKey = other.getProcessDefinitionKey();
        if (this$processDefinitionKey == null ? other$processDefinitionKey != null : !this$processDefinitionKey.equals(other$processDefinitionKey)) {
            return false;
        }
        String this$srfWF = this.getSrfWF();
        String other$srfWF = other.getSrfWF();
        if (this$srfWF == null ? other$srfWF != null : !this$srfWF.equals(other$srfWF)) {
            return false;
        }
        Map<String, Object> this$params = this.getParams();
        Map<String, Object> other$params = other.getParams();
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchContextBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getSize();
        String $customCond = this.getCustomCond();
        result = result * 59 + ($customCond == null ? 43 : $customCond.hashCode());
        String $customParams = this.getCustomParams();
        result = result * 59 + ($customParams == null ? 43 : $customParams.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        QueryFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        List $dataQueryList = this.getDataQueryList();
        result = result * 59 + ($dataQueryList == null ? 43 : ((Object)$dataQueryList).hashCode());
        String $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        Sort $pageSort = this.getPageSort();
        result = result * 59 + ($pageSort == null ? 43 : $pageSort.hashCode());
        String $userTaskId = this.getUserTaskId();
        result = result * 59 + ($userTaskId == null ? 43 : $userTaskId.hashCode());
        String $processDefinitionKey = this.getProcessDefinitionKey();
        result = result * 59 + ($processDefinitionKey == null ? 43 : $processDefinitionKey.hashCode());
        String $srfWF = this.getSrfWF();
        result = result * 59 + ($srfWF == null ? 43 : $srfWF.hashCode());
        Map<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        return result;
    }

    public String toString() {
        return "SearchContextBase(customCond=" + this.getCustomCond() + ", customParams=" + this.getCustomParams() + ", query=" + this.getQuery() + ", filter=" + this.getFilter() + ", dataQueryList=" + this.getDataQueryList() + ", page=" + this.getPage() + ", size=" + this.getSize() + ", sort=" + this.getSort() + ", pageSort=" + this.getPageSort() + ", userTaskId=" + this.getUserTaskId() + ", processDefinitionKey=" + this.getProcessDefinitionKey() + ", srfWF=" + this.getSrfWF() + ", params=" + this.getParams() + ")";
    }
}

