/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.filter;

import cn.ibizlab.util.filter.ISearchContext;
import cn.ibizlab.util.filter.QueryFilter;
import cn.ibizlab.util.filter.SearchContextBase;
import cn.ibizlab.util.helper.BeanCache;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.util.ObjectUtils;

public class QueryWrapperContext<T>
extends SearchContextBase
implements ISearchContext {
    private static final Logger log = LoggerFactory.getLogger(QueryWrapperContext.class);
    @JsonIgnore
    @JSONField(serialize=false)
    private QueryWrapper<T> selectCond = new QueryWrapper();

    @JsonIgnore
    @JSONField(serialize=false)
    public Page getPages() {
        ArrayList<OrderItem> orderfieldList = new ArrayList<OrderItem>();
        int currentPage = this.getPageable().getPageNumber();
        int pageSize = this.getPageable().getPageSize();
        Page page = ObjectUtils.isEmpty((Object)currentPage) || ObjectUtils.isEmpty((Object)pageSize) ? new Page(1L, 32767L) : new Page((long)(currentPage + 1), (long)pageSize);
        Sort sort = this.getPageable().getSort();
        Iterator it_sort = sort.iterator();
        if (ObjectUtils.isEmpty((Object)it_sort)) {
            return page;
        }
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class type = (Class)parameterizedType.getActualTypeArguments()[0];
        while (it_sort.hasNext()) {
            Sort.Order sort_order = (Sort.Order)it_sort.next();
            if (sort_order.getDirection() == Sort.Direction.ASC) {
                orderfieldList.add(new OrderItem(BeanCache.getFieldName(type, sort_order.getProperty()), true));
                continue;
            }
            if (sort_order.getDirection() != Sort.Direction.DESC) continue;
            orderfieldList.add(new OrderItem(BeanCache.getFieldName(type, sort_order.getProperty()), false));
        }
        if (orderfieldList.size() > 0) {
            page.setOrders(orderfieldList);
        }
        return page;
    }

    public QueryWrapper<T> getSearchCond() {
        return this.selectCond;
    }

    public QueryWrapper<T> getSelectCond() {
        Consumer<QueryWrapper<T>> queryWrapper;
        if (!ObjectUtils.isEmpty((Object)this.filter) && !ObjectUtils.isEmpty(queryWrapper = this.parseQueryFilter(this.filter))) {
            this.selectCond.and(queryWrapper);
        }
        return this.selectCond;
    }

    private Consumer<QueryWrapper<T>> parseQueryFilter(QueryFilter queryFilter) {
        if (queryFilter.any().size() == 0 && queryFilter.get$or() == null && queryFilter.get$and() == null) {
            return null;
        }
        Consumer<QueryWrapper<T>> consumer = queryWrapper -> {
            Consumer<QueryWrapper<T>> fieldConsumer = this.parseFieldMap(queryFilter.any());
            Consumer<QueryWrapper<T>> orConsumer = this.parseOrQueryFilter(queryFilter.get$or());
            Consumer<QueryWrapper<T>> andConsumer = this.parseAndQueryFilter(queryFilter.get$and());
            if (!ObjectUtils.isEmpty(fieldConsumer)) {
                queryWrapper.and(fieldConsumer);
            }
            if (!ObjectUtils.isEmpty(orConsumer)) {
                queryWrapper.and(orConsumer);
            }
            if (!ObjectUtils.isEmpty(andConsumer)) {
                queryWrapper.and(andConsumer);
            }
        };
        return consumer;
    }

    private Consumer<QueryWrapper<T>> parseOrQueryFilter(List<QueryFilter> queryFilters) {
        if (queryFilters == null || queryFilters.size() == 0) {
            return null;
        }
        Consumer<QueryWrapper<T>> consumer = queryWrapper -> {
            for (QueryFilter queryFilter : queryFilters) {
                Consumer<QueryWrapper<T>> tempQueryWrapper = this.parseQueryFilter(queryFilter);
                queryWrapper.or(tempQueryWrapper);
            }
        };
        return consumer;
    }

    private Consumer<QueryWrapper<T>> parseAndQueryFilter(List<QueryFilter> queryFilters) {
        if (queryFilters == null || queryFilters.size() == 0) {
            return null;
        }
        Consumer<QueryWrapper<T>> consumer = queryWrapper -> {
            for (QueryFilter queryFilter : queryFilters) {
                Consumer<QueryWrapper<T>> tempQueryWrapper = this.parseQueryFilter(queryFilter);
                queryWrapper.and(tempQueryWrapper);
            }
        };
        return consumer;
    }

    private Consumer<QueryWrapper<T>> parseFieldMap(Map<String, QueryFilter.SegmentCond> fieldMap) {
        if (fieldMap.size() == 0) {
            return null;
        }
        Consumer<QueryWrapper<T>> consumer = queryWrapper -> {
            for (Map.Entry field : fieldMap.entrySet()) {
                String fieldName = (String)field.getKey();
                QueryFilter.SegmentCond segmentCond = (QueryFilter.SegmentCond)field.getValue();
                Map<String, Object> segmentCondMap = segmentCond.any();
                for (Map.Entry<String, Object> fieldCond : segmentCondMap.entrySet()) {
                    Object value = fieldCond.getValue();
                    switch (fieldCond.getKey()) {
                        case "$eq": {
                            queryWrapper.eq((Object)fieldName, value);
                            break;
                        }
                        case "$ne": {
                            queryWrapper.ne((Object)fieldName, value);
                            break;
                        }
                        case "$gt": {
                            queryWrapper.gt((Object)fieldName, value);
                            break;
                        }
                        case "$gte": {
                            queryWrapper.ge((Object)fieldName, value);
                            break;
                        }
                        case "$lt": {
                            queryWrapper.lt((Object)fieldName, value);
                            break;
                        }
                        case "$lte": {
                            queryWrapper.le((Object)fieldName, value);
                            break;
                        }
                        case "$null": {
                            queryWrapper.isNull((Object)fieldName);
                            break;
                        }
                        case "$notNull": {
                            queryWrapper.isNotNull((Object)fieldName);
                            break;
                        }
                        case "$in": {
                            queryWrapper.in((Object)fieldName, (Collection)value);
                            break;
                        }
                        case "$notIn": {
                            queryWrapper.notIn((Object)fieldName, (Collection)value);
                            break;
                        }
                        case "$like": {
                            queryWrapper.like((Object)fieldName, value);
                            break;
                        }
                        case "$startsWith": {
                            queryWrapper.likeRight((Object)fieldName, value);
                            break;
                        }
                        case "$endsWith": {
                            queryWrapper.likeLeft((Object)fieldName, value);
                            break;
                        }
                        case "$exists": {
                            break;
                        }
                    }
                }
            }
        };
        return consumer;
    }

    @JsonIgnore
    public void setSelectCond(QueryWrapper<T> selectCond) {
        this.selectCond = selectCond;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryWrapperContext)) {
            return false;
        }
        QueryWrapperContext other = (QueryWrapperContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QueryWrapper<T> this$selectCond = this.getSelectCond();
        QueryWrapper<T> other$selectCond = other.getSelectCond();
        return !(this$selectCond == null ? other$selectCond != null : !this$selectCond.equals(other$selectCond));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QueryWrapperContext;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QueryWrapper<T> $selectCond = this.getSelectCond();
        result = result * 59 + ($selectCond == null ? 43 : $selectCond.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "QueryWrapperContext(selectCond=" + this.getSelectCond() + ")";
    }
}

