/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util.script;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.res.IPSSysLogic;
import net.ibizsys.runtime.ISystemRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.ISystemRuntimeContext;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.res.ISysLogicRuntime;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.AppContext;
import net.ibizsys.runtime.util.IAppContext;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.script.IScriptAppContext;
import net.ibizsys.runtime.util.script.IScriptCodeList;
import net.ibizsys.runtime.util.script.IScriptEntity;
import net.ibizsys.runtime.util.script.IScriptSearchContext;
import net.ibizsys.runtime.util.script.IScriptUserContext;
import net.ibizsys.runtime.util.script.IScriptUtil;
import net.ibizsys.runtime.util.script.IScriptWebContext;
import net.ibizsys.runtime.util.script.ISystemRTScriptContext;
import net.ibizsys.runtime.util.script.ScriptAppContext;
import net.ibizsys.runtime.util.script.ScriptCodeList;
import net.ibizsys.runtime.util.script.ScriptUserContext;
import net.ibizsys.runtime.util.script.ScriptUtil;
import net.ibizsys.runtime.util.script.ScriptUtils;
import net.ibizsys.runtime.util.script.ScriptWebContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class SystemRTScriptContext
implements ISystemRTScriptContext {
    private static final Log log = LogFactory.getLog(SystemRTScriptContext.class);
    private ISystemRuntimeContext iSystemRuntimeContext = null;
    private IScriptUtil iScriptUtil = new ScriptUtil();
    private Map<String, Object> cacheMap = new HashMap<String, Object>();
    private ScriptAppContext scriptAppContext = new ScriptAppContext();
    private ScriptUserContext scriptUserContext = new ScriptUserContext();
    private ScriptWebContext scriptWebContext = new ScriptWebContext();

    public SystemRTScriptContext(ISystemRuntimeContext iSystemRuntimeContext) {
        this.iSystemRuntimeContext = iSystemRuntimeContext;
    }

    @Override
    public IScriptEntity entity() {
        IEntity iEntity = this.getSystemRuntimeContext().getSystemRuntime().createEntity();
        return this.getSystemRuntimeContext().getSystemRuntime().createScriptEntity(iEntity);
    }

    @Override
    public IScriptEntity entity(String strName) {
        try {
            IDataEntityRuntime iDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(strName);
            return iDataEntityRuntime.createScriptEntity(null);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u6a21\u578b\u5bf9\u8c61", strName));
        }
    }

    @Override
    public IScriptEntity[] select(String strName, String strCondition) {
        IDataEntityRuntime iDataEntityRuntime = null;
        try {
            iDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(strName);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u6a21\u578b\u5bf9\u8c61", strName));
        }
        List<? extends IEntityBase> list = iDataEntityRuntime.select(strCondition);
        if (list == null || list.size() == 0) {
            return null;
        }
        IScriptEntity[] arr = new IScriptEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = iDataEntityRuntime.createScriptEntity(list.get(i));
        }
        return arr;
    }

    @Override
    public IScriptEntity selectOne(String strName, String strCondition) {
        IDataEntityRuntime iDataEntityRuntime = null;
        try {
            iDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(strName);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u6a21\u578b\u5bf9\u8c61", strName));
        }
        IEntityBase iEntityBase = iDataEntityRuntime.selectOne(strCondition);
        if (iEntityBase == null) {
            return null;
        }
        return iDataEntityRuntime.createScriptEntity(iEntityBase);
    }

    @Override
    public IScriptEntity selectone(String strName, String strCondition) {
        return this.selectOne(strName, strCondition);
    }

    @Override
    public int remove(String strName, String strCondition) {
        IDataEntityRuntime iDataEntityRuntime = null;
        try {
            iDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(strName);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u6a21\u578b\u5bf9\u8c61", strName));
        }
        List<? extends IEntityBase> list = iDataEntityRuntime.select(strCondition);
        if (list == null || list.size() == 0) {
            return 0;
        }
        for (int i = 0; i < list.size(); ++i) {
            try {
                iDataEntityRuntime.remove(iDataEntityRuntime.getFieldValue(list.get(i), iDataEntityRuntime.getKeyPSDEField()));
                continue;
            }
            catch (Throwable ex) {
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u5b9e\u4f53[%1$s]\u5220\u9664\u6307\u5b9a\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strName, ex.getMessage()), ex);
            }
        }
        return list.size();
    }

    protected ISystemRuntimeContext getSystemRuntimeContext() {
        return this.iSystemRuntimeContext;
    }

    @Override
    public ISystemRuntime getSystemRuntime() {
        return this.getSystemRuntimeContext().getSystemRuntime();
    }

    @Override
    public void exception(String strErrorInfo) {
        throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), strErrorInfo);
    }

    @Override
    public void exception(String strErrorInfo, int nErrorCode) {
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntimeContext().getSystemRuntime(), strErrorInfo, nErrorCode);
    }

    @Override
    public void info(String strInfo) {
        log.info((Object)strInfo);
        this.getSystemRuntimeContext().getSystemRuntime().log(20000, "SCRIPT", strInfo, null);
    }

    @Override
    public void warn(String strInfo) {
        log.warn((Object)strInfo);
        this.getSystemRuntimeContext().getSystemRuntime().log(30000, "SCRIPT", strInfo, null);
    }

    @Override
    public void error(String strInfo) {
        log.error((Object)strInfo);
        this.getSystemRuntimeContext().getSystemRuntime().log(40000, "SCRIPT", strInfo, null);
    }

    @Override
    public IScriptUtil getUtil() {
        return this.iScriptUtil;
    }

    @Override
    public Object call(String strName, Object ... objects) {
        ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
        if (actionSession.getDynaInstRuntime() != null) {
            IPSSysLogic iPSSysLogic = actionSession.getDynaInstRuntime().getPSSysLogic(strName);
            if (iPSSysLogic == null) {
                throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u9884\u7f6e\u903b\u8f91[%1$s]\u6a21\u578b\u5bf9\u8c61", strName));
            }
            ISysLogicRuntime iSysLogicRuntime = actionSession.getDynaInstRuntime().getSysLogicRuntime(iPSSysLogic);
            return iSysLogicRuntime.execute(objects);
        }
        IPSSysLogic iPSSysLogic = this.getSystemRuntimeContext().getSystemRuntime().getPSSysLogic(strName);
        if (iPSSysLogic == null) {
            throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u9884\u7f6e\u903b\u8f91[%1$s]\u6a21\u578b\u5bf9\u8c61", strName));
        }
        ISysLogicRuntime iSysLogicRuntime = this.getSystemRuntimeContext().getSystemRuntime().getSysLogicRuntime(iPSSysLogic);
        return iSysLogicRuntime.execute(objects);
    }

    @Override
    public void setSessionParam(String strName, Object objValue) {
        ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
        actionSession.setActionParam(strName.toUpperCase(), objValue);
    }

    @Override
    public Object removeSessionParam(String strName) {
        ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
        return actionSession.removeActionParam(strName.toUpperCase());
    }

    @Override
    public boolean containsSessionParam(String strName) {
        ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
        return actionSession.containsActionParam(strName.toUpperCase());
    }

    @Override
    public Object getSessionParam(String strName) {
        ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
        return actionSession.getActionParam(strName.toUpperCase());
    }

    @Override
    public void setActionParam(String strName, Object objValue) {
        ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
        String strParamKey = String.format("%1$s_%2$s", strName.toUpperCase(), actionSession.getSessionId());
        actionSession.setActionParam(strParamKey, objValue);
    }

    @Override
    public Object removeActionParam(String strName) {
        ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
        String strParamKey = String.format("%1$s_%2$s", strName.toUpperCase(), actionSession.getSessionId());
        return actionSession.removeActionParam(strParamKey);
    }

    @Override
    public boolean containsActionParam(String strName) {
        ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
        String strParamKey = String.format("%1$s_%2$s", strName.toUpperCase(), actionSession.getSessionId());
        return actionSession.containsActionParam(strParamKey);
    }

    @Override
    public Object getActionParam(String strName) {
        ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
        String strParamKey = String.format("%1$s_%2$s", strName.toUpperCase(), actionSession.getSessionId());
        return actionSession.getActionParam(strParamKey);
    }

    @Override
    public IScriptSearchContext filter(String strName) {
        try {
            IDataEntityRuntime iDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(strName);
            return iDataEntityRuntime.createScriptSearchContext(null);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u6a21\u578b\u5bf9\u8c61", strName));
        }
    }

    @Override
    public IScriptUserContext user() {
        return this.scriptUserContext;
    }

    @Override
    public IScriptAppContext context() {
        IAppContext iAppContext = ActionSessionManager.getAppContext();
        if (iAppContext == null) {
            iAppContext = AppContext.newInstance(null);
            ActionSessionManager.getCurrentSessionMust().setAppContext(iAppContext);
        }
        return this.scriptAppContext;
    }

    @Override
    public IScriptCodeList codelist(String strTag) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6807\u8bc6\u65e0\u6548");
        String strCacheTag = String.format("_IScriptCodeList_%1$s", strTag).toLowerCase();
        Object obj = this.getCache(strCacheTag);
        if (obj == null) {
            IPSCodeList iPSCodeList = this.getSystemRuntime().getPSSystemService().getPSCodeList(strTag, false);
            ICodeListRuntime iCodeListRuntime = this.getSystemRuntime().getCodeListRuntime(iPSCodeList);
            ScriptCodeList iScriptCodeList = new ScriptCodeList(iCodeListRuntime);
            this.setCache(strCacheTag, iScriptCodeList);
            return iScriptCodeList;
        }
        return (IScriptCodeList)obj;
    }

    @Override
    public String uniqueid(Object ... args) {
        if (args != null && args.length > 0) {
            return KeyValueUtils.genUniqueId(args);
        }
        return KeyValueUtils.genUniqueId();
    }

    protected Object getCache(String strKey) {
        return this.cacheMap.get(strKey);
    }

    protected void setCache(String strKey, Object objValue) {
        this.cacheMap.put(strKey, objValue);
    }

    @Override
    public String format(Object value, String strFormat) {
        if ((value = ScriptUtils.getReal(value)) == null) {
            return null;
        }
        if (value instanceof Date) {
            return new SimpleDateFormat(strFormat).format((Date)value);
        }
        return value.toString();
    }

    @Override
    public IScriptWebContext request() {
        return this.request(false);
    }

    @Override
    public IScriptWebContext request(boolean bTryMode) {
        if (bTryMode) {
            if (ActionSessionManager.getUserContextMust().getWebContext() != null) {
                return this.scriptWebContext;
            }
            return null;
        }
        ActionSessionManager.getUserContextMust().getWebContextMust();
        return this.scriptWebContext;
    }
}

