/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.ibizsys.runtime.util.IWebContext;
import net.ibizsys.runtime.util.JsonUtils;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WebContext
implements IWebContext {
    @JsonIgnore
    private transient ServletRequest servletRequest = null;
    @JsonIgnore
    private transient MultiValueMap<String, String> parameterMap = new LinkedMultiValueMap();
    @JsonIgnore
    private transient MultiValueMap<String, String> headerMap = new LinkedMultiValueMap();

    public WebContext(ServletRequest servletRequest) {
        this.servletRequest = servletRequest;
        if (this.servletRequest != null) {
            HttpServletRequest httpServletRequest;
            Enumeration headers;
            Map paramMap = servletRequest.getParameterMap();
            if (!ObjectUtils.isEmpty((Object)paramMap)) {
                for (Map.Entry entry : paramMap.entrySet()) {
                    if (entry.getValue() == null || ((String[])entry.getValue()).length <= 0) continue;
                    this.parameterMap.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
                }
            }
            if (servletRequest instanceof HttpServletRequest && (headers = (httpServletRequest = (HttpServletRequest)servletRequest).getHeaderNames()) != null) {
                while (headers.hasMoreElements()) {
                    String strHeader = (String)headers.nextElement();
                    Enumeration values = httpServletRequest.getHeaders(strHeader);
                    if (values == null) continue;
                    ArrayList list = new ArrayList();
                    while (values.hasMoreElements()) {
                        list.add(values.nextElement());
                    }
                    this.headerMap.put((Object)strHeader, list);
                }
            }
        }
    }

    @Override
    @JsonIgnore
    public String getParameter(String name) {
        List<String> value = this.getParameterValues(name);
        if (!ObjectUtils.isEmpty(value)) {
            return value.get(0);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public List<String> getParameterValues(String name) {
        List value;
        Assert.hasLength((String)name, (String)"\u4f20\u5165\u53c2\u6570\u952e\u540d\u65e0\u6548");
        MultiValueMap<String, String> map = this.getParameters();
        if (!ObjectUtils.isEmpty(map) && (value = (List)map.get((Object)name)) == null) {
            for (Map.Entry entry : map.entrySet()) {
                if (!name.equalsIgnoreCase((String)entry.getKey())) continue;
                return (List)entry.getValue();
            }
        }
        return null;
    }

    @Override
    @JsonProperty(value="parameters")
    public MultiValueMap<String, String> getParameters() {
        return this.parameterMap;
    }

    @JsonProperty(value="parameters")
    public void setParameters(MultiValueMap<String, String> parameterMap) {
        this.parameterMap.clear();
        if (!ObjectUtils.isEmpty(parameterMap)) {
            this.parameterMap.putAll(parameterMap);
        }
    }

    @Override
    @JsonIgnore
    public String getHeader(String name) {
        List<String> value = this.getHeaderValues(name);
        if (!ObjectUtils.isEmpty(value)) {
            return value.get(0);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public List<String> getHeaderValues(String name) {
        List value;
        Assert.hasLength((String)name, (String)"\u4f20\u5165\u5934\u90e8\u952e\u540d\u65e0\u6548");
        MultiValueMap<String, String> map = this.getHeaders();
        if (!ObjectUtils.isEmpty(map) && (value = (List)map.get((Object)name)) == null) {
            for (Map.Entry entry : map.entrySet()) {
                if (!name.equalsIgnoreCase((String)entry.getKey())) continue;
                return (List)entry.getValue();
            }
        }
        return null;
    }

    @Override
    @JsonProperty(value="headers")
    public MultiValueMap<String, String> getHeaders() {
        return this.headerMap;
    }

    @JsonProperty(value="headers")
    public void setHeaders(MultiValueMap<String, String> headerMap) {
        this.headerMap.clear();
        if (!ObjectUtils.isEmpty(headerMap)) {
            this.headerMap.putAll(headerMap);
        }
    }

    @JsonIgnore
    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    @Override
    @JsonIgnore
    public List<String> getParameterNames() {
        return new ArrayList<String>(this.parameterMap.keySet());
    }

    @Override
    @JsonIgnore
    public List<String> getHeaderNames() {
        return new ArrayList<String>(this.headerMap.keySet());
    }

    public String toString() {
        return JsonUtils.toString(this);
    }
}

