/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.res;

import com.fasterxml.jackson.databind.JsonNode;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.res.IPSSysTranslator;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBaseContext;
import net.ibizsys.runtime.SystemModelRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.res.ISysTranslatorRuntime;
import net.ibizsys.runtime.util.IEntityBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SysTranslatorRuntimeBase
extends SystemModelRuntimeBase
implements ISysTranslatorRuntime {
    private static final Log log = LogFactory.getLog(SysTranslatorRuntimeBase.class);
    private IPSSysTranslator iPSSysTranslator = null;

    @Override
    public void init(ISystemRuntimeBaseContext iSystemRuntimeBaseContext, IPSSysTranslator iPSSysTranslator) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeBaseContext);
        this.iPSSysTranslator = iPSSysTranslator;
        this.setConfigFolder("systranslator." + PSModelUtils.calcUniqueTag((IPSSystemModule)this.iPSSysTranslator.getPSSystemModule(), (String)this.iPSSysTranslator.getCodeName()));
        this.onInit();
    }

    @Override
    public IPSSysTranslator getPSSysTranslator() {
        return this.iPSSysTranslator;
    }

    @Override
    public String getId() {
        return this.getPSSysTranslator().getDynaModelFilePath();
    }

    @Override
    public String getName() {
        return this.getPSSysTranslator().getName();
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysTranslator();
    }

    @Override
    public Object translate(Object objValue, boolean bIn) throws Throwable {
        return this.translate(objValue, bIn, null, null, null);
    }

    protected String getTranslatorParam(String strKey, String strDefault) {
        JsonNode node;
        if (this.getPSSysTranslator().getTranslatorParams() != null && (node = this.getPSSysTranslator().getTranslatorParams().get(strKey)) != null) {
            return node.asText(strDefault);
        }
        return strDefault;
    }

    protected int getTranslatorParam(String strKey, int nDefault) {
        JsonNode node;
        if (this.getPSSysTranslator().getTranslatorParams() != null && (node = this.getPSSysTranslator().getTranslatorParams().get(strKey)) != null) {
            return node.asInt(nDefault);
        }
        return nDefault;
    }

    protected double getTranslatorParam(String strKey, double fDefault) {
        JsonNode node;
        if (this.getPSSysTranslator().getTranslatorParams() != null && (node = this.getPSSysTranslator().getTranslatorParams().get(strKey)) != null) {
            return node.asDouble(fDefault);
        }
        return fDefault;
    }

    protected boolean getTranslatorParam(String strKey, boolean bDefault) {
        JsonNode node;
        if (this.getPSSysTranslator().getTranslatorParams() != null && (node = this.getPSSysTranslator().getTranslatorParams().get(strKey)) != null) {
            return node.asBoolean(bDefault);
        }
        return bDefault;
    }

    @Override
    public Object translate(Object objValue, boolean bIn, IEntityBase iEntityBase, IPSDEField iPSDEField, IDataEntityRuntime entityDataEntityRuntime) throws Throwable {
        try {
            return this.onTranslate(objValue, bIn, iEntityBase, iPSDEField, entityDataEntityRuntime);
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u503c\u8f6c\u6362\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onTranslate(Object objValue, boolean bIn, IEntityBase iEntityBase, IPSDEField iPSDEField, IDataEntityRuntime entityDataEntityRuntime) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }
}

