/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.plugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.runtime.ISystemRuntime;
import net.ibizsys.runtime.ISystemRuntimeContext;
import net.ibizsys.runtime.plugin.IRuntimeObjectFactory;
import net.ibizsys.runtime.res.ISysSFPluginRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SysSFPluginRuntimeObjectFactory
implements IRuntimeObjectFactory {
    private static final Log log = LogFactory.getLog(SysSFPluginRuntimeObjectFactory.class);
    private final Map<String, RuntimeObject> runtimeObjMap = new ConcurrentHashMap<String, RuntimeObject>();
    private final Map<String, Map> runtimeObjListMap = new ConcurrentHashMap<String, Map>();
    private ISystemRuntimeContext iSystemRuntimeContext = null;
    private IRuntimeObjectFactory inheritRuntimeObjectFactory = null;

    public void init(ISystemRuntimeContext iSystemRuntimeContext, IRuntimeObjectFactory inheritRuntimeObjectFactory) throws Exception {
        Assert.notNull((Object)iSystemRuntimeContext, (String)"\u4f20\u5165\u7cfb\u7edf\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        this.iSystemRuntimeContext = iSystemRuntimeContext;
        this.inheritRuntimeObjectFactory = inheritRuntimeObjectFactory;
        this.onInit();
    }

    protected void onInit() throws Exception {
        this.loadSysSFPluginRuntimes();
    }

    protected void loadSysSFPluginRuntimes() throws Exception {
        Collection<ISysSFPluginRuntime> sysSFPluginRuntimes = this.getSystemRuntime().getSysSFPluginRuntimes();
        if (ObjectUtils.isEmpty(sysSFPluginRuntimes)) {
            return;
        }
        for (ISysSFPluginRuntime iSysSFPluginRuntime : sysSFPluginRuntimes) {
            Class<?> type = iSysSFPluginRuntime.getGlobalRuntimeObjectClass();
            if (type == null) continue;
            this.registerObjectIf(type, iSysSFPluginRuntime.getGlobalRuntimeObjectType(), iSysSFPluginRuntime);
        }
    }

    protected ISystemRuntimeContext getSystemRuntimeContext() {
        return this.iSystemRuntimeContext;
    }

    public ISystemRuntime getSystemRuntime() {
        return this.getSystemRuntimeContext().getSystemRuntime();
    }

    protected IRuntimeObjectFactory getInheritRuntimeObjectFactory() {
        return this.inheritRuntimeObjectFactory;
    }

    protected boolean registerRuntimeObject(Class<?> cls, String strType, Object objObject) {
        return this.registerRuntimeObject(cls, strType, objObject, 100);
    }

    protected boolean registerRuntimeObject(Class<?> cls, String strType, Object objObject, int nOrder) {
        ISysSFPluginRuntime iSysSFPluginRuntime = null;
        if (objObject instanceof ISysSFPluginRuntime) {
            iSysSFPluginRuntime = (ISysSFPluginRuntime)((Object)objObject);
            objObject = iSysSFPluginRuntime.getRuntimeObjectClass();
        } else if (objObject instanceof String) {
            try {
                objObject = Class.forName((String)((Object)objObject));
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (!(objObject instanceof Class)) {
            return false;
        }
        String strTag = null;
        strTag = StringUtils.hasLength((String)strType) ? String.format("%1$s|%2$s", this.getObjectType(cls), strType) : String.format("%1$s|", this.getObjectType(cls));
        RuntimeObject lastObject = this.runtimeObjMap.get(strTag);
        if (lastObject != null) {
            if (nOrder > lastObject.order) {
                log.warn((Object)String.format("\u65e0\u6cd5\u6ce8\u518c\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s][%2$s]\uff0c\u4f18\u5148\u7ea7\u4e0d\u8db3", objObject, strTag));
                return false;
            }
            log.warn((Object)String.format("\u6ce8\u518c\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s][%2$s]\uff0c\u66ff\u6362[%3$s]", objObject, strTag, lastObject.object));
        } else {
            log.debug((Object)String.format("\u6ce8\u518c\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s][%2$s]", objObject, strTag));
        }
        RuntimeObject runtimeObject = new RuntimeObject();
        runtimeObject.object = objObject;
        runtimeObject.order = nOrder;
        runtimeObject.plugin = iSysSFPluginRuntime;
        this.runtimeObjMap.put(strTag, runtimeObject);
        return true;
    }

    @Override
    public boolean registerObject(Class<?> cls, String strType, Object strObject) {
        return this.registerObject(cls, strType, strObject, 100);
    }

    @Override
    public boolean registerObjectPrimary(Class<?> cls, String strType, Object strObject) {
        return this.registerObject(cls, strType, strObject, 50);
    }

    @Override
    public boolean registerObject(Class<?> cls, String strType, Object strObject, int nOrderValue) {
        return this.registerRuntimeObject(cls, strType, strObject, nOrderValue);
    }

    @Override
    public boolean registerObjectIf(Class<?> cls, String strType, Object strObject) {
        if (this.internalContainsObject(cls, strType)) {
            return false;
        }
        return this.registerObject(cls, strType, strObject);
    }

    @Override
    public boolean containsObject(Class<?> cls, String strType) {
        if (this.internalContainsObject(cls, strType)) {
            return true;
        }
        if (this.getInheritRuntimeObjectFactory() != null) {
            return this.getInheritRuntimeObjectFactory().containsObject(cls, strType);
        }
        return false;
    }

    protected boolean internalContainsObject(Class<?> cls, String strType) {
        RuntimeObject runtimeObject = null;
        runtimeObject = StringUtils.hasLength((String)strType) ? this.runtimeObjMap.get(String.format("%1$s|%2$s", this.getObjectType(cls), strType)) : this.runtimeObjMap.get(String.format("%1$s|", this.getObjectType(cls)));
        return !ObjectUtils.isEmpty((Object)runtimeObject);
    }

    @Override
    public <T> T getObject(Class<T> cls) {
        return this.getObject(cls, "");
    }

    @Override
    public <T> T getObject(Class<T> cls, String strType) {
        T t = this.internalGetObject(cls, strType);
        if (t != null) {
            return t;
        }
        if (this.getInheritRuntimeObjectFactory() != null) {
            return this.getInheritRuntimeObjectFactory().getObject(cls, strType);
        }
        return t;
    }

    protected <T> T internalGetObject(Class<T> cls, String strType) {
        RuntimeObject runtimeObject = null;
        runtimeObject = StringUtils.hasLength((String)strType) ? this.runtimeObjMap.get(String.format("%1$s|%2$s", this.getObjectType(cls), strType)) : this.runtimeObjMap.get(String.format("%1$s|", this.getObjectType(cls)));
        if (ObjectUtils.isEmpty((Object)runtimeObject)) {
            return null;
        }
        return this.getObject(cls, runtimeObject, false);
    }

    @Override
    public Class<?> getObjectClass(Class<?> cls) {
        return this.getObjectClass(cls, "");
    }

    @Override
    public Class<?> getObjectClass(Class<?> cls, String strType) {
        Class<?> ret = this.internalGetObjectClass(cls, strType);
        if (ret == null && this.getInheritRuntimeObjectFactory() != null) {
            return this.getInheritRuntimeObjectFactory().getObjectClass(cls, strType);
        }
        return ret;
    }

    protected Class<?> internalGetObjectClass(Class<?> cls, String strType) {
        RuntimeObject runtimeObject = null;
        runtimeObject = StringUtils.hasLength((String)strType) ? this.runtimeObjMap.get(String.format("%1$s|%2$s", this.getObjectType(cls), strType)) : this.runtimeObjMap.get(String.format("%1$s|", this.getObjectType(cls)));
        if (ObjectUtils.isEmpty((Object)runtimeObject)) {
            return null;
        }
        return runtimeObject.object;
    }

    @Override
    public <T> Map<String, T> getObjects(Class<T> cls) {
        return this.getObjects(cls, null);
    }

    @Override
    public <T> Map<String, T> getObjects(Class<T> cls, String strTypePrefix) {
        Map<String, T> map = this.internalGetObjects(cls, strTypePrefix);
        Map<String, T> map2 = null;
        if (this.getInheritRuntimeObjectFactory() != null) {
            Map<String, T> map3 = null;
            if (StringUtils.hasLength((String)strTypePrefix)) {
                map3 = this.getInheritRuntimeObjectFactory().getObjects(cls, "*:");
            }
            map2 = this.getInheritRuntimeObjectFactory().getObjects(cls, strTypePrefix);
            if (!ObjectUtils.isEmpty(map3)) {
                if (ObjectUtils.isEmpty(map2)) {
                    map2 = map3;
                } else {
                    map3.putAll(map2);
                    map2 = map3;
                }
            }
        }
        if (ObjectUtils.isEmpty(map)) {
            if (ObjectUtils.isEmpty(map2)) {
                return map;
            }
            return map2;
        }
        if (ObjectUtils.isEmpty(map2)) {
            return map;
        }
        HashMap<String, T> total = new HashMap<String, T>();
        total.putAll(map2);
        total.putAll(map);
        return total;
    }

    protected <T> Map<String, T> internalGetObjects(Class<T> cls, String strTypePrefix) {
        String strTag = null;
        strTag = StringUtils.hasLength((String)strTypePrefix) ? String.format("%1$s|%2$s", this.getObjectType(cls), strTypePrefix) : String.format("%1$s|", this.getObjectType(cls));
        Map objMap = this.runtimeObjListMap.get(strTag);
        if (objMap != null) {
            return objMap;
        }
        HashMap<String, T> map = new HashMap<String, T>();
        for (Map.Entry<String, RuntimeObject> entry : this.runtimeObjMap.entrySet()) {
            T t;
            if (entry.getKey().indexOf(strTag) != 0 || (t = this.getObject(cls, entry.getValue(), true)) == null) continue;
            map.put(entry.getKey().substring(strTag.length()), t);
        }
        this.runtimeObjListMap.put(strTag, map);
        return map;
    }

    protected <T> T getObject(Class<T> cls, RuntimeObject runtimeObject, boolean bTryMode) {
        if (cls.isAssignableFrom(runtimeObject.object)) {
            try {
                if (runtimeObject.plugin != null) {
                    return (T)runtimeObject.plugin.getRuntimeObject(true);
                }
                return (T)runtimeObject.object.newInstance();
            }
            catch (Exception e) {
                if (bTryMode) {
                    log.warn((Object)String.format("\u65e0\u6cd5\u5efa\u7acb\u63d2\u4ef6\u5bf9\u8c61[%1$s]", runtimeObject.object));
                    return null;
                }
                throw new RuntimeException(e);
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new RuntimeException(String.format("[%1$s]\u7c7b\u578b\u4e0d\u6b63\u786e", runtimeObject.object));
    }

    protected String getObjectType(Class<?> cls) {
        return cls.getSimpleName();
    }

    static class RuntimeObject {
        public Class<?> object = null;
        public int order = 100;
        public ISysSFPluginRuntime plugin = null;
    }
}

