/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.codelist;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.codelist.IPSCodeItem;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.codelist.CodeListRuntimeBase;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import net.ibizsys.runtime.util.JsonUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;

public class DynamicCodeListRuntime
extends CodeListRuntimeBase {
    private List<IPSCodeItem> psCodeItemList = null;

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    @Override
    public List<IPSCodeItem> getPSCodeItems() {
        try {
            return this.onGetPSCodeItems();
        }
        catch (Throwable ex) {
            SystemRuntimeException.rethrow(this, ex);
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u83b7\u53d6\u4ee3\u7801\u9879\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected List<IPSCodeItem> onGetPSCodeItems() throws Throwable {
        List<IPSCodeItem> psCodeItemList = this.psCodeItemList;
        if (psCodeItemList == null) {
            psCodeItemList = new ArrayList<IPSCodeItem>();
            IPSDataEntity iPSDataEntity = this.getPSCodeList().getPSDataEntityMust();
            IDataEntityRuntime iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDataEntity.getId());
            IPSDEDataSet iPSDEDataSet = this.getPSCodeList().getPSDEDataSet();
            if (iPSDEDataSet == null) {
                iPSDEDataSet = iPSDataEntity.getDefaultPSDEDataSetMust();
            }
            ISearchContextBase iSearchContextBase = iDataEntityRuntime.createSearchContext();
            if (StringUtils.hasLength((String)this.getPSCodeList().getCustomCond())) {
                iDataEntityRuntime.setSearchCustomCondition(iSearchContextBase, this.getPSCodeList().getCustomCond());
            }
            this.fillSearchContext(iSearchContextBase);
            Sort sort = Sort.unsorted();
            if (this.getPSCodeList().getMinorSortPSDEField() != null) {
                ArrayList<Sort.Order> list = new ArrayList<Sort.Order>();
                if ("DESC".equalsIgnoreCase(this.getPSCodeList().getMinorSortDir())) {
                    list.add(Sort.Order.desc((String)this.getPSCodeList().getMinorSortPSDEField().getLowerCaseName()));
                } else {
                    list.add(Sort.Order.asc((String)this.getPSCodeList().getMinorSortPSDEField().getLowerCaseName()));
                }
                sort = Sort.by(list);
            }
            iDataEntityRuntime.setSearchPaging(iSearchContextBase, 0, Integer.MAX_VALUE, sort);
            iDataEntityRuntime.setSearchMode(iSearchContextBase, true, false);
            Page<? extends IEntityBase> page = iDataEntityRuntime.searchDataSet(iPSDEDataSet, iSearchContextBase);
            if (page != null && page.getContent() != null) {
                for (IEntityBase item : page.getContent()) {
                    Object objValue = null;
                    Object objText = null;
                    objValue = this.getPSCodeList().getValuePSDEField() != null ? iDataEntityRuntime.getFieldValue(item, this.getPSCodeList().getValuePSDEField()) : iDataEntityRuntime.getFieldValue(item, iDataEntityRuntime.getKeyPSDEField());
                    if (this.getPSCodeList().getTextPSDEField() != null) {
                        objText = iDataEntityRuntime.getFieldValue(item, this.getPSCodeList().getTextPSDEField());
                    } else if (iDataEntityRuntime.getMajorPSDEField() != null) {
                        objText = iDataEntityRuntime.getFieldValue(item, iDataEntityRuntime.getMajorPSDEField());
                    }
                    if (objText == null) {
                        objText = objValue;
                    }
                    Object objColor = null;
                    if (this.getPSCodeList().getColorPSDEField() != null) {
                        objColor = iDataEntityRuntime.getFieldValue(item, this.getPSCodeList().getColorPSDEField());
                    }
                    Object objBKColor = null;
                    if (this.getPSCodeList().getBKColorPSDEField() != null) {
                        objBKColor = iDataEntityRuntime.getFieldValue(item, this.getPSCodeList().getBKColorPSDEField());
                    }
                    Object objTextCls = null;
                    if (this.getPSCodeList().getClsPSDEField() != null) {
                        objTextCls = iDataEntityRuntime.getFieldValue(item, this.getPSCodeList().getClsPSDEField());
                    }
                    Object objIconCls = null;
                    if (this.getPSCodeList().getIconClsPSDEField() != null) {
                        objIconCls = iDataEntityRuntime.getFieldValue(item, this.getPSCodeList().getIconClsPSDEField());
                    }
                    ObjectNode objNode = JsonUtils.createObjectNode();
                    objNode.put("id", String.valueOf(objValue));
                    objNode.put("name", String.valueOf(objText));
                    objNode.put("value", String.valueOf(objValue));
                    objNode.put("text", String.valueOf(objText));
                    if (objColor != null) {
                        objNode.put("color", String.valueOf(objColor));
                    }
                    if (objBKColor != null) {
                        objNode.put("bKColor", String.valueOf(objBKColor));
                    }
                    if (objTextCls != null) {
                        objNode.put("textCls", String.valueOf(objTextCls));
                    }
                    if (objIconCls != null) {
                        objNode.put("iconCls", String.valueOf(objIconCls));
                    }
                    IPSCodeItem iPSCodeItem = (IPSCodeItem)this.getSystemRuntimeBaseContext().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getPSCodeList(), IPSCodeItem.class, objNode);
                    psCodeItemList.add(iPSCodeItem);
                }
            }
        }
        if (this.psCodeItemList == null) {
            this.psCodeItemList = psCodeItemList;
        }
        return psCodeItemList;
    }

    @Override
    protected void onReset() {
        this.psCodeItemList = null;
        super.onReset();
    }

    protected void fillSearchContext(ISearchContextBase iSearchContextBase) throws Throwable {
    }
}

