/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.backend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import net.ibizsys.runtime.IDynaInstRuntime;
import net.ibizsys.runtime.backend.SysBackendTaskRuntimeBase;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.domain.DataSyncIn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SysDataSyncAgentBackendTaskRuntimeBase
extends SysBackendTaskRuntimeBase {
    private static final Log log = LogFactory.getLog(SysDataSyncAgentBackendTaskRuntimeBase.class);

    @Override
    protected Object onExecute(String strDynaInstId, String strParam, ProceedingJoinPoint joinPoint) throws Throwable {
        JsonNode jsonNode = JsonUtils.MAPPER.readTree(strParam);
        ObjectNode packageNode = (ObjectNode)jsonNode;
        String strAgent = null;
        if (packageNode.has("agent")) {
            strAgent = packageNode.get("agent").asText();
        }
        if (!StringUtils.hasLength(strAgent)) {
            if (joinPoint != null) {
                return joinPoint.proceed();
            }
            return null;
        }
        Collection<ISysDataSyncAgentRuntime> inSysDataSyncAgentRuntimeList = null;
        if (StringUtils.hasLength((String)strDynaInstId)) {
            IDynaInstRuntime iDynaInstRuntime = this.getSystemRuntime().getDynaInstRuntime(strDynaInstId);
            inSysDataSyncAgentRuntimeList = iDynaInstRuntime.getInSysDataSyncAgentRuntimes();
        } else {
            inSysDataSyncAgentRuntimeList = this.getSystemRuntime().getInSysDataSyncAgentRuntimes();
        }
        if (ObjectUtils.isEmpty(inSysDataSyncAgentRuntimeList)) {
            if (joinPoint != null) {
                return joinPoint.proceed();
            }
            return null;
        }
        String strData = null;
        if (packageNode.has("data")) {
            strData = packageNode.get("data").asText();
        }
        DataSyncIn[] dataSyncIns = null;
        if (StringUtils.hasLength(strData)) {
            if (strData.indexOf("[") == 0) {
                dataSyncIns = (DataSyncIn[])JsonUtils.MAPPER.readValue(strData, DataSyncIn[].class);
            } else if (strData.indexOf("{") == 0) {
                dataSyncIns = new DataSyncIn[]{(DataSyncIn)JsonUtils.MAPPER.readValue(strData, DataSyncIn.class)};
            }
        }
        if (dataSyncIns == null) {
            if (joinPoint != null) {
                return joinPoint.proceed();
            }
            return null;
        }
        for (ISysDataSyncAgentRuntime iSysDataSyncAgentRuntime : inSysDataSyncAgentRuntimeList) {
            iSysDataSyncAgentRuntime.recv(dataSyncIns);
        }
        if (joinPoint != null) {
            return joinPoint.proceed();
        }
        return null;
    }
}

