/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.util.script;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.script.IScriptList;
import net.ibizsys.central.util.script.IScriptPage;
import net.ibizsys.central.util.script.IScriptSequence;
import net.ibizsys.central.util.script.IScriptTranslator;
import net.ibizsys.central.util.script.IScriptWebClient;
import net.ibizsys.central.util.script.ISystemRTScriptContext;
import net.ibizsys.central.util.script.ScriptPageImpl;
import net.ibizsys.central.util.script.ScriptSequence;
import net.ibizsys.central.util.script.ScriptTranslator;
import net.ibizsys.central.util.script.ScriptWebClient;
import net.ibizsys.model.res.IPSSysSequence;
import net.ibizsys.model.res.IPSSysTranslator;
import net.ibizsys.model.service.IPSSubSysServiceAPI;
import net.ibizsys.runtime.util.DateUtils;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.script.IScriptEntity;
import net.ibizsys.runtime.util.script.ScriptUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;

public class SystemRTScriptContext
extends net.ibizsys.runtime.util.script.SystemRTScriptContext
implements ISystemRTScriptContext {
    private ISystemRuntimeContext iSystemRuntimeContext = null;
    private IScriptWebClient iScriptWebClient = null;

    public SystemRTScriptContext(ISystemRuntimeContext iSystemRuntimeContext) {
        super(iSystemRuntimeContext);
        this.iSystemRuntimeContext = iSystemRuntimeContext;
    }

    @Override
    protected ISystemRuntimeContext getSystemRuntimeContext() {
        return this.iSystemRuntimeContext;
    }

    @Override
    public ISystemRuntime getSystemRuntime() {
        return this.getSystemRuntimeContext().getSystemRuntime();
    }

    @Override
    public IScriptEntity entity() {
        return this.entity(true, null);
    }

    @Override
    public IScriptEntity entity(String strName) {
        return this.entity(strName, null);
    }

    @Override
    public IScriptEntity entity(Object obj) {
        return this.entity(obj, null);
    }

    @Override
    public IScriptEntity entity(Object obj, Object data) {
        if (data != null) {
            data = ScriptUtils.getReal(data);
        }
        if (obj instanceof String) {
            String strName = obj.toString();
            IDataEntityRuntime iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(strName);
            IEntityBase iEntityBase = null;
            iEntityBase = data != null ? iDataEntityRuntime.deserializeEntity(data) : iDataEntityRuntime.createEntity();
            return iDataEntityRuntime.createScriptEntity(iEntityBase);
        }
        boolean bLowerCaseField = true;
        if (obj instanceof Boolean) {
            bLowerCaseField = (Boolean)obj;
        }
        Map map = null;
        if (data != null) {
            map = this.getSystemRuntime().deserialize(data, Map.class);
        }
        IEntity iEntity = this.getSystemRuntime().createEntity(map, bLowerCaseField);
        return this.getSystemRuntime().createScriptEntity(iEntity);
    }

    @Override
    public IScriptList list() {
        return this.list(null);
    }

    @Override
    public IScriptList list(Object obj) {
        return this.list(obj, null);
    }

    @Override
    public IScriptList list(Object obj, Object data) {
        IScriptList scriptList;
        List<IEntityDTO> source = null;
        if (data != null) {
            if (obj instanceof String) {
                String strName = obj.toString();
                IDataEntityRuntime iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(strName);
                source = iDataEntityRuntime.deserializeEntityList(data);
            } else {
                source = this.getSystemRuntime().deserialize(data, List.class);
            }
        }
        ArrayList list = new ArrayList();
        if (obj instanceof Boolean) {
            scriptList = this.getSystemRuntime().createScriptList(list, (Boolean)obj);
            if (source != null) {
                scriptList.addAll(source);
            }
            return scriptList;
        }
        scriptList = this.getSystemRuntime().createScriptList(list);
        if (source != null) {
            scriptList.addAll(source);
        }
        return scriptList;
    }

    @Override
    public IScriptPage page() {
        return this.page(null);
    }

    @Override
    public IScriptPage page(Object obj) {
        return this.page(obj, null);
    }

    @Override
    public IScriptPage page(Object obj, Object data) {
        IScriptPage iScriptPage;
        List<IEntityDTO> source = null;
        if (data != null) {
            if (obj instanceof String) {
                String strName = obj.toString();
                IDataEntityRuntime iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(strName);
                source = iDataEntityRuntime.deserializeEntityList(data);
            } else {
                source = this.getSystemRuntime().deserialize(data, List.class);
            }
        }
        ScriptPageImpl page = new ScriptPageImpl(new ArrayList(), Pageable.unpaged(), 0L);
        if (obj instanceof Boolean) {
            iScriptPage = this.getSystemRuntime().createScriptPage((Page<?>)page, (Boolean)obj);
            if (source != null) {
                iScriptPage.addAll(source);
            }
            return iScriptPage;
        }
        iScriptPage = this.getSystemRuntime().createScriptPage((Page<?>)page);
        if (source != null) {
            iScriptPage.addAll(source);
        }
        return iScriptPage;
    }

    @Override
    public IScriptSequence sequence(String strTag) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6807\u8bc6\u65e0\u6548");
        String strCacheTag = String.format("_IScriptSequence_%1$s", strTag).toLowerCase();
        Object obj = this.getCache(strCacheTag);
        if (obj == null) {
            IPSSysSequence iPSSysSequence = this.getSystemRuntimeContext().getPSSystemService().getPSSysSequence(strTag, false);
            ScriptSequence iScriptSequence = new ScriptSequence(this.getSystemRuntime().getSysSequenceRuntime(iPSSysSequence));
            this.setCache(strCacheTag, iScriptSequence);
            return iScriptSequence;
        }
        return (IScriptSequence)obj;
    }

    @Override
    public IScriptTranslator translator(String strTag) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6807\u8bc6\u65e0\u6548");
        String strCacheTag = String.format("_IScriptTranslator_%1$s", strTag).toLowerCase();
        Object obj = this.getCache(strCacheTag);
        if (obj == null) {
            IPSSysTranslator iPSSysTranslator = this.getSystemRuntime().getPSSystemService().getPSSysTranslator(strTag, false);
            ScriptTranslator iScriptTranslator = new ScriptTranslator(this.getSystemRuntime().getSysTranslatorRuntime(iPSSysTranslator));
            this.setCache(strCacheTag, iScriptTranslator);
            return iScriptTranslator;
        }
        return (IScriptTranslator)obj;
    }

    @Override
    public IScriptWebClient webclient() {
        if (this.iScriptWebClient == null) {
            this.iScriptWebClient = new ScriptWebClient(this.getSystemRuntime(), null, this.getSystemRuntime().getDefaultWebClient());
        }
        return this.iScriptWebClient;
    }

    @Override
    public IScriptWebClient webclient(String strTag) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6807\u8bc6\u65e0\u6548");
        String strCacheTag = String.format("_IScriptWebClient_%1$s", strTag).toLowerCase();
        Object obj = this.getCache(strCacheTag);
        if (obj == null) {
            IPSSubSysServiceAPI iPSSubServiceAPI = this.getSystemRuntime().getPSSystemService().getPSSubSysServiceAPI(strTag, false);
            ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime = this.getSystemRuntime().getSubSysServiceAPIRuntime(iPSSubServiceAPI);
            ScriptWebClient iScriptWebClient = new ScriptWebClient(this.getSystemRuntime(), iSubSysServiceAPIRuntime, iSubSysServiceAPIRuntime.getWebClient());
            this.setCache(strCacheTag, iScriptWebClient);
            return iScriptWebClient;
        }
        return (IScriptWebClient)obj;
    }

    @Override
    public Object config(String strKey, Object defValue) {
        Object objValue = this.getSystemRuntime().getSystemRuntimeSetting().getParam(strKey);
        if (objValue != null) {
            return objValue;
        }
        return defValue;
    }

    @Override
    public IScriptEntity selectone(String strName, String strCondition) {
        return this.selectOne(strName, strCondition);
    }

    @Override
    public void info(String strInfo, Object ... infos) {
        StringBuilder sb = new StringBuilder();
        sb.append(strInfo);
        for (Object objInfo : infos) {
            if (objInfo == null) {
                sb.append(objInfo);
                continue;
            }
            Object objReal = ScriptUtils.getReal(objInfo);
            if (objReal instanceof Date) {
                sb.append(DateUtils.toDateTimeString((Date)objReal));
                continue;
            }
            sb.append(objReal.toString());
        }
        this.info(sb.toString());
    }

    @Override
    public void warn(String strInfo, Object ... infos) {
        StringBuilder sb = new StringBuilder();
        sb.append(strInfo);
        for (Object objInfo : infos) {
            if (objInfo == null) {
                sb.append(objInfo);
                continue;
            }
            Object objReal = ScriptUtils.getReal(objInfo);
            if (objReal instanceof Date) {
                sb.append(DateUtils.toDateTimeString((Date)objReal));
                continue;
            }
            sb.append(objReal.toString());
        }
        this.warn(sb.toString());
    }

    @Override
    public void error(String strInfo, Object ... infos) {
        StringBuilder sb = new StringBuilder();
        sb.append(strInfo);
        for (Object objInfo : infos) {
            if (objInfo == null) {
                sb.append(objInfo);
                continue;
            }
            Object objReal = ScriptUtils.getReal(objInfo);
            if (objReal instanceof Date) {
                sb.append(DateUtils.toDateTimeString((Date)objReal));
                continue;
            }
            sb.append(objReal.toString());
        }
        this.error(sb.toString());
    }
}

