/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import net.ibizsys.central.util.IWebResponse;
import net.ibizsys.runtime.util.JsonUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WebResponse
implements IWebResponse {
    @JsonIgnore
    private transient MultiValueMap<String, String> headerMap = new LinkedMultiValueMap();
    @JsonIgnore
    private transient Object body = null;
    @JsonIgnore
    private transient int nStatusCode = HttpStatus.OK.value();
    @JsonIgnore
    private transient String strContentType = null;

    @Override
    @JsonProperty(value="headers")
    public MultiValueMap<String, String> getHeaders() {
        return this.headerMap;
    }

    @JsonProperty(value="headers")
    public void setHeaders(MultiValueMap<String, String> map) {
        this.headerMap.clear();
        if (!ObjectUtils.isEmpty(map)) {
            this.headerMap.putAll(map);
        }
    }

    @Override
    @JsonIgnore
    public String getHeader(String strHeader) {
        List<String> list = this.getHeaderValues(strHeader);
        if (!ObjectUtils.isEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public List<String> getHeaderValues(String strHeader) {
        Assert.hasLength((String)strHeader, (String)"\u4f20\u5165\u5934\u90e8\u952e\u540d\u65e0\u6548");
        return (List)this.headerMap.get((Object)strHeader);
    }

    @Override
    @JsonIgnore
    public List<String> getHeaderNames() {
        return new ArrayList<String>(this.headerMap.keySet());
    }

    @Override
    @JsonIgnore
    public void addHeader(String strHeader, String strValue) {
        Assert.hasLength((String)strHeader, (String)"\u4f20\u5165\u5934\u90e8\u952e\u540d\u65e0\u6548");
        Assert.hasLength((String)strValue, (String)"\u4f20\u5165\u5934\u90e8\u503c\u65e0\u6548");
        ArrayList<String> list = (ArrayList<String>)this.headerMap.get((Object)strHeader);
        if (list == null) {
            list = new ArrayList<String>();
            this.headerMap.put((Object)strHeader, list);
        }
        if (!list.contains(strValue)) {
            list.add(strValue);
        }
    }

    @Override
    @JsonIgnore
    public void addHeaderValues(String strHeader, List<String> value) {
        Assert.hasLength((String)strHeader, (String)"\u4f20\u5165\u5934\u90e8\u952e\u540d\u65e0\u6548");
        Assert.notEmpty(value, (String)"\u4f20\u5165\u5934\u90e8\u503c\u65e0\u6548");
        ArrayList<String> list = (ArrayList<String>)this.headerMap.get((Object)strHeader);
        if (list == null) {
            list = new ArrayList<String>();
            this.headerMap.put((Object)strHeader, list);
        }
        for (String strValue : value) {
            if (list.contains(strValue)) continue;
            list.add(strValue);
        }
    }

    @Override
    @JsonIgnore
    public void setHeader(String strHeader, String strValue) {
        Assert.hasLength((String)strHeader, (String)"\u4f20\u5165\u5934\u90e8\u952e\u540d\u65e0\u6548");
        Assert.hasLength((String)strValue, (String)"\u4f20\u5165\u5934\u90e8\u503c\u65e0\u6548");
        ArrayList<String> list = (ArrayList<String>)this.headerMap.get((Object)strHeader);
        if (list == null) {
            list = new ArrayList<String>();
            this.headerMap.put((Object)strHeader, list);
        }
        list.clear();
        list.add(strValue);
    }

    @Override
    @JsonIgnore
    public void setHeaderValues(String strHeader, List<String> value) {
        Assert.hasLength((String)strHeader, (String)"\u4f20\u5165\u5934\u90e8\u952e\u540d\u65e0\u6548");
        if (ObjectUtils.isEmpty(value)) {
            this.headerMap.remove((Object)strHeader);
        } else {
            ArrayList<String> list = (ArrayList<String>)this.headerMap.get((Object)strHeader);
            if (list == null) {
                list = new ArrayList<String>();
                this.headerMap.put((Object)strHeader, list);
            }
            list.clear();
            for (String strValue : value) {
                if (list.contains(strValue)) continue;
                list.add(strValue);
            }
        }
    }

    @Override
    @JsonIgnore
    public void resetHeader(String strHeader) {
        Assert.hasLength((String)strHeader, (String)"\u4f20\u5165\u5934\u90e8\u952e\u540d\u65e0\u6548");
        this.headerMap.remove((Object)strHeader);
    }

    @Override
    @JsonIgnore
    public void resetHeader(String strHeader, String strValue) {
        Assert.hasLength((String)strHeader, (String)"\u4f20\u5165\u5934\u90e8\u952e\u540d\u65e0\u6548");
        Assert.hasLength((String)strValue, (String)"\u4f20\u5165\u5934\u90e8\u503c\u65e0\u6548");
        List list = (List)this.headerMap.get((Object)strHeader);
        if (list == null) {
            return;
        }
        list.remove(strValue);
    }

    @Override
    @JsonProperty(value="body")
    public Object getBody() {
        return this.body;
    }

    @Override
    @JsonProperty(value="body")
    public void setBody(Object body) {
        this.body = body;
    }

    @Override
    @JsonProperty(value="statusCode")
    public int getStatusCode() {
        return this.nStatusCode;
    }

    @Override
    @JsonProperty(value="statusCode")
    public void setStatusCode(int nStatusCode) {
        this.nStatusCode = nStatusCode;
    }

    @Override
    @JsonProperty(value="contentType")
    public String getContentType() {
        return this.strContentType;
    }

    @Override
    @JsonProperty(value="contentType")
    public void setContentType(String strContentType) {
        this.strContentType = strContentType;
    }

    public String toString() {
        return JsonUtils.toString(this);
    }
}

