/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.util;

import com.fasterxml.jackson.core.type.TypeReference;
import net.ibizsys.central.sysutil.ISysCacheUtilRuntime;
import net.ibizsys.central.util.ICacheableAction;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.IAction;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class CacheableActionBuilder {
    private ISysCacheUtilRuntime iSysCacheUtilRuntime = null;
    private int nSeconds = 0;
    private String strCat = null;
    private Object[] tags = null;
    private IAction realAction = null;
    private IUserContext iUserContext = null;

    public CacheableActionBuilder(ISysCacheUtilRuntime iSysCacheUtilRuntime, String strCat) {
        this.strCat = strCat;
        this.setSysCacheUtilRuntime(iSysCacheUtilRuntime);
        Assert.notNull((Object)this.getSysCacheUtilRuntime(), (String)"\u4f20\u5165\u7f13\u5b58\u7ec4\u4ef6\u5bf9\u8c61\u65e0\u6548");
    }

    public CacheableActionBuilder(ISysCacheUtilRuntime iSysCacheUtilRuntime) {
        this.setSysCacheUtilRuntime(iSysCacheUtilRuntime);
        Assert.notNull((Object)this.getSysCacheUtilRuntime(), (String)"\u4f20\u5165\u7f13\u5b58\u7ec4\u4ef6\u5bf9\u8c61\u65e0\u6548");
    }

    protected IAction getRealAction() {
        return this.realAction;
    }

    protected void setRealAction(IAction realAction) {
        this.realAction = realAction;
    }

    public String getCat() {
        return this.strCat;
    }

    protected void setCat(String strCat) {
        this.strCat = strCat;
    }

    public ISysCacheUtilRuntime getSysCacheUtilRuntime() {
        return this.iSysCacheUtilRuntime;
    }

    protected void setSysCacheUtilRuntime(ISysCacheUtilRuntime iSysCacheUtilRuntime) {
        this.iSysCacheUtilRuntime = iSysCacheUtilRuntime;
    }

    public CacheableActionBuilder expire(int nSeconds) {
        this.nSeconds = nSeconds;
        return this;
    }

    public int getExpiredSeconds() {
        return this.nSeconds;
    }

    protected void setExpiredSeconds(int nSeconds) {
        this.nSeconds = nSeconds;
    }

    public CacheableActionBuilder usercontext(IUserContext iUserContext) {
        this.setUserContext(iUserContext);
        return this;
    }

    public IUserContext getUserContext() {
        return this.iUserContext;
    }

    protected IUserContext getRealUserContext() {
        if (this.iUserContext != null) {
            return this.iUserContext;
        }
        return UserContext.getCurrent();
    }

    protected void setUserContext(IUserContext iUserContext) {
        this.iUserContext = iUserContext;
    }

    public CacheableActionBuilder tags(Object ... tags) {
        this.setTags(tags);
        return this;
    }

    public Object[] getTags() {
        return this.tags;
    }

    protected void setTags(Object[] tags) {
        this.tags = tags;
    }

    public CacheableActionBuilder action(IAction iAction) {
        this.setRealAction(iAction);
        return this;
    }

    public ICacheableAction build() throws Throwable {
        if (this.getRealAction() == null) {
            throw new Exception("\u672a\u6307\u5b9a\u5b9e\u9645\u884c\u4e3a");
        }
        if (this.getSysCacheUtilRuntime() == null) {
            throw new Exception("\u7f13\u5b58\u7ec4\u4ef6\u65e0\u6548");
        }
        return new ICacheableAction(){

            @Override
            public <T> T get(Class<T> cls) throws Throwable {
                return this.get((Object[])null, cls);
            }

            @Override
            public <T> T get(TypeReference<T> type) throws Throwable {
                return this.get((Object[])null, type);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> T get(Object[] args, Class<T> cls) throws Throwable {
                IUserContext lastUserContext = UserContext.getCurrent();
                try {
                    UserContext.setCurrent(CacheableActionBuilder.this.getRealUserContext());
                    String strTag = CacheableActionBuilder.this.getActionCacheTag();
                    Object objRet = CacheableActionBuilder.this.getSysCacheUtilRuntime().get(CacheableActionBuilder.this.getCat(), strTag, cls);
                    if (objRet != null) {
                        T t = objRet;
                        return t;
                    }
                    objRet = CacheableActionBuilder.this.getRealAction().execute(args);
                    CacheableActionBuilder.this.getSysCacheUtilRuntime().set(CacheableActionBuilder.this.getCat(), strTag, objRet, CacheableActionBuilder.this.getExpiredSeconds());
                    Object object = objRet;
                    return object;
                }
                finally {
                    UserContext.setCurrent(lastUserContext);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> T get(Object[] args, TypeReference<T> type) throws Throwable {
                IUserContext lastUserContext = UserContext.getCurrent();
                try {
                    UserContext.setCurrent(CacheableActionBuilder.this.getRealUserContext());
                    String strTag = CacheableActionBuilder.this.getActionCacheTag();
                    Object objRet = CacheableActionBuilder.this.getSysCacheUtilRuntime().get(CacheableActionBuilder.this.getCat(), strTag, type);
                    if (objRet != null) {
                        T t = objRet;
                        return t;
                    }
                    objRet = CacheableActionBuilder.this.getRealAction().execute(args);
                    CacheableActionBuilder.this.getSysCacheUtilRuntime().set(CacheableActionBuilder.this.getCat(), strTag, objRet, CacheableActionBuilder.this.getExpiredSeconds());
                    Object object = objRet;
                    return object;
                }
                finally {
                    UserContext.setCurrent(lastUserContext);
                }
            }

            @Override
            public <T> T save(Class<T> cls) throws Throwable {
                return this.save((Object[])null, cls);
            }

            @Override
            public <T> T save(TypeReference<T> type) throws Throwable {
                return this.save((Object[])null, type);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> T save(Object[] args, Class<T> cls) throws Throwable {
                IUserContext lastUserContext = UserContext.getCurrent();
                try {
                    UserContext.setCurrent(CacheableActionBuilder.this.getRealUserContext());
                    String strTag = CacheableActionBuilder.this.getActionCacheTag();
                    Object objRet = CacheableActionBuilder.this.getRealAction().execute(args);
                    CacheableActionBuilder.this.getSysCacheUtilRuntime().set(CacheableActionBuilder.this.getCat(), strTag, objRet, CacheableActionBuilder.this.getExpiredSeconds());
                    Object object = objRet;
                    return (T)object;
                }
                finally {
                    UserContext.setCurrent(lastUserContext);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> T save(Object[] args, TypeReference<T> type) throws Throwable {
                IUserContext lastUserContext = UserContext.getCurrent();
                try {
                    UserContext.setCurrent(CacheableActionBuilder.this.getRealUserContext());
                    String strTag = CacheableActionBuilder.this.getActionCacheTag();
                    Object objRet = CacheableActionBuilder.this.getRealAction().execute(args);
                    CacheableActionBuilder.this.getSysCacheUtilRuntime().set(CacheableActionBuilder.this.getCat(), strTag, objRet, CacheableActionBuilder.this.getExpiredSeconds());
                    Object object = objRet;
                    return (T)object;
                }
                finally {
                    UserContext.setCurrent(lastUserContext);
                }
            }

            @Override
            public void remove() throws Throwable {
                this.remove(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove(Object[] args) throws Throwable {
                IUserContext lastUserContext = UserContext.getCurrent();
                try {
                    UserContext.setCurrent(CacheableActionBuilder.this.getRealUserContext());
                    CacheableActionBuilder.this.getRealAction().execute(args);
                    String strTag = CacheableActionBuilder.this.getActionCacheTag();
                    if (StringUtils.hasLength((String)strTag)) {
                        CacheableActionBuilder.this.getSysCacheUtilRuntime().reset(CacheableActionBuilder.this.getCat(), strTag);
                    } else {
                        CacheableActionBuilder.this.getSysCacheUtilRuntime().reset(CacheableActionBuilder.this.getCat());
                    }
                }
                finally {
                    UserContext.setCurrent(lastUserContext);
                }
            }
        };
    }

    protected String getActionCacheTag() {
        Object[] catchTags = this.getTags();
        if (ObjectUtils.isEmpty((Object[])catchTags)) {
            return null;
        }
        Assert.isTrue((catchTags.length <= 6 ? 1 : 0) != 0, (String)"\u7f13\u5b58\u6807\u8bb0\u6570\u7ec4\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7[6]");
        switch (catchTags.length) {
            case 1: {
                return String.format("%1$s", catchTags[0]);
            }
            case 2: {
                return String.format("%1$s-%2$s", catchTags[0], catchTags[1]);
            }
            case 3: {
                return String.format("%1$s-%2$s-%3$s", catchTags[0], catchTags[1], catchTags[2]);
            }
            case 4: {
                return String.format("%1$s-%2$s-%3$s-%4$s", catchTags[0], catchTags[1], catchTags[2], catchTags[3]);
            }
            case 5: {
                return String.format("%1$s-%2$s-%3$s-%4$s-%5$s", catchTags[0], catchTags[1], catchTags[2], catchTags[3], catchTags[4]);
            }
        }
        return String.format("%1$s-%2$s-%3$s-%4$s-%5$s-%6$s", catchTags[0], catchTags[1], catchTags[2], catchTags[3], catchTags[4], catchTags[5]);
    }
}

