/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.util;

import com.fasterxml.jackson.core.type.TypeReference;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.IAction;

public class ActionUtils {
    public static Object executeAction(ISystemRuntime iSystemRuntime, IModelRuntime iModelRuntime, String strActionName, IAction iAction, Object[] args) {
        return ActionUtils.executeAction(iSystemRuntime, iModelRuntime, strActionName, iAction, args, Object.class, ActionSessionManager.getLogPOTime());
    }

    public static <T> T executeAction(ISystemRuntime iSystemRuntime, IModelRuntime iModelRuntime, String strActionName, IAction iAction, Object[] args, Class<T> cls) {
        return ActionUtils.executeAction(iSystemRuntime, iModelRuntime, strActionName, iAction, args, cls, ActionSessionManager.getLogPOTime());
    }

    public static <T> T executeAction(ISystemRuntime iSystemRuntime, IModelRuntime iModelRuntime, String strActionName, IAction iAction, Object[] args, TypeReference<T> type) {
        return ActionUtils.executeAction(iSystemRuntime, iModelRuntime, strActionName, iAction, args, type, ActionSessionManager.getLogPOTime());
    }

    public static <T> T executeAction(ISystemRuntime iSystemRuntime, IModelRuntime iModelRuntime, String strActionName, IAction iAction, Object[] args, Class<T> cls, int nPOTime) {
        try {
            long nBeginTime = System.currentTimeMillis();
            Object objRet = iAction.execute(args);
            long bEndTime = System.currentTimeMillis();
            if (bEndTime - nBeginTime > (long)nPOTime) {
                iSystemRuntime.logPO(30000, iModelRuntime.getClass().getName(), String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime), iModelRuntime.getLogicName(), strActionName, bEndTime - nBeginTime, null);
            }
            return (T)objRet;
        }
        catch (Throwable ex) {
            throw ActionUtils.dealException(iSystemRuntime, iModelRuntime, String.format("%1$s\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strActionName, ex.getMessage()), ex);
        }
    }

    public static <T> T executeAction(ISystemRuntime iSystemRuntime, IModelRuntime iModelRuntime, String strActionName, IAction iAction, Object[] args, TypeReference<T> type, int nPOTime) {
        try {
            long nBeginTime = System.currentTimeMillis();
            Object objRet = iAction.execute(args);
            long bEndTime = System.currentTimeMillis();
            if (bEndTime - nBeginTime > (long)nPOTime) {
                iSystemRuntime.logPO(30000, iModelRuntime.getClass().getName(), String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime), iModelRuntime.getLogicName(), strActionName, bEndTime - nBeginTime, null);
            }
            return (T)objRet;
        }
        catch (Throwable ex) {
            throw ActionUtils.dealException(iSystemRuntime, iModelRuntime, String.format("%1$s\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strActionName, ex.getMessage()), ex);
        }
    }

    public static RuntimeException dealException(ISystemRuntime iSystemRuntime, IModelRuntime iModelRuntime, String strMessage, Throwable ex) {
        iSystemRuntime.log(40000, iModelRuntime.getClass().getName(), String.format("%1$s%2$s", iModelRuntime.getLogicName(), strMessage), null);
        return new SystemRuntimeException((ISystemRuntimeBase)iSystemRuntime, iModelRuntime, strMessage, ex);
    }
}

