/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.security.DataEntityAccessManager;
import net.ibizsys.central.dataentity.security.IDataEntityAccessManager;
import net.ibizsys.central.security.ISysUniResRuntime;
import net.ibizsys.central.security.ISysUserRoleRuntime;
import net.ibizsys.central.security.ISystemAccessManager;
import net.ibizsys.central.security.SysUniResRuntime;
import net.ibizsys.central.security.SysUserRoleRuntime;
import net.ibizsys.central.sysutil.ISysCacheUtilRuntime;
import net.ibizsys.model.dataentity.priv.IPSSysDEOPPriv;
import net.ibizsys.model.security.IPSSysUniRes;
import net.ibizsys.model.security.IPSSysUserRole;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class SystemAccessManager
implements ISystemAccessManager {
    private static final Log log = LogFactory.getLog(SystemAccessManager.class);
    private ISystemRuntimeContext iSystemRuntimeContext = null;
    private Map<String, IPSSysDEOPPriv> psSysDEOPPrivMap = new HashMap<String, IPSSysDEOPPriv>();
    private List<ISysUserRoleRuntime> defaultSysUserRoleRuntimeList = new ArrayList<ISysUserRoleRuntime>();
    private List<ISysUserRoleRuntime> adminSysUserRoleRuntimeList = new ArrayList<ISysUserRoleRuntime>();
    private List<ISysUserRoleRuntime> testSysUserRoleRuntimeList = new ArrayList<ISysUserRoleRuntime>();
    private Map<String, ISysUserRoleRuntime> sysUserRoleRuntimeMap = new HashMap<String, ISysUserRoleRuntime>();
    private Map<String, ISysUniResRuntime> sysUniResRuntimeMap = new ConcurrentHashMap<String, ISysUniResRuntime>();
    private ISysCacheUtilRuntime iSysCacheUtilRuntime = null;

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext) throws Exception {
        this.iSystemRuntimeContext = iSystemRuntimeContext;
        this.onInit();
    }

    protected void onInit() throws Exception {
        this.reloadAll();
    }

    protected ISysCacheUtilRuntime getSysCacheUtilRuntime() {
        return this.getSysCacheUtilRuntime(false);
    }

    protected ISysCacheUtilRuntime getSysCacheUtilRuntime(boolean bTryMode) {
        if (this.iSysCacheUtilRuntime != null || bTryMode) {
            return this.iSysCacheUtilRuntime;
        }
        throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u7cfb\u7edf\u7f13\u5b58\u529f\u80fd\u7ec4\u4ef6");
    }

    protected void setSysCacheUtilRuntime(ISysCacheUtilRuntime iSysCacheUtilRuntime) {
        this.iSysCacheUtilRuntime = iSysCacheUtilRuntime;
    }

    protected void prepareSysCacheUtilRuntime() throws Exception {
        this.setSysCacheUtilRuntime(this.getSystemRuntime().getSysCacheUtilRuntime(true));
    }

    public void reloadAll() throws Exception {
        this.reloadSysDEOPPrivs();
        this.reloadSysUniResRuntimes();
        this.reloadSysUserRoleRuntimes();
    }

    public void reloadSysDEOPPrivs() throws Exception {
        this.psSysDEOPPrivMap.clear();
        this.onReloadSysDEOPPrivs();
    }

    protected void onReloadSysDEOPPrivs() throws Exception {
        HashMap<String, IPSSysDEOPPriv> psSysDEOPPrivMap = new HashMap<String, IPSSysDEOPPriv>();
        List psSysDEOPPrivList = this.getSystemRuntime().getPSSystem().getAllPSDEOPPrivs();
        if (psSysDEOPPrivList != null) {
            for (IPSSysDEOPPriv iPSSysDEOPPriv : psSysDEOPPrivList) {
                if (StringUtils.hasLength((String)iPSSysDEOPPriv.getMapPSDEName())) {
                    String strKey = String.format("%1$s|%2$s", iPSSysDEOPPriv.getMapPSDEName(), iPSSysDEOPPriv.getName());
                    psSysDEOPPrivMap.put(strKey, iPSSysDEOPPriv);
                    continue;
                }
                psSysDEOPPrivMap.put(iPSSysDEOPPriv.getName(), iPSSysDEOPPriv);
            }
        }
        this.psSysDEOPPrivMap.putAll(psSysDEOPPrivMap);
    }

    public void reloadSysUserRoleRuntimes() throws Exception {
        this.defaultSysUserRoleRuntimeList.clear();
        this.adminSysUserRoleRuntimeList.clear();
        this.testSysUserRoleRuntimeList.clear();
        this.sysUserRoleRuntimeMap.clear();
        this.onReloadSysUserRoleRuntimes();
    }

    protected void onReloadSysUserRoleRuntimes() throws Exception {
        List psSysUserRoles = this.getSystemRuntimeContext().getSystemRuntime().getPSSystem().getAllPSSysUserRoles();
        if (psSysUserRoles != null) {
            for (IPSSysUserRole iPSSysUserRole : psSysUserRoles) {
                ISysUserRoleRuntime iSysUserRoleRuntime = this.createSysUserRoleRuntime(iPSSysUserRole);
                iSysUserRoleRuntime.init(this.iSystemRuntimeContext, this, iPSSysUserRole);
                this.registerSysUserRoleRuntime(iSysUserRoleRuntime);
            }
        }
    }

    public void reloadSysUniResRuntimes() throws Exception {
        this.sysUniResRuntimeMap.clear();
        this.onReloadSysUniResRuntimes();
    }

    protected void onReloadSysUniResRuntimes() throws Exception {
        List psSysUniRess = this.getSystemRuntimeContext().getSystemRuntime().getPSSystem().getAllPSSysUniReses();
        if (psSysUniRess != null) {
            for (IPSSysUniRes iPSSysUniRes : psSysUniRess) {
                ISysUniResRuntime iSysUniResRuntime = this.createSysUniResRuntime(iPSSysUniRes);
                iSysUniResRuntime.init(this.iSystemRuntimeContext, this, iPSSysUniRes);
                this.registerSysUniResRuntime(iSysUniResRuntime);
            }
        }
    }

    protected void registerSysUserRoleRuntime(ISysUserRoleRuntime iSysUserRoleRuntime) {
        if (StringUtils.hasLength((String)iSysUserRoleRuntime.getRoleTag())) {
            this.sysUserRoleRuntimeMap.put(iSysUserRoleRuntime.getRoleTag().toUpperCase(), iSysUserRoleRuntime);
        }
        if ("ACCESSUSER".equals(iSysUserRoleRuntime.getDefaultUser())) {
            this.defaultSysUserRoleRuntimeList.add(iSysUserRoleRuntime);
            return;
        }
        if ("USER".equals(iSysUserRoleRuntime.getDefaultUser())) {
            this.defaultSysUserRoleRuntimeList.add(iSysUserRoleRuntime);
            return;
        }
        if ("ACCESSDMIN".equals(iSysUserRoleRuntime.getDefaultUser())) {
            this.adminSysUserRoleRuntimeList.add(iSysUserRoleRuntime);
            return;
        }
        if ("ADMIN".equals(iSysUserRoleRuntime.getDefaultUser())) {
            this.adminSysUserRoleRuntimeList.add(iSysUserRoleRuntime);
            return;
        }
        if (iSysUserRoleRuntime.isEnableTestUser()) {
            this.testSysUserRoleRuntimeList.add(iSysUserRoleRuntime);
        }
    }

    protected void registerSysUniResRuntime(ISysUniResRuntime iSysUniResRuntime) {
        this.sysUniResRuntimeMap.put(iSysUniResRuntime.getResCode(), iSysUniResRuntime);
    }

    protected ISystemRuntimeContext getSystemRuntimeContext() {
        return this.iSystemRuntimeContext;
    }

    @Override
    public ISystemRuntime getSystemRuntime() {
        return this.getSystemRuntimeContext().getSystemRuntime();
    }

    @Override
    public IDataEntityAccessManager createDataEntityAccessManager(IDataEntityRuntime iDataEntityRuntime) {
        return new DataEntityAccessManager();
    }

    protected ISysUserRoleRuntime createSysUserRoleRuntime(IPSSysUserRole iPSSysUserRole) {
        return new SysUserRoleRuntime();
    }

    protected ISysUniResRuntime createSysUniResRuntime(IPSSysUniRes iPSSysUniRes) {
        return new SysUniResRuntime();
    }

    @Override
    public List<ISysUserRoleRuntime> getSysUserRoleRuntimes(IUserContext iUserContext) {
        return null;
    }

    @Override
    public boolean testSysUniRes(IUserContext iUserContext, String strSysUniRes) throws Exception {
        return this.testSysUniRes(iUserContext, strSysUniRes, null);
    }

    @Override
    public boolean testSysUniRes(IUserContext iUserContext, String strSysUniRes, IEntity iEntity) throws Exception {
        List<ISysUserRoleRuntime> sysUserRoleRuntimeList = this.getSysUserRoleRuntimes(iUserContext);
        if (sysUserRoleRuntimeList != null) {
            for (ISysUserRoleRuntime iSysUserRoleRuntime : sysUserRoleRuntimeList) {
                Boolean bRet = iSysUserRoleRuntime.testSysUniRes(iUserContext, strSysUniRes, iEntity);
                if (bRet == null || !bRet.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    protected IPSSysDEOPPriv getPSysDEOPPriv(String strAccessAction) {
        return this.psSysDEOPPrivMap.get(strAccessAction);
    }

    @Override
    public IPSSysDEOPPriv getPSSysDEOPPriv(String strAccessAction, boolean bTryMode) {
        IPSSysDEOPPriv iPSSysDEOPPriv = this.psSysDEOPPrivMap.get(strAccessAction);
        if (iPSSysDEOPPriv != null || bTryMode) {
            return iPSSysDEOPPriv;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u5b9e\u4f53\u64cd\u4f5c\u6807\u8bc6\u5bf9\u8c61[%1$s]", strAccessAction));
    }

    @Override
    public ISysUniResRuntime getSysUniResRuntime(String strUniResCode, boolean bTryMode) {
        ISysUniResRuntime iSysUniResRuntime = this.sysUniResRuntimeMap.get(strUniResCode);
        if (iSysUniResRuntime != null || bTryMode) {
            return iSysUniResRuntime;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u7edf\u4e00\u6807\u8bc6\u5bf9\u8c61[%1$s]", strUniResCode));
    }

    @Override
    public List<ISysUserRoleRuntime> getUserSysUserRoleRuntimes() {
        return this.defaultSysUserRoleRuntimeList;
    }

    @Override
    public List<ISysUserRoleRuntime> getAdminSysUserRoleRuntimes() {
        return this.adminSysUserRoleRuntimeList;
    }

    @Override
    public List<ISysUserRoleRuntime> getTestSysUserRoleRuntimes() {
        return this.testSysUserRoleRuntimeList;
    }

    @Override
    public ISysUserRoleRuntime getSysUserRoleRuntime(String strRoleTag, boolean bTryMode) {
        ISysUserRoleRuntime iSysUserRoleRuntime = this.sysUserRoleRuntimeMap.get(strRoleTag.toUpperCase());
        if (iSysUserRoleRuntime != null || bTryMode) {
            return iSysUserRoleRuntime;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u89d2\u8272\u5bf9\u8c61[%1$s]", strRoleTag));
    }
}

