/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.res;

import java.io.File;
import java.util.List;
import net.ibizsys.central.res.SysFileResourceRuntimeBase;
import net.ibizsys.model.res.IPSSysContent;
import net.ibizsys.model.res.IPSSysContentCat;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SysContentCatResourceRuntime
extends SysFileResourceRuntimeBase {
    private static final Log log = LogFactory.getLog(SysContentCatResourceRuntime.class);

    @Override
    protected void prepareDefaultFile() throws Exception {
        String strSysContentTag = this.getContent();
        if (!StringUtils.hasLength((String)strSysContentTag)) {
            throw new Exception("\u672a\u6307\u5b9a\u5185\u5bb9\u5206\u7c7b\u6807\u8bc6");
        }
        IPSSysContentCat iPSSysContentCat = this.getSystemRuntime().getPSSystemService().getPSSysContentCat(strSysContentTag, false);
        File tempFile = File.createTempFile("resource", ".cat");
        String folderPath = tempFile.getParentFile().getAbsolutePath() + File.separator + KeyValueUtils.genUniqueId();
        File folder = new File(folderPath);
        List psSysContents = iPSSysContentCat.getPSSysContents();
        if (!ObjectUtils.isEmpty((Object)psSysContents)) {
            for (IPSSysContent iPSSysContent : psSysContents) {
                String strContentPath = iPSSysContent.getContentPath();
                if (!StringUtils.hasLength((String)strContentPath)) {
                    log.warn((Object)String.format("\u7cfb\u7edf\u5185\u5bb9[%1$s]\u672a\u5b9a\u4e49\u5185\u5bb9\u8def\u5f84\uff0c\u5ffd\u7565\u5199\u5165\u6587\u4ef6", iPSSysContent.getName()));
                    continue;
                }
                if (strContentPath.indexOf("/") == 0 || strContentPath.indexOf("\\") == 0) {
                    strContentPath = strContentPath.substring(1);
                }
                String strFullPath = String.format("%1$s%2$s%3$s", folderPath, File.separator, strContentPath);
                File file = new File(strFullPath);
                file.getParentFile().mkdirs();
                FileUtils.writeStringToFile((File)file, (String)iPSSysContent.getContent(), (String)"UTF-8");
                if (file.exists()) continue;
                throw new Exception(String.format("\u65e0\u6cd5\u5199\u5165\u5185\u5bb9[%1$s]\u81f3[%2$s]", iPSSysContent.getName(), strFullPath));
            }
        }
        this.setDefaultFile(folder);
        this.setDefaultFileMode(true);
    }
}

