/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.util.DEUtilRuntimeBase;
import net.ibizsys.central.dataentity.util.IDEVersionControlUtilRuntime;
import net.ibizsys.central.dataentity.util.IDEVersionStorageUtilRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchGroupCond;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSPickupDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.der.IPSDERCustom;
import net.ibizsys.model.dataentity.ds.IPSDEDQCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQFieldCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQGroupCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IAppContext;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.ISearchContextBase;
import net.ibizsys.runtime.util.ISearchFieldCond;
import net.ibizsys.runtime.util.ISearchGroupCond;
import net.ibizsys.runtime.util.SearchFieldCond;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DEVersionStorageUtilRuntimeBase
extends DEUtilRuntimeBase
implements IDEVersionStorageUtilRuntime {
    private static final Log log = LogFactory.getLog(DEVersionStorageUtilRuntimeBase.class);
    private IDataEntityRuntime versionDataEntityRuntime = null;
    private IPSDEField versionParentTypePSDEField = null;
    private IPSDEField versionParentIdPSDEField = null;
    private IPSDEField versionParentVersionIdPSDEField = null;
    private IPSDEField versionFilterPSDEField = null;
    private IPSDEField versionOwnerTypePSDEField = null;
    private IPSDEField versionOwnerIdPSDEField = null;
    private IPSDEField versionDataPSDEField = null;

    @Override
    protected void onInit() throws Exception {
        if (this.getVersionDataEntityRuntime(true) == null) {
            this.prepareVersionDataEntityRuntime();
            this.getVersionDataEntityRuntime(false);
        }
        super.onInit();
    }

    protected void prepareVersionDataEntityRuntime() throws Exception {
        IPSDataEntity utilPSDataEntity = this.getPSDEUtil().getUtilPSDE();
        if (utilPSDataEntity == null) {
            throw new Exception(String.format("\u672a\u6307\u5b9a\u7248\u672c\u6570\u636e\u5b58\u50a8\u5b9e\u4f53", new Object[0]));
        }
        IDataEntityRuntime versionDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(utilPSDataEntity.getId());
        this.setVersionDataEntityRuntime(versionDataEntityRuntime);
        this.setVersionParentIdPSDEField(versionDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTID.value, false));
        this.setVersionParentVersionIdPSDEField(versionDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTVERSIONID.value, false));
        this.setVersionParentTypePSDEField(versionDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, true));
        this.setVersionDataPSDEField(versionDataEntityRuntime.getPSDEFieldByTag("DATA", false));
        this.setVersionFilterPSDEField(versionDataEntityRuntime.getPSDEFieldByTag("FILTER", false));
        this.setVersionOwnerTypePSDEField(versionDataEntityRuntime.getPSDEFieldByTag("OWNER_TYPE", true));
        this.setVersionOwnerIdPSDEField(versionDataEntityRuntime.getPSDEFieldByTag("OWNER_ID", true));
    }

    @Override
    public IDataEntityRuntime getVersionDataEntityRuntime() {
        try {
            return this.getVersionDataEntityRuntime(false);
        }
        catch (Exception ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, ex.getMessage(), (Throwable)ex);
        }
    }

    protected IPSDEField getVersionParentTypePSDEField() {
        return this.versionParentTypePSDEField;
    }

    protected void setVersionParentTypePSDEField(IPSDEField versionParentTypePSDEField) {
        this.versionParentTypePSDEField = versionParentTypePSDEField;
    }

    protected IPSDEField getVersionParentIdPSDEField() {
        return this.versionParentIdPSDEField;
    }

    protected void setVersionParentIdPSDEField(IPSDEField versionParentIdPSDEField) {
        this.versionParentIdPSDEField = versionParentIdPSDEField;
    }

    protected IPSDEField getVersionParentVersionIdPSDEField() {
        return this.versionParentVersionIdPSDEField;
    }

    protected void setVersionParentVersionIdPSDEField(IPSDEField versionParentVersionIdPSDEField) {
        this.versionParentVersionIdPSDEField = versionParentVersionIdPSDEField;
    }

    protected IPSDEField getVersionFilterPSDEField() {
        return this.versionFilterPSDEField;
    }

    protected void setVersionFilterPSDEField(IPSDEField versionFilterPSDEField) {
        this.versionFilterPSDEField = versionFilterPSDEField;
    }

    protected IPSDEField getVersionOwnerTypePSDEField() {
        return this.versionOwnerTypePSDEField;
    }

    protected void setVersionOwnerTypePSDEField(IPSDEField versionOwnerTypePSDEField) {
        this.versionOwnerTypePSDEField = versionOwnerTypePSDEField;
    }

    protected IPSDEField getVersionOwnerIdPSDEField() {
        return this.versionOwnerIdPSDEField;
    }

    protected void setVersionOwnerIdPSDEField(IPSDEField versionOwnerIdPSDEField) {
        this.versionOwnerIdPSDEField = versionOwnerIdPSDEField;
    }

    protected IPSDEField getVersionDataPSDEField() {
        return this.versionDataPSDEField;
    }

    protected void setVersionDataPSDEField(IPSDEField versionDataPSDEField) {
        this.versionDataPSDEField = versionDataPSDEField;
    }

    protected IDataEntityRuntime getVersionDataEntityRuntime(boolean tryMode) throws Exception {
        if (this.versionDataEntityRuntime != null || tryMode) {
            return this.versionDataEntityRuntime;
        }
        throw new Exception(String.format("\u7248\u672c\u6570\u636e\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected void setVersionDataEntityRuntime(IDataEntityRuntime versionDataEntityRuntime) {
        this.versionDataEntityRuntime = versionDataEntityRuntime;
    }

    @Override
    public boolean isEnableAction(String strActionName, IPSDEAction iPSDEAction, Object[] args) {
        if (args != null && args.length >= 3 && "SRFVERSIONID".equals(args[1])) {
            try {
                return !this.isCurrentVersionId(args[2]);
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u5224\u65ad\u4f20\u5165\u7248\u672c\u662f\u5426\u4e3a\u5f53\u524d\u7248\u672c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                return false;
            }
        }
        return false;
    }

    @Override
    public Object executeAction(String strActionName, IPSDEAction iPSDEAction, Object[] args, Object actionData) throws Throwable {
        Assert.notNull((Object)args, (String)"\u672a\u4f20\u5165\u8c03\u7528\u53c2\u6570");
        try {
            if (args != null && args.length >= 3 && "SRFVERSIONID".equals(args[1])) {
                return this.onExecuteAction(strActionName, iPSDEAction, args, actionData);
            }
            throw new Exception("\u8c03\u7528\u53c2\u6570\u683c\u5f0f\u65e0\u6548");
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u6267\u884c\u884c\u4e3a\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onExecuteAction(String strActionName, IPSDEAction iPSDEAction, Object[] args, Object actionData) throws Throwable {
        String strRealActionName;
        String string = strRealActionName = iPSDEAction != null ? iPSDEAction.getName() : strActionName;
        if ("get".equalsIgnoreCase(strRealActionName)) {
            return this.get(args[0], args[2]);
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u884c\u4e3a[%1$s]", strRealActionName));
    }

    @Override
    public IEntityBase get(Object key, Object objVersionId) throws Throwable {
        try {
            return this.onGet(key, objVersionId);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u83b7\u53d6\u7248\u672c\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected IEntityBase onGet(Object key, Object objVersionId) throws Throwable {
        IAppContext iAppContext = ActionSessionManager.getAppContextMust();
        IPSDERBase iPSDERBase = this.getVersionPSDERBase(iAppContext, false);
        Object parentId = ActionSessionManager.getAppContextMust().get(iPSDERBase.getMajorPSDataEntityMust().getName());
        ISearchContextDTO iSearchContextDTO = this.getVersionDataEntityRuntime().createSearchContext();
        iSearchContextDTO.count(false);
        iSearchContextDTO.eq(this.getVersionParentVersionIdPSDEField().getLowerCaseName(), objVersionId);
        iSearchContextDTO.eq(this.getVersionParentIdPSDEField().getLowerCaseName(), parentId);
        if (this.getVersionParentTypePSDEField() != null) {
            iSearchContextDTO.eq(this.getVersionParentTypePSDEField().getLowerCaseName(), iPSDERBase.getMajorPSDataEntityMust().getName());
        }
        if (this.getVersionOwnerTypePSDEField() != null) {
            iSearchContextDTO.eq(this.getVersionOwnerTypePSDEField().getLowerCaseName(), this.getDataEntityRuntime().getName());
        }
        if (this.getVersionOwnerIdPSDEField() != null) {
            iSearchContextDTO.eq(this.getVersionOwnerIdPSDEField().getLowerCaseName(), key);
            iSearchContextDTO.limit(1);
        } else {
            iSearchContextDTO.all();
        }
        Object ret = this.getVersionDataEntityRuntime().fetchDataSet(null, this.getVersionDataEntityRuntime().getDefaultPSDEDataSet(), new Object[]{iSearchContextDTO});
        if (!(ret instanceof Page)) {
            throw new Exception("\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e");
        }
        Page page = (Page)ret;
        if (!ObjectUtils.isEmpty((Object)page.getContent())) {
            for (Object item : page.getContent()) {
                IEntityDTO iEntityDTO = (IEntityDTO)this.getDataEntityRuntime().deserializeEntity(((IEntityDTO)item).get(this.getVersionDataPSDEField().getLowerCaseName()));
                if (!key.equals(iEntityDTO.get(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName()))) continue;
                return iEntityDTO;
            }
        }
        throw new Exception("\u6307\u5b9a\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @Override
    public boolean isEnableDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args) {
        if (args != null && args.length >= 3 && "SRFVERSIONID".equals(args[1])) {
            try {
                return !this.isCurrentVersionId(args[2]);
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u5224\u65ad\u4f20\u5165\u7248\u672c\u662f\u5426\u4e3a\u5f53\u524d\u7248\u672c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                return false;
            }
        }
        return false;
    }

    @Override
    public Page fetchDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args, Object actionData) throws Throwable {
        Assert.notNull((Object)args, (String)"\u672a\u4f20\u5165\u8c03\u7528\u53c2\u6570");
        try {
            if (args != null && args.length >= 3 && "SRFVERSIONID".equals(args[1])) {
                return this.onFetchDataSet(strDataSetName, iPSDEDataSet, args, actionData);
            }
            throw new Exception("\u8c03\u7528\u53c2\u6570\u683c\u5f0f\u65e0\u6548");
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u83b7\u53d6\u6570\u636e\u96c6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Page onFetchDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args, Object actionData) throws Throwable {
        Object ret;
        ISearchContextDTO realSearchContextDTO = (ISearchContextDTO)args[0];
        Object versionId = args[2];
        IAppContext iAppContext = ActionSessionManager.getAppContextMust();
        IPSDERBase iPSDERBase = this.getVersionPSDERBase(iAppContext, false);
        Object parentId = ActionSessionManager.getAppContextMust().get(iPSDERBase.getMajorPSDataEntityMust().getName());
        ISearchContextDTO iSearchContextDTO = this.getVersionDataEntityRuntime().createSearchContext();
        if (realSearchContextDTO.getPageable() != null) {
            iSearchContextDTO.setPageable(realSearchContextDTO.getPageable().getPageNumber(), realSearchContextDTO.getPageable().getPageSize(), 0L);
        }
        iSearchContextDTO.eq(this.getVersionParentVersionIdPSDEField().getLowerCaseName(), versionId);
        iSearchContextDTO.eq(this.getVersionParentIdPSDEField().getLowerCaseName(), parentId);
        if (this.getVersionParentTypePSDEField() != null) {
            iSearchContextDTO.eq(this.getVersionParentTypePSDEField().getLowerCaseName(), iPSDERBase.getMajorPSDataEntityMust().getName());
        }
        if (this.getVersionOwnerTypePSDEField() != null) {
            iSearchContextDTO.eq(this.getVersionOwnerTypePSDEField().getLowerCaseName(), this.getDataEntityRuntime().getName());
        }
        if (!((ret = this.getVersionDataEntityRuntime().fetchDataSet(null, this.getVersionDataEntityRuntime().getDefaultPSDEDataSet(), new Object[]{iSearchContextDTO})) instanceof Page)) {
            throw new Exception("\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e");
        }
        Page page = (Page)ret;
        ArrayList<IEntityDTO> entityDTOList = new ArrayList<IEntityDTO>();
        if (!ObjectUtils.isEmpty((Object)page.getContent())) {
            for (Object item : page.getContent()) {
                IEntityDTO iEntityDTO = (IEntityDTO)this.getDataEntityRuntime().deserializeEntity(((IEntityDTO)item).get(this.getVersionDataPSDEField().getLowerCaseName()));
                entityDTOList.add(iEntityDTO);
            }
        }
        List<IEntityDTO> entityDTOList2 = this.filterEntityDTOList(entityDTOList, iPSDEDataSet, realSearchContextDTO);
        return new PageImpl(entityDTOList2, realSearchContextDTO.getPageable(), (long)entityDTOList2.size());
    }

    protected List<IEntityDTO> filterEntityDTOList(List<IEntityDTO> list, IPSDEDataSet iPSDEDataSet, ISearchContextDTO iSearchContextDTO) throws Throwable {
        if (ObjectUtils.isEmpty(list)) {
            return list;
        }
        ArrayList<IEntityDTO> all = new ArrayList<IEntityDTO>();
        all.addAll(list);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        if (iSearchContextDTO.any() != null) {
            params.putAll(iSearchContextDTO.any());
        }
        LinkedHashMap<Object, IEntityDTO> map = new LinkedHashMap<Object, IEntityDTO>();
        List psDEDataQueryList = iPSDEDataSet.getPSDEDataQueries();
        if (!ObjectUtils.isEmpty((Object)psDEDataQueryList)) {
            for (IPSDEDataQuery iPSDEDataQuery : psDEDataQueryList) {
                if (iPSDEDataQuery.getPSDEDQMain() == null || iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition() == null) {
                    for (IEntityDTO iEntityDTO : all) {
                        Object key = this.getDataEntityRuntime().getKeyFieldValue(iEntityDTO);
                        if (map.containsKey(key)) continue;
                        map.put(key, iEntityDTO);
                    }
                    continue;
                }
                IPSDEDQGroupCondition iPSDEDQGroupCondition = iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition();
                for (IEntityDTO iEntityDTO : all) {
                    Object key;
                    if (!this.filterEntityDTO(iEntityDTO, (IPSDEDQCondition)iPSDEDQGroupCondition, params) || map.containsKey(key = this.getDataEntityRuntime().getKeyFieldValue(iEntityDTO))) continue;
                    map.put(key, iEntityDTO);
                }
            }
        }
        all.clear();
        all.addAll(map.values());
        map.clear();
        for (IEntityDTO iEntityDTO : all) {
            Object key;
            if (!this.filterEntityDTO(iEntityDTO, iSearchContextDTO, params) || map.containsKey(key = this.getDataEntityRuntime().getKeyFieldValue(iEntityDTO))) continue;
            map.put(key, iEntityDTO);
        }
        all.clear();
        all.addAll(map.values());
        map.clear();
        return all;
    }

    protected boolean filterEntityDTO(IEntityDTO iEntityDTO, IPSDEDQCondition iPSDEDQCondition, Map<String, Object> params) throws Throwable {
        ISearchCond iSearchCond = this.getSearchCond(iPSDEDQCondition, params);
        if (iSearchCond != null) {
            return this.filterEntityDTO(iEntityDTO, iSearchCond, params);
        }
        return true;
    }

    protected boolean filterEntityDTO(IEntityDTO iEntityDTO, ISearchCond iSearchCond, Map<String, Object> params) throws Throwable {
        if (iSearchCond instanceof ISearchGroupCond) {
            ISearchGroupCond iSearchGroupCond = (ISearchGroupCond)iSearchCond;
            boolean bRet = true;
            if (iSearchGroupCond.getCondOp().equals("AND")) {
                if (!ObjectUtils.isEmpty(iSearchGroupCond.getSearchConds())) {
                    bRet = true;
                    for (ISearchCond childSearchCond : iSearchGroupCond.getSearchConds()) {
                        if (this.filterEntityDTO(iEntityDTO, childSearchCond, params)) continue;
                        bRet = false;
                        break;
                    }
                }
            } else if (iSearchGroupCond.getCondOp().equals("OR") && !ObjectUtils.isEmpty(iSearchGroupCond.getSearchConds())) {
                bRet = false;
                for (ISearchCond childSearchCond : iSearchGroupCond.getSearchConds()) {
                    if (!this.filterEntityDTO(iEntityDTO, childSearchCond, params)) continue;
                    bRet = true;
                    break;
                }
            }
            if (iSearchGroupCond.isNotMode()) {
                bRet = !bRet;
            }
            return bRet;
        }
        if (iSearchCond instanceof ISearchFieldCond) {
            ISearchFieldCond iSearchFieldCond = (ISearchFieldCond)iSearchCond;
            if (ObjectUtils.isEmpty((Object)iSearchFieldCond.getValueFunc())) {
                Object value = iEntityDTO.get(iSearchFieldCond.getFieldName());
                Object dstValue = iSearchFieldCond.isParamMode() ? params.get(iSearchFieldCond.getValue()) : iSearchFieldCond.getValue();
                IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(iSearchFieldCond.getFieldName(), true);
                if (iPSDEField != null) {
                    return DataTypeUtils.testCond(value, iSearchFieldCond.getCondOp(), dstValue, iPSDEField.getStdDataType());
                }
                return DataTypeUtils.testCond(value, iSearchFieldCond.getCondOp(), dstValue, 0);
            }
            log.warn((Object)String.format("\u672a\u652f\u6301\u7684\u503c\u5904\u7406\u51fd\u6570[%1$s]", iSearchFieldCond.getValueFunc()));
            return true;
        }
        log.warn((Object)String.format("\u672a\u652f\u6301\u7684\u6761\u4ef6\u7c7b\u578b[%1$s]", iSearchCond.getCondType()));
        return true;
    }

    protected IPSDERBase getVersionPSDERBase(IAppContext iAppContext, boolean bTryMode) throws Exception {
        List psDERBaseList = this.getDataEntityRuntime().getPSDataEntity().getMinorPSDERs();
        if (!ObjectUtils.isEmpty((Object)psDERBaseList) && iAppContext != null) {
            for (IPSDERBase iPSDERBase : psDERBaseList) {
                Object value;
                IDataEntityRuntime majorDataEntityRuntime;
                if (iPSDERBase instanceof IPSDER1N) {
                    IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
                    majorDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDER1N.getMajorPSDataEntityMust().getId(), false);
                    if (!majorDataEntityRuntime.isEnableVersionControl() || ObjectUtils.isEmpty((Object)(value = iAppContext.get(majorDataEntityRuntime.getName())))) continue;
                    return iPSDER1N;
                }
                if (!(iPSDERBase instanceof IPSDERCustom)) continue;
                IPSDERCustom iPSDERCustom = (IPSDERCustom)iPSDERBase;
                majorDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDERCustom.getMajorPSDataEntityMust().getId(), false);
                if (!majorDataEntityRuntime.isEnableVersionControl() || ObjectUtils.isEmpty((Object)(value = iAppContext.get(majorDataEntityRuntime.getName())))) continue;
                return iPSDERCustom;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u4f20\u5165\u6570\u636e\u7248\u672c\u63a7\u5236\u5173\u7cfb");
    }

    @Override
    public void commit(IEntityBase parentData, IPSDERBase iPSDERBase, Object versionId) {
        Assert.notNull((Object)parentData, (String)"\u4f20\u5165\u7236\u6570\u636e\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSDERBase, (String)"\u4f20\u5165\u7236\u6570\u636e\u5173\u7cfb\u6a21\u578b\u65e0\u6548");
        Assert.notNull((Object)versionId, (String)"\u4f20\u5165\u7236\u6570\u636e\u7248\u672c\u65e0\u6548");
        try {
            this.onCommit(parentData, iPSDERBase, versionId);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u63d0\u4ea4\u7236\u6570\u636e\u76f8\u5173\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void onCommit(IEntityBase parentData, IPSDERBase iPSDERBase, Object versionId) throws Throwable {
        IPSDEField orderValuePSDEField;
        IPSDERCustom iPSDERCustom;
        IPSPickupDEField pickupPSDEField = null;
        IPSDEField parentTypePSDEField = null;
        IPSDEField parentSubTypePSDEField = null;
        String strParentType = null;
        String strParentSubType = null;
        IPSDEDataSet nestedPSDEDataSet = null;
        if (iPSDERBase instanceof IPSDER1N) {
            IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
            if ((iPSDER1N.getMasterRS() & PSModelEnums.DER1NMasterRS.VERSION.value) == PSModelEnums.DER1NMasterRS.VERSION.value) {
                pickupPSDEField = ((IPSDER1N)iPSDERBase).getPSPickupDEFieldMust();
                nestedPSDEDataSet = ((IPSDER1N)iPSDERBase).getNestedPSDEDataSet();
            }
        } else if (iPSDERBase instanceof IPSDERCustom && ((iPSDERCustom = (IPSDERCustom)iPSDERBase).getMasterRS() & PSModelEnums.DER1NMasterRS.VERSION.value) == PSModelEnums.DER1NMasterRS.VERSION.value && (this.getDataEntityRuntime().getDEType() == 4 || PSModelEnums.DERSubType.DER1N.value.equalsIgnoreCase(iPSDERCustom.getDERSubType()))) {
            pickupPSDEField = iPSDERCustom.getPickupPSDEField();
            nestedPSDEDataSet = iPSDERCustom.getNestedPSDEDataSet();
            parentTypePSDEField = this.getDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE, this.getDataEntityRuntime().getDEType() != 4);
            if (parentTypePSDEField != null && !StringUtils.hasLength((String)(strParentType = iPSDERCustom.getParentType()))) {
                strParentType = iPSDERBase.getMajorPSDataEntityMust().getName();
            }
            if ((parentSubTypePSDEField = this.getDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTSUBTYPE, true)) != null && !StringUtils.hasLength((String)(strParentSubType = iPSDERCustom.getParentSubType()))) {
                strParentSubType = iPSDERBase.getMinorCodeName();
            }
        }
        if (pickupPSDEField == null) {
            throw new Exception(String.format("\u4f20\u5165\u5173\u7cfb\u65e0\u6548\uff0c\u672a\u63d0\u4f9b\u8fde\u63a5\u5c5e\u6027", new Object[0]));
        }
        Object key = this.getSystemRuntime().getDataEntityRuntime(iPSDERBase.getMajorPSDataEntityMust().getId()).getKeyFieldValue(parentData);
        ISearchContextDTO iSearchContextDTO = this.getDataEntityRuntime().createSearchContext();
        iSearchContextDTO.all().count(false);
        this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, (IPSDEField)pickupPSDEField, "EQ", key);
        if (parentTypePSDEField != null) {
            this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentTypePSDEField, "EQ", strParentType);
        }
        if (parentSubTypePSDEField != null) {
            if (StringUtils.hasLength(strParentSubType)) {
                this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentSubTypePSDEField, "EQ", DataTypeUtils.convert(parentSubTypePSDEField.getStdDataType(), strParentSubType));
            } else {
                this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentSubTypePSDEField, "ISNULL", null);
            }
        }
        if ((orderValuePSDEField = this.getDataEntityRuntime().getOrderValuePSDEField()) != null) {
            this.getDataEntityRuntime().setSearchSort(iSearchContextDTO, orderValuePSDEField, PSModelEnums.SortDir.ASC.value);
        }
        List<IEntityDTO> lastList = null;
        lastList = nestedPSDEDataSet != null ? this.getDataEntityRuntime().selectDataSet(nestedPSDEDataSet, iSearchContextDTO) : this.getDataEntityRuntime().select(iSearchContextDTO);
        if (!ObjectUtils.isEmpty(lastList)) {
            ArrayList<IEntityDTO> insertList = new ArrayList<IEntityDTO>();
            for (IEntityDTO item : lastList) {
                IEntityDTO temp = this.getVersionDataEntityRuntime().createEntity();
                temp.set(this.getVersionParentIdPSDEField().getLowerCaseName(), key);
                temp.set(this.getVersionParentVersionIdPSDEField().getLowerCaseName(), versionId);
                if (this.getVersionParentTypePSDEField() != null) {
                    temp.set(this.getVersionParentTypePSDEField().getLowerCaseName(), iPSDERBase.getMajorPSDataEntityMust().getName());
                }
                temp.set(this.getVersionFilterPSDEField().getLowerCaseName(), pickupPSDEField.getName());
                temp.set(this.getVersionDataPSDEField().getLowerCaseName(), this.getDataEntityRuntime().serializeEntity(item));
                if (this.getVersionOwnerTypePSDEField() != null) {
                    temp.set(this.getVersionOwnerTypePSDEField().getLowerCaseName(), this.getDataEntityRuntime().getName());
                }
                if (this.getVersionOwnerIdPSDEField() != null) {
                    temp.set(this.getVersionOwnerIdPSDEField().getLowerCaseName(), item.get(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName()));
                }
                this.getVersionDataEntityRuntime().fillEntityKeyValue(temp);
                insertList.add(temp);
            }
            this.getVersionDataEntityRuntime().rawCreate(insertList, false);
        }
    }

    @Override
    public void restore(IEntityBase parentData, IPSDERBase iPSDERBase, Object versionId) {
        Assert.notNull((Object)parentData, (String)"\u4f20\u5165\u7236\u6570\u636e\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSDERBase, (String)"\u4f20\u5165\u7236\u6570\u636e\u5173\u7cfb\u6a21\u578b\u65e0\u6548");
        Assert.notNull((Object)versionId, (String)"\u4f20\u5165\u7236\u6570\u636e\u7248\u672c\u65e0\u6548");
        try {
            this.onRestore(parentData, iPSDERBase, versionId);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u6062\u590d\u7236\u6570\u636e\u76f8\u5173\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void onRestore(IEntityBase parentData, IPSDERBase iPSDERBase, Object versionId) throws Throwable {
        List<IEntityDTO> list;
        IPSDEField orderValuePSDEField;
        IPSDERCustom iPSDERCustom;
        IPSPickupDEField pickupPSDEField = null;
        IPSDEField parentTypePSDEField = null;
        IPSDEField parentSubTypePSDEField = null;
        String strParentType = null;
        String strParentSubType = null;
        IPSDEDataSet nestedPSDEDataSet = null;
        if (iPSDERBase instanceof IPSDER1N) {
            IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
            if ((iPSDER1N.getMasterRS() & PSModelEnums.DER1NMasterRS.VERSION.value) == PSModelEnums.DER1NMasterRS.VERSION.value) {
                pickupPSDEField = ((IPSDER1N)iPSDERBase).getPSPickupDEFieldMust();
                nestedPSDEDataSet = ((IPSDER1N)iPSDERBase).getNestedPSDEDataSet();
            }
        } else if (iPSDERBase instanceof IPSDERCustom && ((iPSDERCustom = (IPSDERCustom)iPSDERBase).getMasterRS() & PSModelEnums.DER1NMasterRS.VERSION.value) == PSModelEnums.DER1NMasterRS.VERSION.value && (this.getDataEntityRuntime().getDEType() == 4 || PSModelEnums.DERSubType.DER1N.value.equalsIgnoreCase(iPSDERCustom.getDERSubType()))) {
            pickupPSDEField = iPSDERCustom.getPickupPSDEField();
            nestedPSDEDataSet = iPSDERCustom.getNestedPSDEDataSet();
            parentTypePSDEField = this.getDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE, this.getDataEntityRuntime().getDEType() != 4);
            if (parentTypePSDEField != null && !StringUtils.hasLength((String)(strParentType = iPSDERCustom.getParentType()))) {
                strParentType = this.getDataEntityRuntime().getName();
            }
            if ((parentSubTypePSDEField = this.getDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTSUBTYPE, true)) != null && !StringUtils.hasLength((String)(strParentSubType = ((IPSDERCustom)iPSDERBase).getParentSubType()))) {
                strParentSubType = iPSDERBase.getMinorCodeName();
            }
        }
        if (pickupPSDEField == null) {
            throw new Exception(String.format("\u4f20\u5165\u5173\u7cfb\u65e0\u6548\uff0c\u672a\u63d0\u4f9b\u8fde\u63a5\u5c5e\u6027", new Object[0]));
        }
        Object key = this.getSystemRuntime().getDataEntityRuntime(iPSDERBase.getMajorPSDataEntityMust().getId()).getKeyFieldValue(parentData);
        LinkedHashMap<Object, IEntityDTO> lastMap = new LinkedHashMap<Object, IEntityDTO>();
        ISearchContextDTO iSearchContextDTO = this.getDataEntityRuntime().createSearchContext();
        iSearchContextDTO.all().count(false);
        this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, (IPSDEField)pickupPSDEField, "EQ", key);
        if (parentTypePSDEField != null) {
            this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentTypePSDEField, "EQ", (Object)strParentType);
        }
        if (parentSubTypePSDEField != null) {
            if (StringUtils.hasLength(strParentSubType)) {
                this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentSubTypePSDEField, "EQ", DataTypeUtils.convert(parentSubTypePSDEField.getStdDataType(), strParentSubType));
            } else {
                this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentSubTypePSDEField, "ISNULL", null);
            }
        }
        if ((orderValuePSDEField = this.getDataEntityRuntime().getOrderValuePSDEField()) != null) {
            this.getDataEntityRuntime().setSearchSort(iSearchContextDTO, orderValuePSDEField, PSModelEnums.SortDir.ASC.value);
        }
        List<IEntityDTO> lastList = null;
        lastList = nestedPSDEDataSet != null ? this.getDataEntityRuntime().selectDataSet(nestedPSDEDataSet, iSearchContextDTO) : this.getDataEntityRuntime().select(iSearchContextDTO);
        if (!ObjectUtils.isEmpty(lastList)) {
            for (IEntityDTO iEntityDTO : lastList) {
                lastMap.put(iEntityDTO.get(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName()), iEntityDTO);
            }
        }
        ArrayList<IEntityDTO> updateList = new ArrayList<IEntityDTO>();
        ArrayList<IEntityDTO> createList = new ArrayList<IEntityDTO>();
        ISearchContextDTO iSearchContextDTO2 = this.getVersionDataEntityRuntime().createSearchContext();
        iSearchContextDTO2.all().count(false);
        this.getVersionDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO2, this.getVersionParentIdPSDEField(), "EQ", key);
        this.getVersionDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO2, this.getVersionParentTypePSDEField(), "EQ", (Object)iPSDERBase.getMajorPSDataEntityMust().getName());
        this.getVersionDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO2, this.getVersionFilterPSDEField(), "EQ", (Object)pickupPSDEField.getName());
        this.getVersionDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO2, this.getVersionParentVersionIdPSDEField(), "EQ", versionId);
        if (this.getVersionOwnerTypePSDEField() != null) {
            this.getVersionDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO2, this.getVersionOwnerTypePSDEField(), "EQ", (Object)this.getDataEntityRuntime().getName());
        }
        if (!ObjectUtils.isEmpty(list = this.getVersionDataEntityRuntime().select(iSearchContextDTO2))) {
            for (IEntityDTO versionData : list) {
                IEntityDTO iEntityDTO = (IEntityDTO)this.getDataEntityRuntime().deserializeEntity(versionData.get(this.getVersionDataPSDEField().getLowerCaseName()));
                Object id = iEntityDTO.get(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName());
                IEntityDTO lastEntityDTO = (IEntityDTO)lastMap.remove(id);
                if (lastEntityDTO != null) {
                    updateList.add(lastEntityDTO);
                    continue;
                }
                createList.add(iEntityDTO);
            }
        }
        if (!ObjectUtils.isEmpty(lastMap)) {
            this.getDataEntityRuntime().rawRemove(new ArrayList<Object>(lastMap.keySet()), true);
        }
        if (!ObjectUtils.isEmpty(updateList)) {
            this.getDataEntityRuntime().rawUpdate(updateList, true);
        }
        if (!ObjectUtils.isEmpty(createList)) {
            this.getDataEntityRuntime().rawCreate(createList, true);
        }
    }

    protected boolean isCurrentVersionId(Object strVersionId) throws Throwable {
        IAppContext iAppContext = ActionSessionManager.getAppContextMust();
        IPSDERBase iPSDERBase = this.getVersionPSDERBase(iAppContext, false);
        Object parentId = ActionSessionManager.getAppContextMust().get(iPSDERBase.getMajorPSDataEntityMust().getName());
        IDataEntityRuntime majorDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDERBase.getMajorPSDataEntityMust().getId());
        IDEVersionControlUtilRuntime iDEVersionControlUtilRuntime = majorDataEntityRuntime.getDEVersionControlUtilRuntime();
        if (iDEVersionControlUtilRuntime == null) {
            throw new Exception(String.format("\u7248\u672c\u63a7\u5236\u4e3b\u5b9e\u4f53[%1$s]\u672a\u63d0\u4f9b\u7248\u672c\u63a7\u5236\u529f\u80fd\u7ec4\u4ef6", majorDataEntityRuntime.getName()));
        }
        return iDEVersionControlUtilRuntime.isCurrentVersionId(parentId, strVersionId);
    }

    protected ISearchCond getSearchCond(IPSDEDQCondition iPSDEDQCondition, Map<String, Object> params) throws Throwable {
        if (iPSDEDQCondition instanceof IPSDEDQGroupCondition) {
            ArrayList<ISearchCond> list = new ArrayList<ISearchCond>();
            IPSDEDQGroupCondition iPSDEDQGroupCondition = (IPSDEDQGroupCondition)iPSDEDQCondition;
            List psDEDQConditions = iPSDEDQGroupCondition.getPSDEDQConditions();
            if (psDEDQConditions != null) {
                for (IPSDEDQCondition item : psDEDQConditions) {
                    ISearchCond iSearchCond = this.getSearchCond(item, params);
                    if (iSearchCond == null) continue;
                    list.add(iSearchCond);
                }
            }
            if (list.size() > 0) {
                SearchGroupCond searchGroupCond = new SearchGroupCond();
                if (iPSDEDQGroupCondition.isNotMode()) {
                    searchGroupCond.setNotMode(true);
                }
                searchGroupCond.setCondOp(iPSDEDQGroupCondition.getCondOp());
                searchGroupCond.getSearchCondsIf().addAll(list);
                return searchGroupCond;
            }
            return null;
        }
        if (iPSDEDQCondition instanceof IPSDEDQFieldCondition) {
            IPSDEDQFieldCondition iPSDEDQFieldCondition = (IPSDEDQFieldCondition)iPSDEDQCondition;
            String strVarType = iPSDEDQFieldCondition.getPSVARTypeId();
            if (StringUtils.hasLength((String)strVarType)) {
                Object objValue = null;
                if (StringUtils.hasLength((String)iPSDEDQFieldCondition.getCondValue())) {
                    objValue = params == null ? null : params.get(iPSDEDQFieldCondition.getCondValue().toLowerCase());
                }
                return this.getSearchCond(iPSDEDQFieldCondition.getFieldName(), iPSDEDQFieldCondition.getCondOp(), objValue);
            }
            Object objValue = iPSDEDQFieldCondition.getCondValue();
            IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(iPSDEDQFieldCondition.getFieldName(), true);
            if (iPSDEField != null) {
                objValue = this.getDataEntityRuntime().convertValue(iPSDEField.getStdDataType(), (String)objValue);
            }
            return this.getSearchCond(iPSDEDQFieldCondition.getFieldName(), iPSDEDQFieldCondition.getCondOp(), objValue);
        }
        log.warn((Object)String.format("\u672a\u652f\u6301\u7684\u641c\u7d22\u6761\u4ef6\u7c7b\u578b[%1$s]", iPSDEDQCondition.getCondType()));
        return null;
    }

    protected ISearchCond getSearchCond(String strFieldName, String strCondition, Object objValue) throws Throwable {
        if (!StringUtils.hasLength((String)strFieldName)) {
            throw new Exception("\u672a\u6307\u5b9a\u5c5e\u6027\u6807\u8bc6");
        }
        strFieldName = strFieldName.toLowerCase();
        SearchFieldCond searchFieldCond = new SearchFieldCond();
        searchFieldCond.setFieldName(strFieldName);
        searchFieldCond.setParamMode(false);
        searchFieldCond.setCondOp(strCondition);
        searchFieldCond.setValue(objValue);
        return searchFieldCond;
    }
}

