/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.action.DEActionLogicRuntimeBase;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.action.IPSDEActionLogic;
import net.ibizsys.runtime.IModelRuntimeShutdownable;
import net.ibizsys.runtime.dataentity.action.IDEActionPluginRuntime;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.INamedAction;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DEMethodPluginRuntimeRepo
implements IModelRuntimeShutdownable {
    private static final Log log = LogFactory.getLog(DEMethodPluginRuntimeRepo.class);
    private ISystemRuntime iSystemRuntime = null;
    private List<Runnable> unregisterActionList = new ArrayList<Runnable>();
    private boolean bUnregisterWhenShutdown = false;

    public void init(ISystemRuntime iSystemRuntime, boolean bUnregisterWhenShutdown) throws Exception {
        Assert.notNull((Object)iSystemRuntime, (String)"\u4f20\u5165\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        this.iSystemRuntime = iSystemRuntime;
        this.bUnregisterWhenShutdown = bUnregisterWhenShutdown;
        this.onInit();
        if (this.bUnregisterWhenShutdown) {
            this.iSystemRuntime.unregisterModelRuntimeShutdownable(this);
        }
    }

    protected void onInit() throws Exception {
    }

    public ISystemRuntime getSystemRuntime() {
        return this.iSystemRuntime;
    }

    protected boolean isUnregisterWhenShutdown() {
        return this.bUnregisterWhenShutdown;
    }

    @Override
    public synchronized void shutdown() throws Exception {
        if (!ObjectUtils.isEmpty(this.unregisterActionList)) {
            for (Runnable runnable : this.unregisterActionList) {
                try {
                    runnable.run();
                }
                catch (Throwable ex) {
                    log.error((Object)ex);
                }
            }
            this.unregisterActionList.clear();
        }
    }

    public synchronized void registerDEActionPluginRuntime(String strDataEntityTag, String strActionTag, final IDEActionPluginRuntime iDEActionPluginRuntime) throws Exception {
        Assert.hasLength((String)strDataEntityTag, (String)"\u672a\u4f20\u5165\u5b9e\u4f53\u6807\u8bb0");
        Assert.hasLength((String)strActionTag, (String)"\u672a\u4f20\u5165\u5b9e\u4f53\u884c\u4e3a\u6807\u8bb0");
        final IDataEntityRuntime iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(strDataEntityTag, true);
        if (iDataEntityRuntime == null) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strDataEntityTag));
        }
        IPSDEAction iPSDEAction = iDataEntityRuntime.getPSDEAction(strActionTag);
        if (iPSDEAction == null) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53\u884c\u4e3a[%1$s.%2$s]\u6a21\u578b\u5bf9\u8c61", strDataEntityTag, strActionTag));
        }
        final String strRealActionTag = iPSDEAction.getName();
        iDataEntityRuntime.registerDEActionPluginRuntime(iPSDEAction.getName(), iDEActionPluginRuntime);
        if (this.isUnregisterWhenShutdown()) {
            this.unregisterActionList.add(new Runnable(){

                @Override
                public void run() {
                    iDataEntityRuntime.unregisterDEActionPluginRuntime(strRealActionTag, iDEActionPluginRuntime);
                }
            });
        }
    }

    public synchronized boolean registerDEActionPluginRuntimeIf(String strDataEntityTag, String strActionTag, final IDEActionPluginRuntime iDEActionPluginRuntime) throws Exception {
        Assert.hasLength((String)strDataEntityTag, (String)"\u672a\u4f20\u5165\u5b9e\u4f53\u6807\u8bb0");
        Assert.hasLength((String)strActionTag, (String)"\u672a\u4f20\u5165\u5b9e\u4f53\u884c\u4e3a\u6807\u8bb0");
        Assert.notNull((Object)iDEActionPluginRuntime, (String)"\u672a\u4f20\u5165\u5b9e\u4f53\u884c\u4e3a\u63d2\u4ef6\u8fd0\u884c\u65f6\u5bf9\u8c61");
        final IDataEntityRuntime iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(strDataEntityTag, true);
        if (iDataEntityRuntime == null) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strDataEntityTag));
        }
        IPSDEAction iPSDEAction = iDataEntityRuntime.getPSDEAction(strActionTag);
        if (iPSDEAction == null) {
            log.warn((Object)String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53\u884c\u4e3a[%1$s.%2$s]\u6a21\u578b\u5bf9\u8c61\uff0c\u5ffd\u7565\u6ce8\u518c\u63d2\u4ef6", strDataEntityTag, strActionTag));
            return false;
        }
        if (!"USERCUSTOM".equalsIgnoreCase(iPSDEAction.getActionType())) {
            log.warn((Object)String.format("\u5b9e\u4f53\u884c\u4e3a[%1$s.%2$s]\u7c7b\u578b\u4e0d\u662f[\u7528\u6237\u81ea\u5b9a\u4e49]\uff0c\u5ffd\u7565\u6ce8\u518c\u63d2\u4ef6", strDataEntityTag, strActionTag));
            return false;
        }
        final String strRealActionTag = iPSDEAction.getName();
        iDataEntityRuntime.registerDEActionPluginRuntime(iPSDEAction.getName(), iDEActionPluginRuntime);
        if (this.isUnregisterWhenShutdown()) {
            this.unregisterActionList.add(new Runnable(){

                @Override
                public void run() {
                    iDataEntityRuntime.unregisterDEActionPluginRuntime(strRealActionTag, iDEActionPluginRuntime);
                }
            });
        }
        return true;
    }

    public synchronized boolean registerDEActionLogicRuntimeIf(String strDataEntityTag, String strActionTag, final String strAttachMode, final IAction iAction) throws Exception {
        Assert.hasLength((String)strDataEntityTag, (String)"\u672a\u4f20\u5165\u5b9e\u4f53\u6807\u8bb0");
        Assert.hasLength((String)strActionTag, (String)"\u672a\u4f20\u5165\u5b9e\u4f53\u884c\u4e3a\u6807\u8bb0");
        Assert.hasLength((String)strAttachMode, (String)"\u672a\u4f20\u5165\u5b9e\u4f53\u884c\u4e3a\u903b\u8f91\u9644\u52a0\u6a21\u5f0f");
        Assert.notNull((Object)iAction, (String)"\u672a\u4f20\u5165\u5b9e\u4f53\u884c\u4e3a\u903b\u8f91\u884c\u4e3a\u5bf9\u8c61");
        final IDataEntityRuntime iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(strDataEntityTag, true);
        if (iDataEntityRuntime == null) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strDataEntityTag));
        }
        IPSDEAction iPSDEAction = iDataEntityRuntime.getPSDEAction(strActionTag);
        if (iPSDEAction == null) {
            log.warn((Object)String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53\u884c\u4e3a[%1$s.%2$s]\u6a21\u578b\u5bf9\u8c61", strDataEntityTag, strActionTag));
            return false;
        }
        final DEActionLogicRuntimeBase iDEActionLogicRuntime = new DEActionLogicRuntimeBase(){

            @Override
            public String getId() {
                return KeyValueUtils.genGuidEx();
            }

            @Override
            public String getName() {
                if (iAction instanceof INamedAction) {
                    return ((INamedAction)iAction).getName();
                }
                return "\u884c\u4e3a\u9644\u52a0\u903b\u8f91";
            }

            @Override
            public IPSDEActionLogic getPSDEActionLogic() {
                throw new RuntimeException("\u672a\u652f\u6301");
            }

            @Override
            public IPSModelObject getPSModelObject() {
                throw new RuntimeException("\u672a\u652f\u6301");
            }

            @Override
            public String getAttachMode() {
                return strAttachMode;
            }

            @Override
            public Object execute(IEntityBase iEntityBase) throws Throwable {
                return iAction.execute(new Object[]{iEntityBase});
            }
        };
        final String strRealActionTag = iPSDEAction.getName();
        iDataEntityRuntime.registerDEActionLogicRuntime(iPSDEAction.getName(), iDEActionLogicRuntime);
        if (this.isUnregisterWhenShutdown()) {
            this.unregisterActionList.add(new Runnable(){

                @Override
                public void run() {
                    iDataEntityRuntime.unregisterDEActionLogicRuntime(strRealActionTag, iDEActionLogicRuntime);
                }
            });
        }
        return true;
    }
}

