/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.security.dr;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.security.dr.IDataEntityDRProvider;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.dataentity.priv.IPSDEUserRole;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public abstract class DataEntityDRProviderBase
implements IDataEntityDRProvider {
    private static final Log log = LogFactory.getLog(DataEntityDRProviderBase.class);

    @Override
    public boolean isSupportMerge() {
        return false;
    }

    @Override
    public IPSDEUserRole merge(IPSDEUserRole mergePSDEUserRole, Collection<IPSDEUserRole> iPSDEUserRoles) {
        return mergePSDEUserRole;
    }

    @Override
    public List<ISearchCond> getDRSearchConds(IDataEntityRuntime iDataEntityRuntime, Collection<IPSDEUserRole> iPSDEUserRoles, String action) {
        if (this.isSupportMerge()) {
            IPSDEUserRole mergePSDEUserRole = this.createPSDEUserRole(iDataEntityRuntime);
            this.merge(mergePSDEUserRole, iPSDEUserRoles);
            return this.getDRSearchConds(iDataEntityRuntime, mergePSDEUserRole, action);
        }
        ArrayList<ISearchCond> searchConds = new ArrayList<ISearchCond>();
        iPSDEUserRoles.stream().forEach(iPSDEUserRole -> {
            List<ISearchCond> itemSearchConds;
            if (this.support((IPSDEUserRole)iPSDEUserRole) && !ObjectUtils.isEmpty(itemSearchConds = this.getDRSearchConds(iDataEntityRuntime, (IPSDEUserRole)iPSDEUserRole, action))) {
                searchConds.addAll(itemSearchConds);
            }
        });
        return searchConds;
    }

    protected IPSDEUserRole createPSDEUserRole(IDataEntityRuntime iDataEntityRuntime) {
        ObjectNode objNode = JsonUtils.createObjectNode();
        IPSDEUserRole iPSDEUserRole = null;
        try {
            iPSDEUserRole = (IPSDEUserRole)iDataEntityRuntime.getSystemRuntime().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)iDataEntityRuntime.getPSDataEntity(), IPSDEUserRole.class, objNode);
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return iPSDEUserRole;
    }
}

