/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.report;

import java.io.OutputStream;
import java.util.List;
import net.ibizsys.central.bi.ISysBICubeRuntime;
import net.ibizsys.central.bi.ISysBISchemeRuntime;
import net.ibizsys.central.bi.util.BISearchContext;
import net.ibizsys.central.dataentity.report.DEReportRuntimeBase;
import net.ibizsys.central.dataentity.report.IDEBIReportRuntime;
import net.ibizsys.central.service.client.WebClientBase;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.ErrorException;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class DEBIReportRuntimeBase
extends DEReportRuntimeBase
implements IDEBIReportRuntime {
    private static final Log log = LogFactory.getLog(DEBIReportRuntimeBase.class);
    private ISysBISchemeRuntime iSysBISchemeRuntime = null;

    @Override
    protected void onInit() throws Exception {
        if (this.getSysBISchemeRuntime(true) == null) {
            this.prepareSysBISchemeRuntime();
            this.getSysBISchemeRuntime(false);
        }
        super.onInit();
    }

    public ISysBISchemeRuntime getSysBISchemeRuntime() {
        try {
            return this.getSysBISchemeRuntime(false);
        }
        catch (Exception ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, ex.getMessage(), (Throwable)ex);
        }
    }

    protected ISysBISchemeRuntime getSysBISchemeRuntime(boolean bTryMode) throws Exception {
        if (this.iSysBISchemeRuntime != null || bTryMode) {
            return this.iSysBISchemeRuntime;
        }
        throw new Exception("\u7cfb\u7edf\u667a\u80fd\u62a5\u8868\u4f53\u7cfb\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
    }

    protected void setSysBISchemeRuntime(ISysBISchemeRuntime iSysBISchemeRuntime) {
        this.iSysBISchemeRuntime = iSysBISchemeRuntime;
    }

    protected void prepareSysBISchemeRuntime() throws Exception {
        this.setSysBISchemeRuntime(this.getSystemRuntime().getSysBISchemeRuntime(this.getPSDEReport().getPSSysBISchemeMust()));
    }

    @Override
    protected void prepareReportFilePath() throws Exception {
    }

    @Override
    protected List<? extends IEntityBase> searchDataSet(IPSDEDataSet iPSDEDataSet, ISearchContextBase iSearchContextBase) {
        return null;
    }

    @Override
    protected void onOutput(OutputStream outputStream, Object data, ISearchContext iSearchContext, String strType) throws Throwable {
        BISearchContext biSearchContext = new BISearchContext(iSearchContext);
        if (!StringUtils.hasLength((String)biSearchContext.getBICubeTag())) {
            throw new Exception("\u672a\u4f20\u5165\u667a\u80fd\u7acb\u65b9\u4f53\u6807\u8bb0");
        }
        ISysBICubeRuntime iSysBICubeRuntime = this.getSysBISchemeRuntime().getSysBICubeRuntime(biSearchContext.getBICubeTag(), true);
        if (iSysBICubeRuntime == null) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u667a\u80fd\u7acb\u65b9\u4f53[%1$s]", biSearchContext.getBICubeTag()));
        }
        if (StringUtils.hasLength((String)iSysBICubeRuntime.getAccessKey()) && !this.getSystemRuntime().getSystemAccessManager().testSysUniRes(UserContext.getCurrent(), iSysBICubeRuntime.getAccessKey())) {
            throw new ErrorException(String.format("\u667a\u80fd\u62a5\u8868\u7acb\u65b9\u4f53[%1$s]\u4e0d\u5177\u5907\u8bbf\u95ee\u63a7\u5236\u8d44\u6e90[%2$s]", iSysBICubeRuntime.getName(), iSysBICubeRuntime.getAccessKey()), 2);
        }
        List list = iSysBICubeRuntime.fetch(biSearchContext);
        WebClientBase.MAPPER.writeValue(outputStream, (Object)list);
    }
}

