/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.notify;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.IDynaInstRuntime;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.IDynaInstDataEntityRuntime;
import net.ibizsys.central.dataentity.notify.IDENotifyRuntime;
import net.ibizsys.central.dataentity.util.IDENotifySettingUtilRuntime;
import net.ibizsys.central.msg.ISysMsgTemplRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.notify.IPSDENotifyTarget;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.notify.DENotifyRuntime;
import net.ibizsys.runtime.msg.ISysMsgTargetRuntime;
import net.ibizsys.runtime.util.ASFutureActionBase;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.domain.MsgSendQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DENotifyRuntimeBase
extends DENotifyRuntime
implements IDENotifyRuntime {
    private static final Log log = LogFactory.getLog(DENotifyRuntimeBase.class);
    public static final int[] MSGTYPES = new int[]{64, 2, 16, 1, 8, 4, 256, 512, 32, 128};
    private String strDENotifyTag = null;

    @Override
    protected void onInit() throws Exception {
        this.strDENotifyTag = PSModelUtils.calcFullUniqueTag2((IPSModelObject)this.getPSDENotify());
        super.onInit();
    }

    protected String getDENotifyTag() {
        return this.strDENotifyTag;
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime() {
        return (IDataEntityRuntime)super.getDataEntityRuntime();
    }

    @Override
    public IDynaInstDataEntityRuntime getDynaInstDataEntityRuntime() {
        return (IDynaInstDataEntityRuntime)super.getDynaInstDataEntityRuntime();
    }

    @Override
    public ISystemRuntime getSystemRuntime() {
        return (ISystemRuntime)super.getSystemRuntime();
    }

    @Override
    public IDynaInstRuntime getDynaInstRuntime() {
        return (IDynaInstRuntime)super.getDynaInstRuntime();
    }

    protected String getCodeItemTextSuffix() {
        return "text";
    }

    protected boolean isCloneParam() {
        return true;
    }

    @Override
    public void send(IEntityBase iEntityBase) {
        if (iEntityBase instanceof IEntity) {
            this.send((IEntity)iEntityBase, null);
            return;
        }
        super.send(iEntityBase);
    }

    @Override
    public void send(IEntity iEntity, Map<String, Object> params) {
        try {
            Object last;
            IEntity lastEntity = null;
            if (params != null && (last = params.get("last")) instanceof IEntity) {
                lastEntity = (IEntity)last;
            }
            if (this.isCloneParam()) {
                IEntityDTO cloneEntityDTO;
                IEntityDTO cloneEntityDTO2;
                IEntityDTO originEntityDTO;
                if (iEntity instanceof IEntityDTO) {
                    originEntityDTO = (IEntityDTO)iEntity;
                    cloneEntityDTO2 = this.getDataEntityRuntime().createEntity();
                    originEntityDTO.copyTo(cloneEntityDTO2, originEntityDTO.getDEMethodDTORuntime() != null);
                    iEntity = cloneEntityDTO2;
                } else {
                    cloneEntityDTO = this.getDataEntityRuntime().createEntity();
                    iEntity.copyTo(cloneEntityDTO);
                    iEntity = cloneEntityDTO;
                }
                if (lastEntity != null) {
                    if (lastEntity instanceof IEntityDTO) {
                        originEntityDTO = (IEntityDTO)lastEntity;
                        cloneEntityDTO2 = this.getDataEntityRuntime().createEntity();
                        originEntityDTO.copyTo(cloneEntityDTO2, originEntityDTO.getDEMethodDTORuntime() != null);
                        lastEntity = cloneEntityDTO2;
                    } else {
                        cloneEntityDTO = this.getDataEntityRuntime().createEntity();
                        lastEntity.copyTo(cloneEntityDTO);
                        lastEntity = cloneEntityDTO;
                    }
                    params.put("last", lastEntity);
                }
            }
            this.getDataEntityRuntime().fillEntityCodeListTexts(iEntity, this.getCodeItemTextSuffix());
            if (lastEntity != null) {
                this.getDataEntityRuntime().fillEntityCodeListTexts(lastEntity, this.getCodeItemTextSuffix());
            }
            this.onSend(iEntity, params);
        }
        catch (Throwable ex) {
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u53d1\u9001\u901a\u77e5\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void onSend(IEntity iEntity, Map<String, Object> params) throws Throwable {
        final MsgSendQueue[] msgSendQueues = this.getMsgSendQueues(iEntity, params);
        if (msgSendQueues == null || msgSendQueues.length == 0) {
            return;
        }
        ActionSession actionSession = ActionSessionManager.getCurrentSession();
        if (actionSession == null) {
            this.getSysMsgQueueRuntime().send(msgSendQueues);
        } else {
            final String strId = JsonUtils.toString(msgSendQueues);
            actionSession.registerFutureAction(new ASFutureActionBase(){

                @Override
                public String getId() {
                    return strId;
                }

                @Override
                public void commit() {
                    DENotifyRuntimeBase.this.getSysMsgQueueRuntime().send(msgSendQueues);
                }
            }, true);
        }
    }

    protected MsgSendQueue[] getMsgSendQueues(IEntity iEntity, Map<String, Object> params) throws Throwable {
        IDENotifySettingUtilRuntime iDENotifySettingUtilRuntime;
        Map<String, String> result;
        int nMsgType = this.getPSDENotify().getMsgType();
        if (nMsgType == 0) {
            log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u901a\u77e5[%2$s]\u6ca1\u6709\u6307\u5b9a\u6d88\u606f\u7c7b\u578b\uff0c\u5ffd\u7565\u5efa\u7acb\u901a\u77e5\u6d88\u606f", this.getDataEntityRuntime().getId(), this.getName()));
            return null;
        }
        HashMap<String, Object> targetMap = new HashMap<String, Object>();
        if (this.getDETargets() != null) {
            for (Map.Entry entry : this.getDETargets().entrySet()) {
                String strTargetId = DataTypeUtils.getStringValue(this.getDataEntityRuntime().getFieldValue((IEntityBase)iEntity, (IPSDEField)entry.getKey()), null);
                if (!StringUtils.hasLength((String)strTargetId)) continue;
                Object strTargetType = null;
                if (entry.getValue() != null) {
                    strTargetType = DataTypeUtils.getStringValue(this.getDataEntityRuntime().getFieldValue((IEntityBase)iEntity, (IPSDEField)entry.getValue()), null);
                }
                targetMap.put(strTargetId, strTargetType);
            }
        }
        if (this.getSysMsgTargetRuntimes() != null) {
            for (ISysMsgTargetRuntime iSysMsgTargetRuntime : this.getSysMsgTargetRuntimes()) {
                result = iSysMsgTargetRuntime.get(iEntity);
                if (result == null) continue;
                targetMap.putAll(result);
            }
        }
        for (IPSDENotifyTarget iPSDENotifyTarget : this.getPSDENotifyTargets()) {
            result = this.getTarget(iPSDENotifyTarget, iEntity, params);
            if (result == null) continue;
            targetMap.putAll(result);
        }
        if (targetMap.size() == 0) {
            log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u901a\u77e5[%2$s]\u6ca1\u6709\u4efb\u4f55\u901a\u77e5\u76ee\u6807\uff0c\u5ffd\u7565\u5efa\u7acb\u901a\u77e5\u6d88\u606f", this.getDataEntityRuntime().getId(), this.getName()));
            return null;
        }
        MsgSendQueue msgSendQueue = this.fillMsgSendQueue(null, iEntity, params);
        IDENotifySettingUtilRuntime iDENotifySettingUtilRuntime2 = iDENotifySettingUtilRuntime = this.getDataEntityRuntime().isEnableNotifySetting() ? this.getDataEntityRuntime().getDENotifySettingUtilRuntime() : null;
        if (iDENotifySettingUtilRuntime == null) {
            ArrayNode array = JsonUtils.createArrayNode();
            for (Map.Entry entry : targetMap.entrySet()) {
                array.add((String)entry.getKey());
            }
            msgSendQueue.setDstUsers(array.toString());
            return new MsgSendQueue[]{msgSendQueue};
        }
        ArrayList<MsgSendQueue> list = new ArrayList<MsgSendQueue>();
        Map<String, Integer> settings = iDENotifySettingUtilRuntime.getSettings(iEntity, this.getDENotifyTag(), nMsgType, targetMap.keySet());
        for (int nType : MSGTYPES) {
            if ((nMsgType & nType) == 0) continue;
            ArrayNode array = JsonUtils.createArrayNode();
            for (Map.Entry<String, Integer> entry : settings.entrySet()) {
                if (entry.getValue() != null && (entry.getValue() & nType) != nType) continue;
                array.add(entry.getKey());
            }
            if (array.size() == 0) continue;
            MsgSendQueue msgSendQueue2 = new MsgSendQueue();
            msgSendQueue.copyTo(msgSendQueue2);
            msgSendQueue2.setMsgType(nType);
            msgSendQueue2.setDstUsers(array.toString());
            list.add(msgSendQueue2);
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new MsgSendQueue[list.size()]);
    }

    protected MsgSendQueue fillMsgSendQueue(MsgSendQueue msgSendQueue, IEntity iEntity, Map<String, Object> params) throws Throwable {
        Object last;
        if (msgSendQueue == null) {
            msgSendQueue = new MsgSendQueue();
        }
        int nMsgType = this.getPSDENotify().getMsgType();
        IEntityBase data = iEntity;
        data = this.getDataEntityRuntime().createScriptEntity(iEntity);
        if (params != null && (last = params.get("last")) instanceof IEntity) {
            last = this.getDataEntityRuntime().createScriptEntity((IEntity)last);
            params.put("last", last);
        }
        ISysMsgTemplRuntime iSysMsgTemplRuntime = null;
        if (this.getSysMsgTemplRuntime() instanceof ISysMsgTemplRuntime) {
            iSysMsgTemplRuntime = (ISysMsgTemplRuntime)this.getSysMsgTemplRuntime();
        }
        msgSendQueue.setMsgType(nMsgType);
        msgSendQueue.setTemplateId(this.getSysMsgTemplRuntime().getPSSysMsgTempl().getCodeName());
        if (iSysMsgTemplRuntime != null) {
            msgSendQueue.setSubject(iSysMsgTemplRuntime.getSubject(data, params));
            msgSendQueue.setUrl(iSysMsgTemplRuntime.getUrl(data, params));
            msgSendQueue.setMobileUrl(iSysMsgTemplRuntime.getMobileUrl(data, params));
        } else {
            msgSendQueue.setSubject(this.getSysMsgTemplRuntime().getSubject(data));
            msgSendQueue.setUrl(this.getSysMsgTemplRuntime().getUrl(data));
            msgSendQueue.setMobileUrl(this.getSysMsgTemplRuntime().getMobileUrl(data));
        }
        if ((nMsgType & 3) != 0) {
            msgSendQueue.setContentType(this.getSysMsgTemplRuntime().getContentType());
            if (iSysMsgTemplRuntime != null) {
                msgSendQueue.setContent(iSysMsgTemplRuntime.getContent(data, params));
            } else {
                msgSendQueue.setContent(this.getSysMsgTemplRuntime().getContent(data));
            }
        }
        if ((nMsgType & 4) != 0) {
            if (iSysMsgTemplRuntime != null) {
                msgSendQueue.setSMSContent(iSysMsgTemplRuntime.getSMSContent(data, params));
            } else {
                msgSendQueue.setSMSContent(this.getSysMsgTemplRuntime().getSMSContent(data));
            }
        }
        if ((nMsgType & 0x18) != 0) {
            if (iSysMsgTemplRuntime != null) {
                msgSendQueue.setIMContent(iSysMsgTemplRuntime.getIMContent(data, params));
            } else {
                msgSendQueue.setIMContent(this.getSysMsgTemplRuntime().getIMContent(data));
            }
        }
        if ((nMsgType & 0x20) != 0) {
            if (iSysMsgTemplRuntime != null) {
                msgSendQueue.setWXContent(iSysMsgTemplRuntime.getWXContent(data, params));
            } else {
                msgSendQueue.setWXContent(this.getSysMsgTemplRuntime().getWXContent(data));
            }
        }
        if ((nMsgType & 0x40) != 0) {
            if (iSysMsgTemplRuntime != null) {
                msgSendQueue.setDDContent(iSysMsgTemplRuntime.getDDContent(data, params));
            } else {
                msgSendQueue.setDDContent(this.getSysMsgTemplRuntime().getDDContent(data));
            }
        }
        return msgSendQueue;
    }

    protected Map<String, String> getTarget(IPSDENotifyTarget iPSDENotifyTarget, IEntity iEntity, Map<String, Object> params) throws Throwable {
        if (PSModelEnums.DENotifyTargetType.EVENTDATAFIELD.value.equals(iPSDENotifyTarget.getTargetType())) {
            String strData = iPSDENotifyTarget.getData();
            if (!StringUtils.hasLength((String)strData)) {
                throw new Exception(String.format("\u672a\u6307\u5b9a\u4e8b\u4ef6\u6570\u636e\u5bf9\u8c61\u5c5e\u6027", new Object[0]));
            }
            if (params != null) {
                LinkedHashMap<String, String> targetMap = new LinkedHashMap<String, String>();
                Object eventData = params.get("eventdata");
                if (eventData instanceof IEntity) {
                    String[] fields = strData.replace(";", ",").split("[,]");
                    IEntity eventEntity = (IEntity)eventData;
                    for (String field : fields) {
                        String strRealFieldName = PSModelUtils.getSimpleId((String)field);
                        Object objUserId = eventEntity.get(strRealFieldName);
                        if (objUserId == null) continue;
                        targetMap.put(objUserId.toString(), "");
                    }
                }
                return targetMap;
            }
            return null;
        }
        if (PSModelEnums.DENotifyTargetType.DSTUSER.value.equals(iPSDENotifyTarget.getTargetType())) {
            String strData = iPSDENotifyTarget.getData();
            if (!StringUtils.hasLength((String)strData)) {
                throw new Exception(String.format("\u672a\u6307\u5b9a\u76ee\u6807\u7528\u6237", new Object[0]));
            }
            List list = JsonUtils.asList(strData);
            if (!ObjectUtils.isEmpty((Object)list)) {
                LinkedHashMap<String, String> targetMap = new LinkedHashMap<String, String>();
                for (Object item : list) {
                    Object objUserId = null;
                    objUserId = item instanceof Map ? ((Map)item).get("id") : DataTypeUtils.asSimple(item);
                    if (objUserId == null) continue;
                    targetMap.put(objUserId.toString(), "");
                }
                return targetMap;
            }
            return null;
        }
        return super.getTarget(iPSDENotifyTarget, iEntity);
    }
}

