/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.ds;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.database.IDBDialect;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntimeContext;
import net.ibizsys.central.dataentity.ds.IDEDataQueryCodeRuntime;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.ds.IPSDEDQCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQFieldCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQGroupCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCodeExp;
import net.ibizsys.runtime.ModelRuntimeBase;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DEDataQueryCodeRuntime
extends ModelRuntimeBase
implements IDEDataQueryCodeRuntime {
    private static final Log log = LogFactory.getLog(DEDataQueryCodeRuntime.class);
    private IDataEntityRuntimeContext iDataEntityRuntimeContext = null;
    private IPSDEDataQueryCode iPSDEDataQueryCode = null;
    private IPSDEDataQuery iPSDEDataQuery = null;
    private IDBDialect iDBDialect = null;
    private Map<String, IPSDEDataQueryCodeExp> psDEDataQueryCodeExpMap = new HashMap<String, IPSDEDataQueryCodeExp>();

    @Override
    public void init(IDataEntityRuntimeContext iDataEntityRuntimeContext, IPSDEDataQuery iPSDEDataQuery, IPSDEDataQueryCode iPSDEDataQueryCode) throws Exception {
        this.iDataEntityRuntimeContext = iDataEntityRuntimeContext;
        this.iPSDEDataQueryCode = iPSDEDataQueryCode;
        this.iPSDEDataQuery = iPSDEDataQuery;
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        this.iDBDialect = this.getDataEntityRuntimeContext().getDataEntityRuntime().getSystemRuntime().getDBDialect(this.getPSDEDataQueryCode().getDBType());
        List psDEDataQueryCodeExpList = this.getPSDEDataQueryCode().getPSDEDataQueryCodeExps();
        if (psDEDataQueryCodeExpList != null) {
            for (IPSDEDataQueryCodeExp iPSDEDataQueryCodeExp : psDEDataQueryCodeExpList) {
                this.psDEDataQueryCodeExpMap.put(iPSDEDataQueryCodeExp.getName().toUpperCase(), iPSDEDataQueryCodeExp);
            }
        }
        super.onInit();
    }

    @Override
    public IPSDEDataQueryCode getPSDEDataQueryCode() {
        return this.iPSDEDataQueryCode;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSDEDataQueryCode();
    }

    @Override
    public IPSDEDataQuery getPSDEDataQuery() {
        return this.iPSDEDataQuery;
    }

    protected IDataEntityRuntimeContext getDataEntityRuntimeContext() {
        return this.iDataEntityRuntimeContext;
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime() {
        return this.getDataEntityRuntimeContext().getDataEntityRuntime();
    }

    @Override
    public IPSDEDataQueryCodeExp getPSDEDataQueryCodeExp(String strName, boolean bTryMode) {
        IPSDEDataQueryCodeExp iPSDEDataQueryCodeExp = this.psDEDataQueryCodeExpMap.get(strName.toUpperCase());
        if (iPSDEDataQueryCodeExp != null || bTryMode) {
            return iPSDEDataQueryCodeExp;
        }
        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntimeContext().getDataEntityRuntime(), this, String.format("\u5b9e\u4f53\u67e5\u8be2[%1$s]\u4ee3\u7801[%2$s]\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u8868\u8fbe\u5f0f", this.getPSDEDataQuery().getName(), this.getPSDEDataQueryCode().getDBType(), strName));
    }

    @Override
    public IDBDialect getDBDialect() {
        return this.iDBDialect;
    }

    protected void fillIgnorePSDEDQFieldConditions(Map<String, IPSDEDQFieldCondition> ignorePSDEDQFieldConditionMap, IPSDEDQCondition iPSDEDQCondition) throws Exception {
        String strType = iPSDEDQCondition.getCondType();
        if (PSModelEnums.CondType.SINGLE.value.equalsIgnoreCase(strType)) {
            IPSDEDQFieldCondition iPSDEDQFieldCondition = (IPSDEDQFieldCondition)iPSDEDQCondition;
            if (iPSDEDQFieldCondition.isIgnoreOthers() && StringUtils.hasLength((String)iPSDEDQFieldCondition.getFieldName())) {
                ignorePSDEDQFieldConditionMap.put(iPSDEDQFieldCondition.getFieldName().toUpperCase(), iPSDEDQFieldCondition);
            }
            return;
        }
        if (PSModelEnums.CondType.GROUP.value.equalsIgnoreCase(strType)) {
            IPSDEDQGroupCondition iPSDEDQGroupCondition = (IPSDEDQGroupCondition)iPSDEDQCondition;
            List childPSDEDQConditions = iPSDEDQGroupCondition.getPSDEDQConditions();
            if (ObjectUtils.isEmpty((Object)childPSDEDQConditions)) {
                return;
            }
            for (IPSDEDQCondition childPSDEDQCondition : childPSDEDQConditions) {
                this.fillIgnorePSDEDQFieldConditions(ignorePSDEDQFieldConditionMap, childPSDEDQCondition);
            }
            return;
        }
    }
}

