/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.ds;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ibizsys.central.database.IDBDialect;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.ds.DEDQSQLCustomCondParserBase;
import net.ibizsys.central.dataentity.ds.IDEDQSQLSelectParser;
import net.ibizsys.central.dataentity.ds.IDEDataQueryCodeRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public abstract class DEDQSQLSelectParserBase
implements IDEDQSQLSelectParser {
    private static final Log log = LogFactory.getLog(DEDQSQLCustomCondParserBase.class);
    private static final Pattern Regex = Pattern.compile("#(\\{.*?\\})");

    protected Pattern getPattern() {
        return Regex;
    }

    protected String getRealSQLCode(String strSQL) {
        Matcher matcher = this.getPattern().matcher(strSQL);
        LinkedHashMap<String, String> replaceContentMap = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            String json = matcher.group(1);
            replaceContentMap.put(String.format("#%1$s", json), "REPLACE_FUNC");
        }
        if (replaceContentMap.size() > 0) {
            for (Map.Entry entry : replaceContentMap.entrySet()) {
                strSQL = strSQL.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        return strSQL;
    }

    @Override
    public String reselect(String strSQL, Set<String> columnList, IDBDialect iDBDialect, IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime) throws Throwable {
        Assert.hasLength((String)strSQL, (String)"\u4f20\u5165\u5206\u6790SQL\u65e0\u6548");
        Assert.notEmpty(columnList, (String)"\u4f20\u5165\u91cd\u65b0\u9009\u62e9\u5217\u5217\u8868\u65e0\u6548");
        Assert.notNull((Object)iDBDialect, (String)"\u4f20\u5165\u6570\u636e\u5e93\u8bbe\u914d\u5668\u5bf9\u8c61\u65e0\u6548");
        return this.onReselect(strSQL, columnList, iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime);
    }

    protected abstract String onReselect(String var1, Set<String> var2, IDBDialect var3, IDataEntityRuntime var4, IDEDataQueryCodeRuntime var5) throws Throwable;
}

