/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.ds;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ibizsys.central.database.IDBDialect;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.ds.IDEDQSQLCustomCondParser;
import net.ibizsys.central.dataentity.ds.IDEDataQueryCodeRuntime;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.runtime.util.ISearchCustomCond;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public abstract class DEDQSQLCustomCondParserBase
implements IDEDQSQLCustomCondParser {
    private static final Log log = LogFactory.getLog(DEDQSQLCustomCondParserBase.class);
    private static final Pattern DynaCondRegex = Pattern.compile("\\#(\\{.*?\\})");

    protected Pattern getDynaCondPattern() {
        return DynaCondRegex;
    }

    protected String getRealSQLCode(String strSQL) {
        Matcher matcher = this.getDynaCondPattern().matcher(strSQL);
        LinkedHashMap<String, String> replaceContentMap = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            String json = matcher.group(1);
            replaceContentMap.put(String.format("#%1$s", json), "REPLACE_FUNC");
        }
        if (replaceContentMap.size() > 0) {
            for (Map.Entry entry : replaceContentMap.entrySet()) {
                strSQL = strSQL.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        return strSQL;
    }

    @Override
    public String parse(ISearchCustomCond iSearchCustomCond, IDBDialect iDBDialect, IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext) throws Throwable {
        return this.parse(iSearchCustomCond, iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, null);
    }

    @Override
    public String parse(ISearchCustomCond iSearchCustomCond, IDBDialect iDBDialect, IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext, Map<String, Object> params) throws Throwable {
        return this.parse(iSearchCustomCond, iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, params, null);
    }

    @Override
    public String parse(ISearchCustomCond iSearchCustomCond, IDBDialect iDBDialect, IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext, Map<String, Object> params, Set<String> relatedColumnList) throws Throwable {
        Assert.notNull((Object)iSearchCustomCond, (String)"\u4f20\u5165\u81ea\u5b9a\u4e49\u6761\u4ef6\u5bf9\u8c61\u65e0\u6548");
        Assert.hasLength((String)iSearchCustomCond.getCustomCond(), (String)"\u4f20\u5165\u81ea\u5b9a\u4e49\u6761\u4ef6\u5bf9\u8c61\u6761\u4ef6\u65e0\u6548");
        Assert.notNull((Object)iDBDialect, (String)"\u4f20\u5165\u6570\u636e\u5e93\u8bbe\u914d\u5668\u5bf9\u8c61\u65e0\u6548");
        return this.onParse(iSearchCustomCond, iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, params, relatedColumnList);
    }

    protected abstract String onParse(ISearchCustomCond var1, IDBDialect var2, IDataEntityRuntime var3, IDEDataQueryCodeRuntime var4, ISearchContext var5, Map<String, Object> var6, Set<String> var7) throws Throwable;
}

